/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class RetryerUtils {
    private static Retryer<Boolean> defaultRetryerResultCheck;
    private static Retryer<Boolean> defaultRetryerResultNoCheck;

    private RetryerUtils() {
        throw new UnsupportedOperationException("Construct RetryerUtils");
    }

    private static Retryer<Boolean> getDefaultRetryerResultNoCheck() {
        if (defaultRetryerResultNoCheck == null) {
            defaultRetryerResultNoCheck = RetryerBuilder.newBuilder().retryIfException().withWaitStrategy(WaitStrategies.fixedWait((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
        }
        return defaultRetryerResultNoCheck;
    }

    public static Retryer<Boolean> getDefaultRetryer(boolean checkResult) {
        return checkResult ? RetryerUtils.getDefaultRetryer() : RetryerUtils.getDefaultRetryerResultNoCheck();
    }

    public static Retryer<Boolean> getDefaultRetryer() {
        if (defaultRetryerResultCheck == null) {
            defaultRetryerResultCheck = RetryerBuilder.newBuilder().retryIfResult(Boolean.FALSE::equals).retryIfException().withWaitStrategy(WaitStrategies.fixedWait((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
        }
        return defaultRetryerResultCheck;
    }

    public static Boolean retryCall(Callable<Boolean> callable, boolean checkResult) throws ExecutionException, RetryException {
        return (Boolean)RetryerUtils.getDefaultRetryer(checkResult).call(callable);
    }

    public static Boolean retryCall(Callable<Boolean> callable) throws ExecutionException, RetryException {
        return RetryerUtils.retryCall(callable, true);
    }
}

