/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");

    private LoggerUtils() {
        throw new UnsupportedOperationException("Construct LoggerUtils");
    }

    public static String buildTaskId(Date firstSubmitTime, Long processDefineCode, int processDefineVersion, int processInstId, int taskId) {
        String firstSubmitTimeStr = DateUtils.format(firstSubmitTime, "yyyyMMdd", null);
        return String.format("%s=%s-%s-%s_%s-%s-%s", "taskAppId", "TASK", firstSubmitTimeStr, processDefineCode, processDefineVersion, processInstId, taskId);
    }

    public static List<String> getAppIds(String log, Logger logger) {
        ArrayList<String> appIds = new ArrayList<String>();
        Matcher matcher = APPLICATION_REGEX.matcher(log);
        while (matcher.find()) {
            String appId = matcher.group();
            if (appIds.contains(appId)) continue;
            logger.info("find app id: {}", (Object)appId);
            appIds.add(appId);
        }
        return appIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWholeFileContent(String filePath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file error", (Throwable)e);
            return "";
        }
    }
}

