/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.storage.StorageOperate;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.jets3t.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Utils
implements Closeable,
StorageOperate {
    private static final Logger logger = LoggerFactory.getLogger(S3Utils.class);
    public static final String ACCESS_KEY_ID = PropertyUtils.getString("aws.access.key.id");
    public static final String SECRET_KEY_ID = PropertyUtils.getString("aws.secret.access.key");
    public static final String REGION = PropertyUtils.getString("aws.region");
    private AmazonS3 s3Client = null;

    private S3Utils() {
        if (PropertyUtils.getString("resource.storage.type").equals("S3")) {
            this.s3Client = !StringUtils.isEmpty((String)PropertyUtils.getString("aws.endpoint")) ? (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(PropertyUtils.getString("aws.endpoint"), Regions.fromName((String)REGION).getName()))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(ACCESS_KEY_ID, SECRET_KEY_ID)))).build() : (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(ACCESS_KEY_ID, SECRET_KEY_ID)))).withRegion(Regions.fromName((String)REGION))).build();
            this.checkBucketNameIfNotPresent("dolphinscheduler-test");
        }
    }

    public static S3Utils getInstance() {
        return S3Singleton.INSTANCE.getInstance();
    }

    @Override
    public void close() throws IOException {
        this.s3Client.shutdown();
    }

    @Override
    public void createTenantDirIfNotExists(String tenantCode) throws ServiceException {
        this.createFolder(tenantCode + "/" + "udfs");
        this.createFolder(tenantCode + "/" + "resources");
    }

    @Override
    public String getResDir(String tenantCode) {
        return tenantCode + "/" + "resources" + "/";
    }

    @Override
    public String getUdfDir(String tenantCode) {
        return tenantCode + "/" + "udfs" + "/";
    }

    @Override
    public boolean mkdir(String tenantCode, String path) throws IOException {
        this.createFolder(path);
        return true;
    }

    @Override
    public String getResourceFileName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", tenantCode + "/" + "resources", fileName);
    }

    @Override
    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return this.getDir(resourceType, tenantCode) + fileName;
    }

    @Override
    public void download(String tenantCode, String srcFilePath, String dstFile, boolean deleteSource, boolean overwrite) throws IOException {
        S3Object o = this.s3Client.getObject("dolphinscheduler-test", srcFilePath);
        try (S3ObjectInputStream s3is = o.getObjectContent();
             FileOutputStream fos = new FileOutputStream(new File(dstFile));){
            byte[] readBuf = new byte[1024];
            int readLen = 0;
            while ((readLen = s3is.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
        catch (AmazonServiceException e) {
            logger.error("the resource can`t be downloaded,the bucket is {},and the src is {}", (Object)tenantCode, (Object)srcFilePath);
            throw new IOException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.error("the file isn`t exists");
            throw new IOException("the file isn`t exists");
        }
    }

    @Override
    public boolean exists(String tenantCode, String fileName) throws IOException {
        return this.s3Client.doesObjectExist("dolphinscheduler-test", fileName);
    }

    @Override
    public boolean delete(String tenantCode, String filePath, boolean recursive) throws IOException {
        try {
            this.s3Client.deleteObject("dolphinscheduler-test", filePath);
            return true;
        }
        catch (AmazonServiceException e) {
            logger.error("delete the object error,the resource path is {}", (Object)filePath);
            return false;
        }
    }

    @Override
    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        this.s3Client.copyObject("dolphinscheduler-test", srcPath, "dolphinscheduler-test", dstPath);
        this.s3Client.deleteObject("dolphinscheduler-test", srcPath);
        return true;
    }

    @Override
    public String getDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return this.getUdfDir(tenantCode);
            }
            case FILE: {
                return this.getResDir(tenantCode);
            }
        }
        return tenantCode + "/";
    }

    @Override
    public boolean upload(String tenantCode, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        try {
            this.s3Client.putObject("dolphinscheduler-test", dstPath, new File(srcFile));
            return true;
        }
        catch (AmazonServiceException e) {
            logger.error("upload failed,the bucketName is {},the dstPath is {}", (Object)"dolphinscheduler-test", (Object)(tenantCode + "/" + dstPath));
            return false;
        }
    }

    @Override
    public List<String> vimFile(String tenantCode, String filePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((String)filePath)) {
            logger.error("file path:{} is blank", (Object)filePath);
            return Collections.emptyList();
        }
        S3Object s3Object = this.s3Client.getObject("dolphinscheduler-test", filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)s3Object.getObjectContent()));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    private void createFolder(String folderName) {
        if (!this.s3Client.doesObjectExist("dolphinscheduler-test", folderName + "/")) {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
            PutObjectRequest putObjectRequest = new PutObjectRequest("dolphinscheduler-test", folderName + "/", (InputStream)emptyContent, metadata);
            this.s3Client.putObject(putObjectRequest);
        }
    }

    @Override
    public void deleteTenant(String tenantCode) throws Exception {
        this.deleteTenantCode(tenantCode);
    }

    private void deleteTenantCode(String tenantCode) {
        this.deleteDirectory(this.getResDir(tenantCode));
        this.deleteDirectory(this.getUdfDir(tenantCode));
    }

    private void uploadDirectory(String tenantCode, String keyPrefix, String strPath) {
        this.s3Client.putObject("dolphinscheduler-test", tenantCode + "/" + keyPrefix, new File(strPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadDirectory(String tenantCode, String keyPrefix, String srcPath) {
        TransferManager tm = TransferManagerBuilder.standard().withS3Client(this.s3Client).build();
        try {
            MultipleFileDownload download = tm.downloadDirectory("dolphinscheduler-test", tenantCode + "/" + keyPrefix, new File(srcPath));
            download.waitForCompletion();
        }
        catch (AmazonS3Exception | InterruptedException e) {
            logger.error("download the directory failed with the bucketName is {} and the keyPrefix is {}", (Object)"dolphinscheduler-test", (Object)(tenantCode + "/" + keyPrefix));
            Thread.currentThread().interrupt();
        }
        finally {
            tm.shutdownNow();
        }
    }

    public void checkBucketNameIfNotPresent(String bucketName) {
        if (!this.s3Client.doesBucketExistV2(bucketName)) {
            logger.info("the current regionName is {}", (Object)this.s3Client.getRegionName());
            this.s3Client.createBucket(bucketName);
        }
    }

    private void deleteDirectory(String directoryName) {
        if (this.s3Client.doesObjectExist("dolphinscheduler-test", directoryName)) {
            this.s3Client.deleteObject("dolphinscheduler-test", directoryName);
        }
    }

    @Override
    public ResUploadType returnStorageType() {
        return ResUploadType.S3;
    }

    private static enum S3Singleton {
        INSTANCE;

        private final S3Utils instance = new S3Utils();

        private S3Utils getInstance() {
            return this.instance;
        }
    }
}

