/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");

    public static String buildTaskId(Date firstSubmitTime, Long processDefineCode, int processDefineVersion, int processInstId, int taskId) {
        String firstSubmitTimeStr = DateUtils.format(firstSubmitTime, "yyyyMMdd", null);
        return String.format("%s=%s-%s-%s_%s-%s-%s", "taskAppId", "TASK", firstSubmitTimeStr, processDefineCode, processDefineVersion, processInstId, taskId);
    }

    public static List<String> getAppIds(String log, Logger logger) {
        ArrayList<String> appIds = new ArrayList<String>();
        Matcher matcher = APPLICATION_REGEX.matcher(log);
        while (matcher.find()) {
            String appId = matcher.group();
            if (appIds.contains(appId)) continue;
            logger.info("find app id: {}", (Object)appId);
            appIds.add(appId);
        }
        return appIds;
    }

    public static String readWholeFileContent(String filePath) {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("read file error", (Throwable)e);
                return "";
            }
        }
        br.close();
        return string;
    }

    public static void setWorkflowAndTaskInstanceIDMDC(int workflowInstanceId, int taskInstanceId) {
        LoggerUtils.setWorkflowInstanceIdMDC(workflowInstanceId);
        LoggerUtils.setTaskInstanceIdMDC(taskInstanceId);
    }

    public static void setWorkflowInstanceIdMDC(int workflowInstanceId) {
        MDC.put((String)"workflowInstanceId", (String)String.valueOf(workflowInstanceId));
    }

    public static void setTaskInstanceIdMDC(int taskInstanceId) {
        MDC.put((String)"taskInstanceId", (String)String.valueOf(taskInstanceId));
    }

    public static void removeWorkflowAndTaskInstanceIdMDC() {
        LoggerUtils.removeWorkflowInstanceIdMDC();
        LoggerUtils.removeTaskInstanceIdMDC();
    }

    public static void removeWorkflowInstanceIdMDC() {
        MDC.remove((String)"workflowInstanceId");
    }

    public static void removeTaskInstanceIdMDC() {
        MDC.remove((String)"taskInstanceId");
    }

    private LoggerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

