/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.model.PreviousTaskNode;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.parameters.TaskTimeoutParameter;

public class TaskNode {
    private String id;
    private long code;
    private int version;
    private String name;
    private String desc;
    private String type;
    private String runFlag;
    private String loc;
    private int maxRetryTimes;
    private int retryInterval;
    private int taskGroupId;
    private int taskGroupPriority;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String params;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String preTasks;
    private List<PreviousTaskNode> preTaskNodeList;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String extras;
    private List<String> depList;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String dependence;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String conditionResult;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String switchResult;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String waitStartTimeout;
    private Priority taskInstancePriority;
    private String workerGroup;
    private Long environmentCode;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String timeout;
    private int delayTime;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getPreTasks() {
        return this.preTasks;
    }

    public void setPreTasks(String preTasks) {
        this.preTasks = preTasks;
        this.depList = JSONUtils.toList(preTasks, String.class);
    }

    public String getExtras() {
        return this.extras;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }

    public List<String> getDepList() {
        return this.depList;
    }

    public void setDepList(List<String> depList) {
        if (depList != null) {
            this.depList = depList;
            this.preTasks = JSONUtils.toJsonString(depList);
        }
    }

    public String getLoc() {
        return this.loc;
    }

    public void setLoc(String loc) {
        this.loc = loc;
    }

    public String getRunFlag() {
        return this.runFlag;
    }

    public void setRunFlag(String runFlag) {
        this.runFlag = runFlag;
    }

    public boolean isForbidden() {
        return !StringUtils.isEmpty((String)this.runFlag) && this.runFlag.equals("FORBIDDEN");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskNode taskNode = (TaskNode)o;
        return Objects.equals(this.name, taskNode.name) && Objects.equals(this.desc, taskNode.desc) && Objects.equals(this.type, taskNode.type) && Objects.equals(this.params, taskNode.params) && Objects.equals(this.preTasks, taskNode.preTasks) && Objects.equals(this.extras, taskNode.extras) && Objects.equals(this.runFlag, taskNode.runFlag) && Objects.equals(this.dependence, taskNode.dependence) && Objects.equals(this.workerGroup, taskNode.workerGroup) && Objects.equals(this.environmentCode, taskNode.environmentCode) && Objects.equals(this.conditionResult, taskNode.conditionResult) && CollectionUtils.equalLists(this.depList, taskNode.depList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.desc, this.type, this.params, this.preTasks, this.extras, this.depList, this.runFlag);
    }

    public String getDependence() {
        return this.dependence;
    }

    public void setDependence(String dependence) {
        this.dependence = dependence;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Priority getTaskInstancePriority() {
        return this.taskInstancePriority;
    }

    public void setTaskInstancePriority(Priority taskInstancePriority) {
        this.taskInstancePriority = taskInstancePriority;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public String getConditionResult() {
        return this.conditionResult;
    }

    public void setConditionResult(String conditionResult) {
        this.conditionResult = conditionResult;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public TaskTimeoutParameter getTaskTimeoutParameter() {
        if (!StringUtils.isEmpty((String)this.getTimeout())) {
            String formatStr = String.format("%s,%s", TaskTimeoutStrategy.WARN.name(), TaskTimeoutStrategy.FAILED.name());
            String taskTimeout = this.getTimeout().replace(formatStr, TaskTimeoutStrategy.WARNFAILED.name());
            return JSONUtils.parseObject(taskTimeout, TaskTimeoutParameter.class);
        }
        return new TaskTimeoutParameter(false);
    }

    public boolean isConditionsTask() {
        return "CONDITIONS".equalsIgnoreCase(this.getType());
    }

    public boolean isSwitchTask() {
        return "SWITCH".equalsIgnoreCase(this.getType());
    }

    public List<PreviousTaskNode> getPreTaskNodeList() {
        return this.preTaskNodeList;
    }

    public boolean isBlockingTask() {
        return "BLOCKING".equalsIgnoreCase(this.getType());
    }

    public void setPreTaskNodeList(List<PreviousTaskNode> preTaskNodeList) {
        this.preTaskNodeList = preTaskNodeList;
    }

    public String getTaskParams() {
        Map<String, Object> taskParams = JSONUtils.parseObject(this.params, new TypeReference<Map<String, Object>>(){});
        if (taskParams == null) {
            taskParams = new HashMap<String, Object>();
        }
        taskParams.put("conditionResult", this.conditionResult);
        taskParams.put("dependence", this.dependence);
        taskParams.put("switchResult", this.switchResult);
        taskParams.put("waitStartTimeout", this.waitStartTimeout);
        return JSONUtils.toJsonString(taskParams);
    }

    public Map<String, Object> taskParamsToJsonObj(String taskParams) {
        Map<String, Object> taskParamsMap = JSONUtils.parseObject(taskParams, new TypeReference<Map<String, Object>>(){});
        if (taskParamsMap == null) {
            taskParamsMap = new HashMap<String, Object>();
        }
        return taskParamsMap;
    }

    public String toString() {
        return "TaskNode{id='" + this.id + '\'' + ", code=" + this.code + ", version=" + this.version + ", name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", type='" + this.type + '\'' + ", runFlag='" + this.runFlag + '\'' + ", loc='" + this.loc + '\'' + ", maxRetryTimes=" + this.maxRetryTimes + ", retryInterval=" + this.retryInterval + ", params='" + this.params + '\'' + ", preTasks='" + this.preTasks + '\'' + ", preTaskNodeList=" + this.preTaskNodeList + ", extras='" + this.extras + '\'' + ", depList=" + this.depList + ", dependence='" + this.dependence + '\'' + ", conditionResult='" + this.conditionResult + '\'' + ", taskInstancePriority=" + (Object)((Object)this.taskInstancePriority) + ", workerGroup='" + this.workerGroup + '\'' + ", environmentCode=" + this.environmentCode + ", timeout='" + this.timeout + '\'' + ", delayTime=" + this.delayTime + '}';
    }

    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    public String getSwitchResult() {
        return this.switchResult;
    }

    public void setSwitchResult(String switchResult) {
        this.switchResult = switchResult;
    }

    public String getWaitStartTimeout() {
        return this.waitStartTimeout;
    }

    public void setWaitStartTimeout(String waitStartTimeout) {
        this.waitStartTimeout = waitStartTimeout;
    }

    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    public void setTaskGroupId(int taskGroupId) {
        this.taskGroupId = taskGroupId;
    }

    public int getTaskGroupPriority() {
        return this.taskGroupPriority;
    }

    public void setTaskGroupPriority(int taskGroupPriority) {
        this.taskGroupPriority = taskGroupPriority;
    }
}

