/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static PoolingHttpClientConnectionManager cm;
    private static SSLContext ctx;
    private static SSLConnectionSocketFactory socketFactory;
    private static RequestConfig requestConfig;
    private static Registry<ConnectionSocketFactory> socketFactoryRegistry;
    private static X509TrustManager xtm;

    private HttpUtils() {
        throw new UnsupportedOperationException("Construct HttpUtils");
    }

    public static CloseableHttpClient getInstance() {
        return HttpClientInstance.httpClient;
    }

    public static String get(String url) {
        CloseableHttpClient httpclient = HttpUtils.getInstance();
        HttpGet httpget = new HttpGet(url);
        return HttpUtils.getResponseContentString(httpget, httpclient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseContentString(HttpGet httpget, CloseableHttpClient httpClient) {
        if (Objects.isNull(httpget) || Objects.isNull(httpClient)) {
            logger.error("HttpGet or HttpClient parameter is null");
            return null;
        }
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                } else {
                    logger.warn("http entity is null");
                }
            } else {
                logger.error("http get:{} response status code is not 200!", (Object)response.getStatusLine().getStatusCode());
            }
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            try {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (!httpget.isAborted()) {
                httpget.releaseConnection();
                httpget.abort();
            }
        }
        return responseContent;
    }

    static /* synthetic */ RequestConfig access$100() {
        return requestConfig;
    }

    static /* synthetic */ PoolingHttpClientConnectionManager access$200() {
        return cm;
    }

    static {
        ctx = null;
        xtm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{xtm}, null);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("SSLContext init with NoSuchAlgorithmException", (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error("SSLContext init with KeyManagementException", (Throwable)e);
        }
        socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        requestConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).setRedirectsEnabled(true).build();
        socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
        cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setDefaultMaxPerRoute(60);
        cm.setMaxTotal(100);
    }

    private static class HttpClientInstance {
        private static final CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)HttpUtils.access$200()).setDefaultRequestConfig(HttpUtils.access$100()).build();

        private HttpClientInstance() {
        }
    }
}

