/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);

    public static String buildTaskId(Date firstSubmitTime, Long processDefineCode, int processDefineVersion, int processInstId, int taskId) {
        String firstSubmitTimeStr = DateUtils.format(firstSubmitTime, "yyyyMMdd", null);
        return String.format("%s=%s-%s-%s_%s-%s-%s", "taskAppId", "TASK", firstSubmitTimeStr, processDefineCode, processDefineVersion, processInstId, taskId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWholeFileContent(String filePath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file error", (Throwable)e);
            return "";
        }
    }

    public static void setWorkflowAndTaskInstanceIDMDC(int workflowInstanceId, int taskInstanceId) {
        LoggerUtils.setWorkflowInstanceIdMDC(workflowInstanceId);
        LoggerUtils.setTaskInstanceIdMDC(taskInstanceId);
    }

    public static void setWorkflowInstanceIdMDC(int workflowInstanceId) {
        MDC.put((String)"workflowInstanceId", (String)String.valueOf(workflowInstanceId));
    }

    public static void setTaskInstanceIdMDC(int taskInstanceId) {
        MDC.put((String)"taskInstanceId", (String)String.valueOf(taskInstanceId));
    }

    public static void removeWorkflowAndTaskInstanceIdMDC() {
        LoggerUtils.removeWorkflowInstanceIdMDC();
        LoggerUtils.removeTaskInstanceIdMDC();
    }

    public static void removeWorkflowInstanceIdMDC() {
        MDC.remove((String)"workflowInstanceId");
    }

    public static void removeTaskInstanceIdMDC() {
        MDC.remove((String)"taskInstanceId");
    }

    private LoggerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

