/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.lifecycle;

import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleException;
import org.apache.dolphinscheduler.common.lifecycle.ServerStatus;

public final class ServerLifeCycleManager {
    private static volatile ServerStatus serverStatus = ServerStatus.RUNNING;
    private static long serverStartupTime = System.currentTimeMillis();

    public static long getServerStartupTime() {
        return serverStartupTime;
    }

    public static boolean isRunning() {
        return serverStatus == ServerStatus.RUNNING;
    }

    public static boolean isStopped() {
        return serverStatus == ServerStatus.STOPPED;
    }

    public static ServerStatus getServerStatus() {
        return serverStatus;
    }

    public static synchronized void toWaiting() throws ServerLifeCycleException {
        if (ServerLifeCycleManager.isStopped()) {
            throw new ServerLifeCycleException("The current server is already stopped, cannot change to waiting");
        }
        if (serverStatus != ServerStatus.RUNNING) {
            throw new ServerLifeCycleException("The current server is not at running status, cannot change to waiting");
        }
        serverStatus = ServerStatus.WAITING;
    }

    public static synchronized void recoverFromWaiting() throws ServerLifeCycleException {
        if (serverStatus != ServerStatus.WAITING) {
            throw new ServerLifeCycleException("The current server status is not waiting, cannot recover form waiting");
        }
        serverStartupTime = System.currentTimeMillis();
        serverStatus = ServerStatus.RUNNING;
    }

    public static synchronized boolean toStopped() {
        if (serverStatus == ServerStatus.STOPPED) {
            return false;
        }
        serverStatus = ServerStatus.STOPPED;
        return true;
    }

    @Generated
    private ServerLifeCycleManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

