/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger(JSONUtils.class);
    private static final ObjectMapper objectMapper;

    private JSONUtils() {
        throw new UnsupportedOperationException("Construct JSONUtils");
    }

    public static synchronized void setTimeZone(TimeZone timeZone) {
        objectMapper.setTimeZone(timeZone);
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static JsonNode toJsonNode(Object obj) {
        return objectMapper.valueToTree(obj);
    }

    public static String toJsonString(Object object, SerializationFeature feature) {
        try {
            ObjectWriter writer = objectMapper.writer(feature);
            return writer.writeValueAsString(object);
        }
        catch (Exception e) {
            logger.error("object to json exception!", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            logger.error("Parse object exception, jsonStr: {}, class: {}", new Object[]{json, clazz, e});
            return null;
        }
    }

    public static <T> T parseObject(byte[] src, Class<T> clazz) {
        if (src == null) {
            return null;
        }
        String json = new String(src, StandardCharsets.UTF_8);
        return JSONUtils.parseObject(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyList();
        }
        try {
            CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)objectMapper.readValue(json, (JavaType)listType);
        }
        catch (Exception e) {
            logger.error("parse list exception!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static boolean checkJsonValid(String json) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            objectMapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            logger.error("check json object valid exception!", (Throwable)e);
            return false;
        }
    }

    public static String findValue(JsonNode jsonNode, String fieldName) {
        JsonNode node = jsonNode.findValue(fieldName);
        if (node == null) {
            return null;
        }
        return node.asText();
    }

    public static Map<String, String> toMap(String json) {
        return JSONUtils.parseObject(json, new TypeReference<Map<String, String>>(){});
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> classK, Class<V> classV) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)objectMapper.readValue(json, new TypeReference<Map<K, V>>(){});
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static String getNodeString(String json, String nodeName) {
        try {
            JsonNode rootNode = objectMapper.readTree(json);
            JsonNode jsonNode = rootNode.findValue(nodeName);
            if (Objects.isNull(jsonNode)) {
                return "";
            }
            return jsonNode.isTextual() ? jsonNode.asText() : jsonNode.toString();
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public static <T> T parseObject(String json, TypeReference<T> type) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return null;
        }
    }

    public static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Object json deserialization exception.", e);
        }
    }

    public static <T> byte[] toJsonByteArray(T obj) {
        if (obj == null) {
            return null;
        }
        String json = "";
        try {
            json = JSONUtils.toJsonString(obj);
        }
        catch (Exception e) {
            logger.error("json serialize exception.", (Throwable)e);
        }
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public static ObjectNode parseObject(String text) {
        try {
            if (text.isEmpty()) {
                return JSONUtils.parseObject(text, ObjectNode.class);
            }
            return (ObjectNode)objectMapper.readTree(text);
        }
        catch (Exception e) {
            throw new RuntimeException("String json deserialization exception.", e);
        }
    }

    public static ArrayNode parseArray(String text) {
        try {
            return (ArrayNode)objectMapper.readTree(text);
        }
        catch (Exception e) {
            throw new RuntimeException("Json deserialization exception.", e);
        }
    }

    static {
        logger.info("init timezone: {}", (Object)TimeZone.getDefault());
        objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).setTimeZone(TimeZone.getDefault()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public static class JsonDataDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node instanceof TextNode) {
                return node.asText();
            }
            return node.toString();
        }
    }

    public static class JsonDataSerializer
    extends JsonSerializer<String> {
        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRawValue(value);
        }
    }
}

