/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parser.PlaceholderUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.TimePlaceholderUtils;

public class ParameterUtils {
    private static final Pattern DATE_PARSE_PATTERN = Pattern.compile("\\$\\[([^\\$\\]]+)]");
    private static final Pattern DATE_START_PATTERN = Pattern.compile("^[0-9]");

    private ParameterUtils() {
        throw new UnsupportedOperationException("Construct ParameterUtils");
    }

    public static String convertParameterPlaceholders(String parameterString, Map<String, String> parameterMap) {
        Date cronTime;
        if (StringUtils.isEmpty((CharSequence)parameterString)) {
            return parameterString;
        }
        if (parameterMap != null && !parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders((String)parameterString, parameterMap, (boolean)true);
        }
        if (parameterMap != null && null != parameterMap.get("system.datetime")) {
            String cronTimeStr = parameterMap.get("system.datetime");
            cronTime = DateUtils.parse(cronTimeStr, "yyyyMMddHHmmss", null);
        } else {
            cronTime = new Date();
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static String handleEscapes(String inputString) {
        if (!StringUtils.isEmpty((CharSequence)inputString)) {
            return inputString.replace("%", "////%").replaceAll("[\n|\r\t]", "_");
        }
        return inputString;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    private static String dateTemplateParse(String templateStr, Date date) {
        if (templateStr == null) {
            return null;
        }
        StringBuffer newValue = new StringBuffer(templateStr.length());
        Matcher matcher = DATE_PARSE_PATTERN.matcher(templateStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (DATE_START_PATTERN.matcher(key).matches()) continue;
            String value = TimePlaceholderUtils.getPlaceHolderTime((String)key, (Date)date);
            assert (value != null);
            matcher.appendReplacement(newValue, value);
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }
}

