/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SensitiveDataConverter
extends MessageConverter {
    private static Pattern multilinePattern;
    private static HashSet<String> maskPatterns;

    public String convert(ILoggingEvent event) {
        String requestLogMsg = event.getFormattedMessage();
        return SensitiveDataConverter.maskSensitiveData(requestLogMsg);
    }

    public static void addMaskPattern(String maskPattern) {
        maskPatterns.add(maskPattern);
    }

    public static String maskSensitiveData(String logMsg) {
        if (StringUtils.isEmpty((CharSequence)logMsg)) {
            return logMsg;
        }
        multilinePattern = Pattern.compile(String.join((CharSequence)"|", maskPatterns), 8);
        StringBuffer sb = new StringBuffer(logMsg.length());
        Matcher matcher = multilinePattern.matcher(logMsg);
        while (matcher.find()) {
            String password = matcher.group();
            String maskPassword = Strings.repeat((String)"*", (int)password.length());
            matcher.appendReplacement(sb, maskPassword);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        maskPatterns = new HashSet<String>(Arrays.asList("(?<=((?i)password((\":\")|(\\\\\":\\\\\")|(=')))).*?(?=((\")|(\\\\\")|(')))"));
    }
}

