/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.factory.OssClientFactory;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.model.OssConnection;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssRemoteLogHandler
implements RemoteLogHandler,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OssRemoteLogHandler.class);
    private OSS ossClient;
    private String bucketName;
    private static OssRemoteLogHandler instance;

    private OssRemoteLogHandler() {
    }

    public static synchronized OssRemoteLogHandler getInstance() {
        if (instance == null) {
            instance = new OssRemoteLogHandler();
            instance.init();
        }
        return instance;
    }

    public void init() {
        String accessKeyId = this.readOssAccessKeyId();
        String accessKeySecret = this.readOssAccessKeySecret();
        String endpoint = this.readOssEndpoint();
        this.ossClient = OssClientFactory.buildOssClient(new OssConnection(accessKeyId, accessKeySecret, endpoint));
        this.bucketName = this.readOssBucketName();
        this.checkBucketNameExists(this.bucketName);
    }

    @Override
    public void sendRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("send remote log {} to OSS {}", (Object)logPath, (Object)objectName);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, objectName, new File(logPath));
            this.ossClient.putObject(putObjectRequest);
        }
        catch (Exception e) {
            log.error("error while sending remote log {} to OSS {}", new Object[]{logPath, objectName, e});
        }
    }

    @Override
    public void getRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("get remote log on OSS {} to {}", (Object)objectName, (Object)logPath);
            this.ossClient.getObject(new GetObjectRequest(this.bucketName, objectName), new File(logPath));
        }
        catch (Exception e) {
            log.error("error while getting remote log on OSS {} to {}", new Object[]{objectName, logPath, e});
        }
    }

    @Override
    public void close() throws IOException {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
        }
    }

    private void checkBucketNameExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("remote.logging.oss.bucket.name is empty");
        }
        boolean existsBucket = this.ossClient.doesBucketExist(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found", (Object)bucketName);
    }

    private String readOssAccessKeyId() {
        return PropertyUtils.getString("remote.logging.oss.access.key.id");
    }

    private String readOssAccessKeySecret() {
        return PropertyUtils.getString("remote.logging.oss.access.key.secret");
    }

    private String readOssEndpoint() {
        return PropertyUtils.getString("remote.logging.oss.endpoint");
    }

    private String readOssBucketName() {
        return PropertyUtils.getString("remote.logging.oss.bucket.name");
    }
}

