/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import lombok.Generated;
import org.apache.dolphinscheduler.common.log.remote.GcsRemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.OssRemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.log.remote.S3RemoteLogHandler;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteLogHandlerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteLogHandlerFactory.class);

    public static RemoteLogHandler getRemoteLogHandler() {
        if (!RemoteLogUtils.isRemoteLoggingEnable()) {
            return null;
        }
        String target = PropertyUtils.getUpperCaseString("remote.logging.target");
        if ("OSS".equals(target)) {
            return OssRemoteLogHandler.getInstance();
        }
        if ("S3".equals(target)) {
            return S3RemoteLogHandler.getInstance();
        }
        if ("GCS".equals(target)) {
            return GcsRemoteLogHandler.getInstance();
        }
        log.error("No suitable remote logging target for {}", (Object)target);
        return null;
    }

    @Generated
    private RemoteLogHandlerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

