/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3RemoteLogHandler
implements RemoteLogHandler,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3RemoteLogHandler.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String region;
    private String bucketName;
    private String endPoint;
    private AmazonS3 s3Client;
    private static S3RemoteLogHandler instance;

    private S3RemoteLogHandler() {
    }

    public static synchronized S3RemoteLogHandler getInstance() {
        if (instance == null) {
            instance = new S3RemoteLogHandler();
            instance.init();
        }
        return instance;
    }

    public void init() {
        this.accessKeyId = this.readAccessKeyID();
        this.accessKeySecret = this.readAccessKeySecret();
        this.region = this.readRegion();
        this.bucketName = this.readBucketName();
        this.endPoint = this.readEndPoint();
        this.s3Client = this.buildS3Client();
        this.checkBucketNameExists(this.bucketName);
    }

    protected AmazonS3 buildS3Client() {
        if (StringUtils.isNotEmpty((CharSequence)this.endPoint)) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endPoint, Regions.fromName((String)this.region).getName()))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKeyId, this.accessKeySecret)))).build();
        }
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKeyId, this.accessKeySecret)))).withRegion(Regions.fromName((String)this.region))).build();
    }

    @Override
    public void close() throws IOException {
        this.s3Client.shutdown();
    }

    @Override
    public void sendRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("send remote log {} to S3 {}", (Object)logPath, (Object)objectName);
            this.s3Client.putObject(this.bucketName, objectName, new File(logPath));
        }
        catch (Exception e) {
            log.error("error while sending remote log {} to S3 {}", new Object[]{logPath, objectName, e});
        }
    }

    @Override
    public void getRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("get remote log on S3 {} to {}", (Object)objectName, (Object)logPath);
            S3Object o = this.s3Client.getObject(this.bucketName, objectName);
            try (S3ObjectInputStream s3is = o.getObjectContent();
                 FileOutputStream fos = new FileOutputStream(logPath);){
                byte[] readBuf = new byte[1024];
                int readLen = 0;
                while ((readLen = s3is.read(readBuf)) > 0) {
                    fos.write(readBuf, 0, readLen);
                }
            }
        }
        catch (Exception e) {
            log.error("error while getting remote log on S3 {} to {}", new Object[]{objectName, logPath, e});
        }
    }

    protected String readAccessKeyID() {
        return PropertyUtils.getString("remote.logging.s3.access.key.id");
    }

    protected String readAccessKeySecret() {
        return PropertyUtils.getString("remote.logging.s3.access.key.secret");
    }

    protected String readRegion() {
        return PropertyUtils.getString("remote.logging.s3.region");
    }

    protected String readBucketName() {
        return PropertyUtils.getString("remote.logging.s3.bucket.name");
    }

    protected String readEndPoint() {
        return PropertyUtils.getString("remote.logging.s3.endpoint");
    }

    public void checkBucketNameExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("remote.logging.s3.bucket.name is blank");
        }
        boolean existsBucket = this.s3Client.doesBucketExistV2(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found, the current regionName is {}", (Object)bucketName, (Object)this.s3Client.getRegionName());
    }
}

