/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.model;

import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHeartBeatTask<T>
extends BaseDaemonThread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseHeartBeatTask.class);
    private final String threadName;
    private final long heartBeatInterval;
    protected boolean runningFlag;

    public BaseHeartBeatTask(String threadName, long heartBeatInterval) {
        super(threadName);
        this.threadName = threadName;
        this.heartBeatInterval = heartBeatInterval;
        this.runningFlag = true;
    }

    @Override
    public synchronized void start() {
        log.info("Starting {}...", (Object)this.threadName);
        super.start();
        log.info("Started {}, heartBeatInterval: {}...", (Object)this.threadName, (Object)this.heartBeatInterval);
    }

    @Override
    public void run() {
        while (this.runningFlag) {
            try {
                if (!ServerLifeCycleManager.isRunning()) {
                    log.info("The current server status is {}, will not write heartBeatInfo into registry", (Object)ServerLifeCycleManager.getServerStatus());
                    continue;
                }
                T heartBeat = this.getHeartBeat();
                this.writeHeartBeat(heartBeat);
            }
            catch (Exception ex) {
                log.error("{} task execute failed", (Object)this.threadName, (Object)ex);
            }
            finally {
                try {
                    Thread.sleep(this.heartBeatInterval);
                }
                catch (InterruptedException e) {
                    this.handleInterruptException(e);
                }
            }
        }
    }

    public void shutdown() {
        this.runningFlag = false;
        log.warn("{} finished...", (Object)this.threadName);
    }

    private void handleInterruptException(InterruptedException ex) {
        log.warn("{} has been interrupted", (Object)this.threadName, (Object)ex);
        Thread.currentThread().interrupt();
    }

    public abstract T getHeartBeat();

    public abstract void writeHeartBeat(T var1);
}

