/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.sql.SqlScriptParser;
import org.springframework.core.io.ClassPathResource;

public class ClasspathSqlScriptParser
implements SqlScriptParser {
    private final String sqlScriptPath;
    private final Charset charset;

    public ClasspathSqlScriptParser(String sqlScriptPath) {
        this.sqlScriptPath = sqlScriptPath;
        this.charset = StandardCharsets.UTF_8;
    }

    @Override
    public List<String> getAllSql() throws IOException {
        ClassPathResource sqlScriptResource = new ClassPathResource(this.sqlScriptPath);
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream inputStream = sqlScriptResource.getInputStream();
             InputStreamReader sqlScriptReader = new InputStreamReader(inputStream, this.charset);
             LineNumberReader lineNumberReader = new LineNumberReader(sqlScriptReader);){
            String sql;
            do {
                if (!StringUtils.isNotBlank((CharSequence)(sql = this.parseNextSql(lineNumberReader)))) continue;
                result.add(sql);
            } while (StringUtils.isNotBlank((CharSequence)sql));
        }
        return result;
    }

    private String parseNextSql(LineNumberReader lineNumberReader) throws IOException {
        String line;
        while ((line = lineNumberReader.readLine()) != null) {
            String trimLine = line.trim();
            if (StringUtils.isEmpty((CharSequence)trimLine) || this.isComment(trimLine)) continue;
            if (trimLine.startsWith("/*")) {
                this.skipLicenseHeader(lineNumberReader);
                continue;
            }
            if (trimLine.startsWith("delimiter")) {
                String[] split = trimLine.split(" ");
                return this.parseProcedure(lineNumberReader, split[1]);
            }
            ArrayList<String> sqlLines = new ArrayList<String>();
            sqlLines.add(line);
            while (!line.endsWith(";") && (line = lineNumberReader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line)) continue;
                sqlLines.add(line);
            }
            return String.join((CharSequence)"\n", sqlLines);
        }
        return null;
    }

    private void skipLicenseHeader(LineNumberReader lineNumberReader) throws IOException {
        String trimLine;
        String line;
        while ((line = lineNumberReader.readLine()) != null && (StringUtils.isEmpty((CharSequence)(trimLine = line.trim())) || this.isComment(trimLine) || !line.startsWith("*/"))) {
        }
    }

    private String parseProcedure(LineNumberReader lineNumberReader, String delimiter) throws IOException {
        String line;
        ArrayList<String> sqlLines = new ArrayList<String>();
        while ((line = lineNumberReader.readLine()) != null) {
            if (StringUtils.isBlank((CharSequence)line)) continue;
            if (line.startsWith(delimiter)) break;
            sqlLines.add(line);
        }
        return String.join((CharSequence)"\n", sqlLines);
    }

    private boolean isComment(String line) {
        return line.startsWith("--") || line.startsWith("//");
    }
}

