/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.thread;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    public static ExecutorService newDaemonFixedThreadExecutor(String threadName, int threadsNum) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        return Executors.newFixedThreadPool(threadsNum, threadFactory);
    }

    public static ScheduledExecutorService newSingleDaemonScheduledExecutorService(String threadName) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadName).setDaemon(true).build();
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.error("Current thread sleep error", (Throwable)interruptedException);
        }
    }

    @Generated
    private ThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

