/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.KubernetesUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    private static final String DOLPHIN_SCHEDULER_NETWORK_INTERFACE_PREFERRED = "dolphin.scheduler.network.interface.preferred";
    private static final String DOLPHIN_SCHEDULER_NETWORK_INTERFACE_RESTRICT = "dolphin.scheduler.network.interface.restrict";
    private static final String DOLPHIN_SCHEDULER_NETWORK_PRIORITY_STRATEGY = "dolphin.scheduler.network.priority.strategy";
    private static final String NETWORK_PRIORITY_DEFAULT = "default";
    private static final String NETWORK_PRIORITY_INNER = "inner";
    private static final String NETWORK_PRIORITY_OUTER = "outer";
    private static InetAddress LOCAL_ADDRESS = null;
    private static volatile String HOST_ADDRESS;

    private NetUtils() {
        throw new UnsupportedOperationException("Construct NetUtils");
    }

    public static String getAddr(String host, int port) {
        return String.format("%s:%d", host, port);
    }

    public static String getAddr(int port) {
        return NetUtils.getAddr(NetUtils.getHost(), port);
    }

    public static String getHost(InetAddress inetAddress) {
        if (inetAddress != null) {
            if (KubernetesUtils.isKubernetesMode()) {
                String canonicalHost = inetAddress.getCanonicalHostName();
                String[] items = canonicalHost.split("\\.");
                if (items.length == 6 && "svc".equals(items[3])) {
                    return String.format("%s.%s", items[0], items[1]);
                }
                return canonicalHost;
            }
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public static String getHost() {
        if (HOST_ADDRESS != null) {
            return HOST_ADDRESS;
        }
        InetAddress address = NetUtils.getLocalAddress();
        if (address != null) {
            HOST_ADDRESS = NetUtils.getHost(address);
            return HOST_ADDRESS;
        }
        return KubernetesUtils.isKubernetesMode() ? "localhost" : "127.0.0.1";
    }

    private static InetAddress getLocalAddress() {
        if (null != LOCAL_ADDRESS) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = NetUtils.getLocalAddress0();
        return LOCAL_ADDRESS;
    }

    private static synchronized InetAddress getLocalAddress0() {
        List<NetworkInterface> suitableNetworkInterface = NetUtils.findSuitableNetworkInterface();
        List<InetAddress> suitableInetAddress = NetUtils.findSuitableInetAddress(suitableNetworkInterface);
        if (CollectionUtils.isEmpty(suitableInetAddress)) {
            return null;
        }
        return suitableInetAddress.get(0);
    }

    private static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    protected static boolean isValidV4Address(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && InetAddressUtils.isIPv4Address((String)name) && !address.isAnyLocalAddress() && !address.isLoopbackAddress();
    }

    protected static boolean isValidV6Address(InetAddress address) {
        if (!(address instanceof Inet6Address)) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && InetAddressUtils.isIPv6Address((String)name) && !address.isAnyLocalAddress() && !address.isLoopbackAddress();
    }

    private static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    private static boolean isPreferIPV4Address() {
        return Boolean.getBoolean("java.net.preferIPv4Addresses");
    }

    private static List<NetworkInterface> findSuitableNetworkInterface() {
        Set<String> restrictNetworkInterfaceName;
        List<Object> networkInterfaces = Collections.emptyList();
        try {
            networkInterfaces = NetUtils.getAllNetworkInterfaces();
        }
        catch (SocketException e) {
            log.warn("ValidNetworkInterfaces exception", (Throwable)e);
        }
        List<NetworkInterface> validNetworkInterfaces = networkInterfaces.stream().filter(networkInterface -> {
            try {
                return networkInterface != null && !networkInterface.isLoopback() && !networkInterface.isVirtual() && networkInterface.isUp();
            }
            catch (SocketException e) {
                log.warn("ValidNetworkInterfaces exception", (Throwable)e);
                return false;
            }
        }).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)NetUtils.specifyNetworkInterfaceName())) {
            String specifyNetworkInterfaceName = NetUtils.specifyNetworkInterfaceName();
            if (CollectionUtils.isEmpty(validNetworkInterfaces = validNetworkInterfaces.stream().filter(networkInterface -> specifyNetworkInterfaceName.equals(networkInterface.getDisplayName())).collect(Collectors.toList()))) {
                throw new IllegalArgumentException("The specified network interface: " + specifyNetworkInterfaceName + " is not found");
            }
        }
        if (CollectionUtils.isNotEmpty(restrictNetworkInterfaceName = NetUtils.restrictNetworkInterfaceName())) {
            validNetworkInterfaces = validNetworkInterfaces.stream().filter(validNetworkInterface -> !restrictNetworkInterfaceName.contains(validNetworkInterface.getDisplayName())).collect(Collectors.toList());
        }
        return NetUtils.filterByNetworkPriority(validNetworkInterfaces);
    }

    private static List<InetAddress> findSuitableInetAddress(List<NetworkInterface> networkInterfaces) {
        if (CollectionUtils.isEmpty(networkInterfaces)) {
            return Collections.emptyList();
        }
        LinkedList<InetAddress> allInetAddresses = new LinkedList<InetAddress>();
        for (NetworkInterface networkInterface : networkInterfaces) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                allInetAddresses.add(addresses.nextElement());
            }
        }
        ArrayList<InetAddress> preferInetAddress = new ArrayList<InetAddress>();
        if (!NetUtils.isPreferIPV6Address() && !NetUtils.isPreferIPV4Address()) {
            preferInetAddress.addAll(NetUtils.getIpv4Addresses(allInetAddresses));
            preferInetAddress.addAll(NetUtils.getIpv6Addresses(allInetAddresses));
        }
        if (NetUtils.isPreferIPV4Address()) {
            preferInetAddress.addAll(NetUtils.getIpv4Addresses(allInetAddresses));
        }
        if (NetUtils.isPreferIPV6Address()) {
            preferInetAddress.addAll(NetUtils.getIpv6Addresses(allInetAddresses));
        }
        return preferInetAddress.stream().filter(inetAddress -> {
            try {
                return inetAddress.isReachable(100);
            }
            catch (IOException e) {
                log.warn("InetAddress isReachable exception", (Throwable)e);
                return false;
            }
        }).collect(Collectors.toList());
    }

    private static List<InetAddress> getIpv4Addresses(List<InetAddress> allInetAddresses) {
        if (CollectionUtils.isEmpty(allInetAddresses)) {
            return Collections.emptyList();
        }
        ArrayList<InetAddress> validIpv4Addresses = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : allInetAddresses) {
            if (!NetUtils.isValidV4Address(inetAddress)) continue;
            validIpv4Addresses.add(inetAddress);
        }
        return validIpv4Addresses;
    }

    private static List<InetAddress> getIpv6Addresses(List<InetAddress> allInetAddresses) {
        if (CollectionUtils.isEmpty(allInetAddresses)) {
            return Collections.emptyList();
        }
        ArrayList<InetAddress> validIpv6Addresses = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : allInetAddresses) {
            if (!NetUtils.isValidV6Address(inetAddress)) continue;
            Inet6Address v6Address = (Inet6Address)inetAddress;
            InetAddress normalizedV6Address = NetUtils.normalizeV6Address(v6Address);
            validIpv6Addresses.add(normalizedV6Address);
        }
        return validIpv6Addresses;
    }

    private static List<NetworkInterface> getAllNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            log.info("Found NetworkInterface: {}", (Object)networkInterface);
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    private static String specifyNetworkInterfaceName() {
        return PropertyUtils.getString(DOLPHIN_SCHEDULER_NETWORK_INTERFACE_PREFERRED, System.getProperty(DOLPHIN_SCHEDULER_NETWORK_INTERFACE_PREFERRED));
    }

    private static Set<String> restrictNetworkInterfaceName() {
        return PropertyUtils.getSet(DOLPHIN_SCHEDULER_NETWORK_INTERFACE_RESTRICT, value -> {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return Collections.emptySet();
            }
            return Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toSet());
        }, Sets.newHashSet((Object[])new String[]{"docker0"}));
    }

    private static List<NetworkInterface> filterByNetworkPriority(List<NetworkInterface> validNetworkInterfaces) {
        String networkPriority;
        if (CollectionUtils.isEmpty(validNetworkInterfaces)) {
            return Collections.emptyList();
        }
        switch (networkPriority = PropertyUtils.getString(DOLPHIN_SCHEDULER_NETWORK_PRIORITY_STRATEGY, NETWORK_PRIORITY_DEFAULT)) {
            case "default": {
                log.debug("Use default NetworkInterface acquisition policy");
                return NetUtils.findAddressByDefaultPolicy(validNetworkInterfaces);
            }
            case "inner": {
                log.debug("Use inner NetworkInterface acquisition policy");
                return NetUtils.findInnerAddressNetWorkInterface(validNetworkInterfaces);
            }
            case "outer": {
                log.debug("Use outer NetworkInterface acquisition policy");
                return NetUtils.findOuterAddressNetworkInterface(validNetworkInterfaces);
            }
        }
        log.error("There is no matching network card acquisition policy!");
        return Collections.emptyList();
    }

    private static List<NetworkInterface> findAddressByDefaultPolicy(List<NetworkInterface> validNetworkInterfaces) {
        ArrayList<NetworkInterface> allAddress = new ArrayList<NetworkInterface>();
        allAddress.addAll(NetUtils.findInnerAddressNetWorkInterface(validNetworkInterfaces));
        allAddress.addAll(NetUtils.findOuterAddressNetworkInterface(validNetworkInterfaces));
        return allAddress;
    }

    private static List<NetworkInterface> findInnerAddressNetWorkInterface(List<NetworkInterface> validNetworkInterfaces) {
        if (CollectionUtils.isEmpty(validNetworkInterfaces)) {
            return Collections.emptyList();
        }
        ArrayList<NetworkInterface> innerNetworkInterfaces = new ArrayList<NetworkInterface>();
        for (NetworkInterface ni : validNetworkInterfaces) {
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress()) continue;
                innerNetworkInterfaces.add(ni);
            }
        }
        return innerNetworkInterfaces;
    }

    private static List<NetworkInterface> findOuterAddressNetworkInterface(List<NetworkInterface> validNetworkInterfaces) {
        if (CollectionUtils.isEmpty(validNetworkInterfaces)) {
            return Collections.emptyList();
        }
        ArrayList<NetworkInterface> outerNetworkInterfaces = new ArrayList<NetworkInterface>();
        for (NetworkInterface ni : validNetworkInterfaces) {
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (ip.isSiteLocalAddress() || ip.isLoopbackAddress()) continue;
                outerNetworkInterfaces.add(ni);
            }
        }
        return outerNetworkInterfaces;
    }
}

