/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.dolphinscheduler.common.config.IPropertyDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutablePropertyDelegate
implements IPropertyDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImmutablePropertyDelegate.class);
    private static final String COMMON_PROPERTIES_NAME = "/common.properties";
    private final Properties properties;

    public ImmutablePropertyDelegate() {
        this(COMMON_PROPERTIES_NAME);
    }

    public ImmutablePropertyDelegate(String ... propertyAbsolutePath) {
        this.properties = new Properties();
        for (String fileName : propertyAbsolutePath) {
            try (InputStream fis = this.getClass().getResourceAsStream(fileName);){
                Properties subProperties = new Properties();
                subProperties.load(fis);
                this.properties.putAll((Map<?, ?>)subProperties);
            }
            catch (IOException e) {
                log.error("Load property: {} error, please check if the file exist under classpath", (Object)propertyAbsolutePath, (Object)e);
                System.exit(1);
            }
        }
        this.printProperties();
    }

    public ImmutablePropertyDelegate(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String get(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.properties.stringPropertyNames();
    }

    private void printProperties() {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> log.debug("Get property {} -> {}", k, v)));
    }
}

