/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum WarningType {
    NONE(0, "none"),
    SUCCESS(1, "success"),
    FAILURE(2, "failure"),
    ALL(3, "all"),
    GLOBAL(4, "global");

    @EnumValue
    private final int code;
    private final String descp;
    private static final Map<String, WarningType> WARNING_TYPE_MAP;

    private WarningType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static WarningType of(String descp) {
        if (WARNING_TYPE_MAP.containsKey(descp)) {
            return WARNING_TYPE_MAP.get(descp);
        }
        return null;
    }

    static {
        WARNING_TYPE_MAP = Arrays.stream(WarningType.values()).collect(Collectors.toMap(WarningType::getDescp, Functions.identity()));
    }
}

