/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public enum WorkflowExecutionStatus {
    SUBMITTED_SUCCESS(0, "submit success"),
    RUNNING_EXECUTION(1, "running"),
    READY_PAUSE(2, "ready pause"),
    PAUSE(3, "pause"),
    READY_STOP(4, "ready stop"),
    STOP(5, "stop"),
    FAILURE(6, "failure"),
    SUCCESS(7, "success"),
    DELAY_EXECUTION(12, "delay execution"),
    SERIAL_WAIT(14, "serial wait"),
    READY_BLOCK(15, "ready block"),
    BLOCK(16, "block"),
    WAIT_TO_RUN(17, "wait to run");

    private static final Map<Integer, WorkflowExecutionStatus> CODE_MAP;
    private static final int[] NEED_FAILOVER_STATES;
    @EnumValue
    private final int code;
    private final String desc;

    @NonNull
    public static WorkflowExecutionStatus of(int code) {
        WorkflowExecutionStatus workflowExecutionStatus = CODE_MAP.get(code);
        if (workflowExecutionStatus == null) {
            throw new IllegalArgumentException(String.format("The workflow execution status code: %s is invalidated", code));
        }
        return workflowExecutionStatus;
    }

    public boolean isRunning() {
        return this == RUNNING_EXECUTION;
    }

    public boolean canStop() {
        return this == RUNNING_EXECUTION || this == READY_PAUSE;
    }

    public boolean isFinished() {
        return this.isSuccess() || this.isFailure() || this.isStop() || this.isPause() || this.isBlock();
    }

    public boolean isSuccess() {
        return this == SUCCESS;
    }

    public boolean isFailure() {
        return this == FAILURE;
    }

    public boolean isPause() {
        return this == PAUSE;
    }

    public boolean isReadyStop() {
        return this == READY_STOP;
    }

    public boolean isStop() {
        return this == STOP;
    }

    public boolean isBlock() {
        return this == BLOCK;
    }

    public static int[] getNeedFailoverWorkflowInstanceState() {
        return NEED_FAILOVER_STATES;
    }

    private WorkflowExecutionStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return "WorkflowExecutionStatus{code=" + this.code + ", desc='" + this.desc + '\'' + '}';
    }

    static {
        CODE_MAP = new HashMap<Integer, WorkflowExecutionStatus>();
        NEED_FAILOVER_STATES = new int[]{SUBMITTED_SUCCESS.getCode(), RUNNING_EXECUTION.getCode(), DELAY_EXECUTION.getCode(), READY_PAUSE.getCode(), READY_STOP.getCode()};
        for (WorkflowExecutionStatus executionStatus : WorkflowExecutionStatus.values()) {
            CODE_MAP.put(executionStatus.getCode(), executionStatus);
        }
    }
}

