/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.model;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.HeartBeat;

public class WorkerHeartBeat
implements HeartBeat {
    private long startupTime;
    private long reportTime;
    private double cpuUsage;
    private double jvmMemoryUsage;
    private double memoryUsage;
    private double diskUsage;
    private ServerStatus serverStatus;
    private int processId;
    private String host;
    private int port;
    private int workerHostWeight;
    private int threadPoolUsage;

    @Override
    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    @Generated
    public static WorkerHeartBeatBuilder builder() {
        return new WorkerHeartBeatBuilder();
    }

    @Generated
    public long getStartupTime() {
        return this.startupTime;
    }

    @Generated
    public long getReportTime() {
        return this.reportTime;
    }

    @Generated
    public double getCpuUsage() {
        return this.cpuUsage;
    }

    @Generated
    public double getJvmMemoryUsage() {
        return this.jvmMemoryUsage;
    }

    @Generated
    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    @Generated
    public double getDiskUsage() {
        return this.diskUsage;
    }

    @Generated
    public int getProcessId() {
        return this.processId;
    }

    @Override
    @Generated
    public String getHost() {
        return this.host;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int getWorkerHostWeight() {
        return this.workerHostWeight;
    }

    @Generated
    public int getThreadPoolUsage() {
        return this.threadPoolUsage;
    }

    @Generated
    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    @Generated
    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    @Generated
    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    @Generated
    public void setJvmMemoryUsage(double jvmMemoryUsage) {
        this.jvmMemoryUsage = jvmMemoryUsage;
    }

    @Generated
    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    @Generated
    public void setDiskUsage(double diskUsage) {
        this.diskUsage = diskUsage;
    }

    @Generated
    public void setServerStatus(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Generated
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setWorkerHostWeight(int workerHostWeight) {
        this.workerHostWeight = workerHostWeight;
    }

    @Generated
    public void setThreadPoolUsage(int threadPoolUsage) {
        this.threadPoolUsage = threadPoolUsage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerHeartBeat)) {
            return false;
        }
        WorkerHeartBeat other = (WorkerHeartBeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartupTime() != other.getStartupTime()) {
            return false;
        }
        if (this.getReportTime() != other.getReportTime()) {
            return false;
        }
        if (Double.compare(this.getCpuUsage(), other.getCpuUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmMemoryUsage(), other.getJvmMemoryUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryUsage(), other.getMemoryUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskUsage(), other.getDiskUsage()) != 0) {
            return false;
        }
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getWorkerHostWeight() != other.getWorkerHostWeight()) {
            return false;
        }
        if (this.getThreadPoolUsage() != other.getThreadPoolUsage()) {
            return false;
        }
        ServerStatus this$serverStatus = this.getServerStatus();
        ServerStatus other$serverStatus = other.getServerStatus();
        if (this$serverStatus == null ? other$serverStatus != null : !((Object)((Object)this$serverStatus)).equals((Object)other$serverStatus)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerHeartBeat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startupTime = this.getStartupTime();
        result = result * 59 + (int)($startupTime >>> 32 ^ $startupTime);
        long $reportTime = this.getReportTime();
        result = result * 59 + (int)($reportTime >>> 32 ^ $reportTime);
        long $cpuUsage = Double.doubleToLongBits(this.getCpuUsage());
        result = result * 59 + (int)($cpuUsage >>> 32 ^ $cpuUsage);
        long $jvmMemoryUsage = Double.doubleToLongBits(this.getJvmMemoryUsage());
        result = result * 59 + (int)($jvmMemoryUsage >>> 32 ^ $jvmMemoryUsage);
        long $memoryUsage = Double.doubleToLongBits(this.getMemoryUsage());
        result = result * 59 + (int)($memoryUsage >>> 32 ^ $memoryUsage);
        long $diskUsage = Double.doubleToLongBits(this.getDiskUsage());
        result = result * 59 + (int)($diskUsage >>> 32 ^ $diskUsage);
        result = result * 59 + this.getProcessId();
        result = result * 59 + this.getPort();
        result = result * 59 + this.getWorkerHostWeight();
        result = result * 59 + this.getThreadPoolUsage();
        ServerStatus $serverStatus = this.getServerStatus();
        result = result * 59 + ($serverStatus == null ? 43 : ((Object)((Object)$serverStatus)).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerHeartBeat(startupTime=" + this.getStartupTime() + ", reportTime=" + this.getReportTime() + ", cpuUsage=" + this.getCpuUsage() + ", jvmMemoryUsage=" + this.getJvmMemoryUsage() + ", memoryUsage=" + this.getMemoryUsage() + ", diskUsage=" + this.getDiskUsage() + ", serverStatus=" + (Object)((Object)this.getServerStatus()) + ", processId=" + this.getProcessId() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", workerHostWeight=" + this.getWorkerHostWeight() + ", threadPoolUsage=" + this.getThreadPoolUsage() + ")";
    }

    @Generated
    public WorkerHeartBeat() {
    }

    @Generated
    public WorkerHeartBeat(long startupTime, long reportTime, double cpuUsage, double jvmMemoryUsage, double memoryUsage, double diskUsage, ServerStatus serverStatus, int processId, String host, int port, int workerHostWeight, int threadPoolUsage) {
        this.startupTime = startupTime;
        this.reportTime = reportTime;
        this.cpuUsage = cpuUsage;
        this.jvmMemoryUsage = jvmMemoryUsage;
        this.memoryUsage = memoryUsage;
        this.diskUsage = diskUsage;
        this.serverStatus = serverStatus;
        this.processId = processId;
        this.host = host;
        this.port = port;
        this.workerHostWeight = workerHostWeight;
        this.threadPoolUsage = threadPoolUsage;
    }

    @Generated
    public static class WorkerHeartBeatBuilder {
        @Generated
        private long startupTime;
        @Generated
        private long reportTime;
        @Generated
        private double cpuUsage;
        @Generated
        private double jvmMemoryUsage;
        @Generated
        private double memoryUsage;
        @Generated
        private double diskUsage;
        @Generated
        private ServerStatus serverStatus;
        @Generated
        private int processId;
        @Generated
        private String host;
        @Generated
        private int port;
        @Generated
        private int workerHostWeight;
        @Generated
        private int threadPoolUsage;

        @Generated
        WorkerHeartBeatBuilder() {
        }

        @Generated
        public WorkerHeartBeatBuilder startupTime(long startupTime) {
            this.startupTime = startupTime;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder reportTime(long reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder cpuUsage(double cpuUsage) {
            this.cpuUsage = cpuUsage;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder jvmMemoryUsage(double jvmMemoryUsage) {
            this.jvmMemoryUsage = jvmMemoryUsage;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder memoryUsage(double memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder diskUsage(double diskUsage) {
            this.diskUsage = diskUsage;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder serverStatus(ServerStatus serverStatus) {
            this.serverStatus = serverStatus;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder processId(int processId) {
            this.processId = processId;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder workerHostWeight(int workerHostWeight) {
            this.workerHostWeight = workerHostWeight;
            return this;
        }

        @Generated
        public WorkerHeartBeatBuilder threadPoolUsage(int threadPoolUsage) {
            this.threadPoolUsage = threadPoolUsage;
            return this;
        }

        @Generated
        public WorkerHeartBeat build() {
            return new WorkerHeartBeat(this.startupTime, this.reportTime, this.cpuUsage, this.jvmMemoryUsage, this.memoryUsage, this.diskUsage, this.serverStatus, this.processId, this.host, this.port, this.workerHostWeight, this.threadPoolUsage);
        }

        @Generated
        public String toString() {
            return "WorkerHeartBeat.WorkerHeartBeatBuilder(startupTime=" + this.startupTime + ", reportTime=" + this.reportTime + ", cpuUsage=" + this.cpuUsage + ", jvmMemoryUsage=" + this.jvmMemoryUsage + ", memoryUsage=" + this.memoryUsage + ", diskUsage=" + this.diskUsage + ", serverStatus=" + (Object)((Object)this.serverStatus) + ", processId=" + this.processId + ", host=" + this.host + ", port=" + this.port + ", workerHostWeight=" + this.workerHostWeight + ", threadPoolUsage=" + this.threadPoolUsage + ")";
        }
    }
}

