/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String DATA_BASEDIR = PropertyUtils.getString("data.basedir.path", "/tmp/dolphinscheduler");
    public static final String APPINFO_PATH = "appInfo.log";
    public static final String KUBE_CONFIG_FILE = "config";
    private static final Set<PosixFilePermission> PERMISSION_755 = PosixFilePermissions.fromString("rwxr-xr-x");

    public static String getDownloadFilename(String filename) {
        String fileName = String.format("%s/download/%s/%s", DATA_BASEDIR, DateUtils.getCurrentTime("yyyyMMddHHmmss"), filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getUploadFilename(String tenantCode, String filename) {
        String fileName = String.format("%s/%s/resources/%s", DATA_BASEDIR, tenantCode, filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getTaskInstanceWorkingDirectory(String tenant, long projectCode, long processDefineCode, int processDefineVersion, int processInstanceId, int taskInstanceId) {
        return String.format("%s/exec/process/%s/%d/%d_%d/%d/%d", DATA_BASEDIR, tenant, projectCode, processDefineCode, processDefineVersion, processInstanceId, taskInstanceId);
    }

    public static String getKubeConfigPath(String execPath) {
        return String.format("%s/%s", execPath, KUBE_CONFIG_FILE);
    }

    public static String getAppInfoPath(String execPath) {
        return String.format("%s/%s", execPath, APPINFO_PATH);
    }

    public static String getResourceViewSuffixes() {
        return PropertyUtils.getString("resource.view.suffixs", "txt,log,sh,bat,conf,cfg,py,java,sql,xml,hql,properties,json,yml,yaml,ini,js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeContent2File(String content, String filePath) {
        FileOutputStream fos = null;
        try {
            File distFile = new File(filePath);
            if (!distFile.getParentFile().exists() && !distFile.getParentFile().mkdirs()) {
                log.error("mkdir parent failed");
                boolean bl = false;
                IOUtils.closeQuietly((OutputStream)fos);
                return bl;
            }
            fos = new FileOutputStream(filePath);
            IOUtils.write((String)content, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
        return true;
    }

    public static void deleteFile(String filename) {
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(filename));
    }

    public static String readFile2Str(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            return output.toString("UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean directoryTraversal(String filename) {
        if (filename.contains("/")) {
            return true;
        }
        File file = new File(filename);
        try {
            File canonical = file.getCanonicalFile();
            File absolute = file.getAbsoluteFile();
            return !canonical.equals(absolute);
        }
        catch (IOException e) {
            return true;
        }
    }

    public static String getFileChecksum(String pathName) throws IOException {
        CRC32 crc32 = new CRC32();
        File file = new File(pathName);
        String crcString = "";
        if (file.isDirectory()) {
            String[] subPaths = file.list();
            StringBuilder concatenatedCRC = new StringBuilder();
            for (String subPath : subPaths) {
                concatenatedCRC.append(FileUtils.getFileChecksum(pathName + "/" + subPath));
            }
            crcString = concatenatedCRC.toString();
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(pathName);
                 CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, crc32);){
                while (checkedInputStream.read() != -1) {
                }
            }
            catch (IOException e) {
                throw new IOException("Calculate checksum error.");
            }
            crcString = Long.toHexString(crc32.getValue());
        }
        return crcString;
    }

    public static void createFileWith755(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Files.createFile(path, new FileAttribute[0]);
        } else {
            Files.createFile(path, new FileAttribute[0]);
            Files.setPosixFilePermissions(path, PERMISSION_755);
        }
    }

    public static void createDirectoryWith755(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.toFile().exists()) {
            return;
        }
        if (OSUtils.isWindows().booleanValue()) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Path parent = path.getParent();
            if (parent != null && !parent.toFile().exists()) {
                FileUtils.createDirectoryWith755(parent);
            }
            try {
                Files.createDirectory(path, new FileAttribute[0]);
                Files.setPosixFilePermissions(path, PERMISSION_755);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                log.debug("The directory: {} already exists", (Object)path);
            }
        }
    }

    public static void setFileTo755(File file) throws IOException {
        if (OSUtils.isWindows().booleanValue()) {
            return;
        }
        if (file.isFile()) {
            Files.setPosixFilePermissions(file.toPath(), PERMISSION_755);
            return;
        }
        Files.setPosixFilePermissions(file.toPath(), PERMISSION_755);
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.setFileTo755(f);
            }
        }
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

