/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final PoolingHttpClientConnectionManager cm;
    private static final SSLContext ctx;
    private static final SSLConnectionSocketFactory socketFactory;
    private static final RequestConfig requestConfig;

    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static CloseableHttpClient getInstance() {
        return HttpClientInstance.httpClient;
    }

    public static HttpClientBuilder getHttpClientBuilder() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig);
    }

    public static String get(String url) {
        CloseableHttpClient httpClient = HttpUtils.getInstance();
        HttpGet httpGet = new HttpGet(url);
        return HttpUtils.getResponseContentString(httpGet, httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getResponseContentString(HttpGet httpGet, CloseableHttpClient httpClient) {
        if (httpGet == null || httpClient == null) {
            log.error("HttpGet or HttpClient parameter is null");
            return null;
        }
        try {
            String string;
            Throwable throwable;
            CloseableHttpResponse response;
            block25: {
                block26: {
                    block22: {
                        String string2;
                        block23: {
                            block24: {
                                response = httpClient.execute((HttpUriRequest)httpGet);
                                throwable = null;
                                if (response.getStatusLine().getStatusCode() == 200) break block22;
                                log.error("HTTP GET request to {} returned status code: {}", (Object)httpGet.getURI(), (Object)response.getStatusLine().getStatusCode());
                                string2 = null;
                                if (response == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            response.close();
                        }
                        return string2;
                    }
                    HttpEntity entity = response.getEntity();
                    String string3 = string = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
                    if (response == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                response.close();
            }
            return string;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (response != null) {
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (IOException e) {
                    log.error("Error executing HTTP GET request", (Throwable)e);
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    static {
        try {
            ctx = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Failed to get default SSLContext", (Throwable)e);
            throw new RuntimeException("Failed to get default SSLContext", e);
        }
        socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)new DefaultHostnameVerifier());
        requestConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest", "Negotiate")).setProxyPreferredAuthSchemes(Arrays.asList("Basic", "Negotiate")).setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).setRedirectsEnabled(true).build();
        cm = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build());
        cm.setDefaultMaxPerRoute(60);
        cm.setMaxTotal(100);
    }

    private static class HttpClientInstance {
        private static final CloseableHttpClient httpClient = HttpUtils.getHttpClientBuilder().build();

        private HttpClientInstance() {
        }
    }
}

