/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.MysqlPerformance;
import org.apache.dolphinscheduler.dao.utils.PostgrePerformance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorDBDao {
    private static Logger logger = LoggerFactory.getLogger(MonitorDBDao.class);
    public static final String VARIABLE_NAME = "variable_name";
    private static Configuration conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MonitorRecord getCurrentDbPerformance() {
        MonitorRecord monitorRecord = null;
        Connection conn = null;
        DruidDataSource dataSource = null;
        try {
            dataSource = ConnectionFactory.getDataSource();
            dataSource.setInitialSize(2);
            dataSource.setMinIdle(2);
            dataSource.setMaxActive(2);
            conn = dataSource.getConnection();
            if (conn == null) {
                MonitorRecord monitorRecord2 = monitorRecord;
                return monitorRecord2;
            }
            if (conf.getString("spring.datasource.driver-class-name").contains(DbType.MYSQL.toString().toLowerCase())) {
                MonitorRecord monitorRecord3 = new MysqlPerformance().getMonitorRecord(conn);
                return monitorRecord3;
            }
            if (conf.getString("spring.datasource.driver-class-name").contains(DbType.POSTGRESQL.toString().toLowerCase())) {
                MonitorRecord monitorRecord4 = new PostgrePerformance().getMonitorRecord(conn);
                return monitorRecord4;
            }
        }
        catch (Exception e) {
            logger.error("SQLException " + e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException ", (Throwable)e);
            }
        }
        return monitorRecord;
    }

    public static List<MonitorRecord> queryDatabaseState() {
        ArrayList<MonitorRecord> list = new ArrayList<MonitorRecord>(1);
        MonitorRecord monitorRecord = MonitorDBDao.getCurrentDbPerformance();
        if (monitorRecord != null) {
            list.add(monitorRecord);
        }
        return list;
    }

    static {
        try {
            conf = new PropertiesConfiguration("application-dao.properties");
        }
        catch (ConfigurationException e) {
            logger.error("load configuration excetpion", (Throwable)e);
            System.exit(1);
        }
    }
}

