/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.alibaba.fastjson.JSONObject;
import com.cronutils.model.Cron;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.model.DateInterval;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.queue.ITaskQueue;
import org.apache.dolphinscheduler.common.queue.TaskQueueFactory;
import org.apache.dolphinscheduler.common.task.subprocess.SubProcessParameters;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.IpUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.CycleDependency;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.apache.dolphinscheduler.dao.utils.cron.CronUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int[] stateArray = new int[]{ExecutionStatus.SUBMITTED_SUCCESS.ordinal(), ExecutionStatus.RUNNING_EXEUTION.ordinal(), ExecutionStatus.READY_PAUSE.ordinal(), ExecutionStatus.READY_STOP.ordinal()};
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private ProcessInstanceMapMapper processInstanceMapMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private WorkerGroupMapper workerGroupMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectMapper projectMapper;
    protected ITaskQueue taskQueue = TaskQueueFactory.getTaskQueueInstance();

    @Transactional(rollbackFor={Exception.class})
    public ProcessInstance handleCommand(Logger logger, String host, int validThreadNum, Command command) {
        ProcessInstance processInstance = this.constructProcessInstance(command, host);
        if (processInstance == null) {
            logger.error("scan command, command parameter is error: %s", (Object)command.toString());
            this.moveToErrorCommand(command, "process instance is null");
            return null;
        }
        if (!this.checkThreadNum(command, validThreadNum)) {
            logger.info("there is not enough thread for this command: {}", (Object)command.toString());
            return this.setWaitingThreadProcess(command, processInstance);
        }
        processInstance.setCommandType(command.getCommandType());
        processInstance.addHistoryCmd(command.getCommandType());
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.delCommandByid(command.getId());
        return processInstance;
    }

    @Transactional(rollbackFor={Exception.class})
    public void moveToErrorCommand(Command command, String message) {
        ErrorCommand errorCommand = new ErrorCommand(command, message);
        this.errorCommandMapper.insert(errorCommand);
        this.delCommandByid(command.getId());
    }

    private ProcessInstance setWaitingThreadProcess(Command command, ProcessInstance processInstance) {
        processInstance.setState(ExecutionStatus.WAITTING_THREAD);
        if (command.getCommandType() != CommandType.RECOVER_WAITTING_THREAD) {
            processInstance.addHistoryCmd(command.getCommandType());
        }
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.createRecoveryWaitingThreadCommand(command, processInstance);
        return null;
    }

    private boolean checkThreadNum(Command command, int validThreadNum) {
        int commandThreadCount = this.workProcessThreadNumCount(command.getProcessDefinitionId());
        return validThreadNum >= commandThreadCount;
    }

    public int createCommand(Command command) {
        int result = 0;
        if (command != null) {
            result = this.commandMapper.insert(command);
        }
        return result;
    }

    public Command findOneCommand() {
        return this.commandMapper.getOneToRun();
    }

    public Boolean verifyIsNeedCreateCommand(Command command) {
        Boolean isNeedCreate = true;
        HashMap<CommandType, Integer> cmdTypeMap = new HashMap<CommandType, Integer>();
        cmdTypeMap.put(CommandType.REPEAT_RUNNING, 1);
        cmdTypeMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, 1);
        cmdTypeMap.put(CommandType.START_FAILURE_TASK_PROCESS, 1);
        CommandType commandType = command.getCommandType();
        if (cmdTypeMap.containsKey(commandType)) {
            JSONObject cmdParamObj = (JSONObject)JSONObject.parse((String)command.getCommandParam());
            int processInstanceId = cmdParamObj.getInteger("ProcessInstanceId");
            List commands = this.commandMapper.selectList(null);
            for (Command tmpCommand : commands) {
                JSONObject tempObj;
                if (!cmdTypeMap.containsKey(tmpCommand.getCommandType()) || (tempObj = (JSONObject)JSONObject.parse((String)tmpCommand.getCommandParam())) == null || processInstanceId != tempObj.getInteger("ProcessInstanceId")) continue;
                isNeedCreate = false;
                break;
            }
        }
        return isNeedCreate;
    }

    public ProcessInstance findProcessInstanceDetailById(int processId) {
        return this.processInstanceMapper.queryDetailById(processId);
    }

    public ProcessInstance findProcessInstanceById(int processId) {
        return (ProcessInstance)this.processInstanceMapper.selectById(Integer.valueOf(processId));
    }

    public ProcessDefinition findProcessDefineById(int processDefinitionId) {
        return (ProcessDefinition)this.processDefineMapper.selectById(Integer.valueOf(processDefinitionId));
    }

    public int deleteWorkProcessInstanceById(int processInstanceId) {
        return this.processInstanceMapper.deleteById(Integer.valueOf(processInstanceId));
    }

    public int deleteAllSubWorkProcessByParentId(int processInstanceId) {
        List<Integer> subProcessIdList = this.processInstanceMapMapper.querySubIdListByParentId(processInstanceId);
        for (Integer subId : subProcessIdList) {
            this.deleteAllSubWorkProcessByParentId(subId);
            this.deleteWorkProcessMapByParentId(subId);
            this.deleteWorkProcessInstanceById(subId);
        }
        return 1;
    }

    private Integer workProcessThreadNumCount(Integer processDefinitionId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        this.recurseFindSubProcessId(processDefinitionId, ids);
        return ids.size() + 1;
    }

    public void recurseFindSubProcessId(int parentId, List<Integer> ids) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById(Integer.valueOf(parentId));
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List<TaskNode> taskNodeList = processData.getTasks();
        if (taskNodeList != null && taskNodeList.size() > 0) {
            for (TaskNode taskNode : taskNodeList) {
                String parameter = taskNode.getParams();
                if (!parameter.contains("processDefinitionId")) continue;
                SubProcessParameters subProcessParam = (SubProcessParameters)JSONObject.parseObject((String)parameter, SubProcessParameters.class);
                ids.add(subProcessParam.getProcessDefinitionId());
                this.recurseFindSubProcessId(subProcessParam.getProcessDefinitionId(), ids);
            }
        }
    }

    public void createRecoveryWaitingThreadCommand(Command originCommand, ProcessInstance processInstance) {
        if (processInstance.getIsSubProcess() == Flag.YES) {
            if (originCommand != null) {
                this.commandMapper.deleteById(Integer.valueOf(originCommand.getId()));
            }
            return;
        }
        HashMap<String, String> cmdParam = new HashMap<String, String>();
        cmdParam.put("WaittingThreadInstanceId", String.valueOf(processInstance.getId()));
        if (originCommand == null) {
            Command command = new Command(CommandType.RECOVER_WAITTING_THREAD, processInstance.getTaskDependType(), processInstance.getFailureStrategy(), processInstance.getExecutorId(), processInstance.getProcessDefinitionId(), JSONUtils.toJson(cmdParam), processInstance.getWarningType(), processInstance.getWarningGroupId(), processInstance.getScheduleTime(), processInstance.getProcessInstancePriority());
            this.saveCommand(command);
            return;
        }
        if (originCommand.getCommandType() == CommandType.RECOVER_WAITTING_THREAD) {
            originCommand.setUpdateTime(new Date());
            this.saveCommand(originCommand);
        } else {
            this.commandMapper.deleteById(Integer.valueOf(originCommand.getId()));
            originCommand.setId(0);
            originCommand.setCommandType(CommandType.RECOVER_WAITTING_THREAD);
            originCommand.setUpdateTime(new Date());
            originCommand.setCommandParam(JSONUtils.toJson(cmdParam));
            originCommand.setProcessInstancePriority(processInstance.getProcessInstancePriority());
            this.saveCommand(originCommand);
        }
    }

    private Date getScheduleTime(Command command, Map<String, String> cmdParam) {
        Date scheduleTime = command.getScheduleTime();
        if (scheduleTime == null && cmdParam != null && cmdParam.containsKey("complementStartDate")) {
            scheduleTime = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
        }
        return scheduleTime;
    }

    private ProcessInstance generateNewProcessInstance(ProcessDefinition processDefinition, Command command, Map<String, String> cmdParam) {
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        processInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
        processInstance.setRecovery(Flag.NO);
        processInstance.setStartTime(new Date());
        processInstance.setRunTimes(1);
        processInstance.setMaxTryTimes(0);
        processInstance.setProcessDefinitionId(command.getProcessDefinitionId());
        processInstance.setCommandParam(command.getCommandParam());
        processInstance.setCommandType(command.getCommandType());
        processInstance.setIsSubProcess(Flag.NO);
        processInstance.setTaskDependType(command.getTaskDependType());
        processInstance.setFailureStrategy(command.getFailureStrategy());
        processInstance.setExecutorId(command.getExecutorId());
        WarningType warningType = command.getWarningType() == null ? WarningType.NONE : command.getWarningType();
        processInstance.setWarningType(warningType);
        Integer warningGroupId = command.getWarningGroupId() == null ? 0 : command.getWarningGroupId();
        processInstance.setWarningGroupId(warningGroupId);
        Date scheduleTime = this.getScheduleTime(command, cmdParam);
        if (scheduleTime != null) {
            processInstance.setScheduleTime(scheduleTime);
        }
        processInstance.setCommandStartTime(command.getStartTime());
        processInstance.setLocations(processDefinition.getLocations());
        processInstance.setConnects(processDefinition.getConnects());
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams(processDefinition.getGlobalParamMap(), processDefinition.getGlobalParamList(), (CommandType)this.getCommandTypeIfComplement(processInstance, command), (Date)processInstance.getScheduleTime()));
        processInstance.setProcessInstanceJson(processDefinition.getProcessDefinitionJson());
        processInstance.setProcessInstancePriority(command.getProcessInstancePriority());
        int workerGroupId = command.getWorkerGroupId() == 0 ? -1 : command.getWorkerGroupId();
        processInstance.setWorkerGroupId(workerGroupId);
        processInstance.setTimeout(processDefinition.getTimeout());
        processInstance.setTenantId(processDefinition.getTenantId());
        return processInstance;
    }

    public Tenant getTenantForProcess(int tenantId, int userId) {
        Tenant tenant = null;
        if (tenantId >= 0) {
            tenant = this.tenantMapper.queryById(tenantId);
        }
        if (tenant == null) {
            User user = (User)this.userMapper.selectById(Integer.valueOf(userId));
            tenant = this.tenantMapper.queryById(user.getTenantId());
        }
        return tenant;
    }

    private Boolean checkCmdParam(Command command, Map<String, String> cmdParam) {
        if (!(command.getTaskDependType() != TaskDependType.TASK_ONLY && command.getTaskDependType() != TaskDependType.TASK_PRE || cmdParam != null && cmdParam.containsKey("StartNodeNameList") && !cmdParam.get("StartNodeNameList").isEmpty())) {
            this.logger.error(String.format("command node depend type is %s, but start nodes is null ", command.getTaskDependType().toString()));
            return false;
        }
        return true;
    }

    private ProcessInstance constructProcessInstance(Command command, String host) {
        ProcessInstance processInstance = null;
        CommandType commandType = command.getCommandType();
        Map cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        ProcessDefinition processDefinition = null;
        if (command.getProcessDefinitionId() != 0 && (processDefinition = (ProcessDefinition)this.processDefineMapper.selectById(Integer.valueOf(command.getProcessDefinitionId()))) == null) {
            this.logger.error(String.format("cannot find the work process define! define id : %d", command.getProcessDefinitionId()));
            return null;
        }
        if (cmdParam != null) {
            String pId;
            Integer processInstanceId = 0;
            if (cmdParam.containsKey("ProcessInstanceId")) {
                String processId = (String)cmdParam.get("ProcessInstanceId");
                processInstanceId = Integer.parseInt(processId);
                if (processInstanceId == 0) {
                    this.logger.error("command parameter is error, [ ProcessInstanceId ] is 0");
                    return null;
                }
            } else if (cmdParam.containsKey("processInstanceId")) {
                pId = (String)cmdParam.get("processInstanceId");
                processInstanceId = Integer.parseInt(pId);
            } else if (cmdParam.containsKey("WaittingThreadInstanceId")) {
                pId = (String)cmdParam.get("WaittingThreadInstanceId");
                processInstanceId = Integer.parseInt(pId);
            }
            processInstance = processInstanceId == 0 ? this.generateNewProcessInstance(processDefinition, command, cmdParam) : this.findProcessInstanceDetailById(processInstanceId);
            processDefinition = (ProcessDefinition)this.processDefineMapper.selectById(Integer.valueOf(processInstance.getProcessDefinitionId()));
            processInstance.setProcessDefinition(processDefinition);
            if (processInstance.getCommandParam() != null) {
                Map processCmdParam = JSONUtils.toMap((String)processInstance.getCommandParam());
                for (Map.Entry entry : processCmdParam.entrySet()) {
                    if (cmdParam.containsKey(entry.getKey())) continue;
                    cmdParam.put(entry.getKey(), entry.getValue());
                }
            }
            if (cmdParam.containsKey("processInstanceId")) {
                processInstance.setCommandParam(command.getCommandParam());
            }
        } else {
            processInstance = this.generateNewProcessInstance(processDefinition, command, cmdParam);
        }
        if (!this.checkCmdParam(command, cmdParam).booleanValue()) {
            this.logger.error("command parameter check failed!");
            return null;
        }
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setHost(host);
        ExecutionStatus runStatus = ExecutionStatus.RUNNING_EXEUTION;
        int runTime = processInstance.getRunTimes();
        switch (commandType) {
            case START_PROCESS: {
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                List<Integer> failedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.FAILURE);
                List<Integer> toleranceList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.NEED_FAULT_TOLERANCE);
                List<Integer> killedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                cmdParam.remove("StartNodeIdList");
                failedList.addAll(killedList);
                failedList.addAll(toleranceList);
                for (Integer taskId : failedList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(failedList)));
                processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case START_CURRENT_TASK_PROCESS: {
                break;
            }
            case RECOVER_WAITTING_THREAD: {
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                cmdParam.remove("StartNodeIdList");
                List<Integer> suspendedNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.PAUSE);
                List<Integer> stopNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                suspendedNodeList.addAll(stopNodeList);
                for (Integer taskId : suspendedNodeList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(suspendedNodeList)));
                processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                processInstance.setRecovery(Flag.YES);
                runStatus = processInstance.getState();
                break;
            }
            case COMPLEMENT_DATA: {
                List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : taskInstanceList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                break;
            }
            case REPEAT_RUNNING: {
                if (cmdParam.containsKey("StartNodeIdList")) {
                    cmdParam.remove("StartNodeIdList");
                    processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
                }
                List<TaskInstance> validTaskList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : validTaskList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                processInstance.setStartTime(new Date());
                processInstance.setEndTime(null);
                processInstance.setRunTimes(runTime + 1);
                this.initComplementDataParam(processDefinition, processInstance, cmdParam);
                break;
            }
            case SCHEDULER: {
                break;
            }
        }
        processInstance.setState(runStatus);
        return processInstance;
    }

    private CommandType getCommandTypeIfComplement(ProcessInstance processInstance, Command command) {
        if (CommandType.COMPLEMENT_DATA == processInstance.getCmdTypeIfComplement()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return command.getCommandType();
    }

    private void initComplementDataParam(ProcessDefinition processDefinition, ProcessInstance processInstance, Map<String, String> cmdParam) {
        if (!processInstance.isComplementData().booleanValue()) {
            return;
        }
        Date startComplementTime = DateUtils.parse((String)cmdParam.get("complementStartDate"), (String)"yyyy-MM-dd HH:mm:ss");
        processInstance.setScheduleTime(startComplementTime);
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams(processDefinition.getGlobalParamMap(), processDefinition.getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)processInstance.getScheduleTime()));
    }

    public ProcessInstance setSubProcessParam(ProcessInstance subProcessInstance) {
        ProcessInstanceMap processInstanceMap;
        String parentInstanceId;
        String cmdParam = subProcessInstance.getCommandParam();
        if (StringUtils.isEmpty((CharSequence)cmdParam)) {
            return subProcessInstance;
        }
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap.containsKey("processInstanceId") && "0".equals(paramMap.get("processInstanceId"))) {
            paramMap.remove("processInstanceId");
            paramMap.put("processInstanceId", String.valueOf(subProcessInstance.getId()));
            subProcessInstance.setCommandParam(JSONUtils.toJson((Object)paramMap));
            subProcessInstance.setIsSubProcess(Flag.YES);
            this.saveProcessInstance(subProcessInstance);
        }
        if (StringUtils.isNotEmpty((CharSequence)(parentInstanceId = (String)paramMap.get("parentProcessInstanceId")))) {
            ProcessInstance parentInstance = this.findProcessInstanceDetailById(Integer.parseInt(parentInstanceId));
            if (parentInstance != null) {
                subProcessInstance.setGlobalParams(this.joinGlobalParams(parentInstance.getGlobalParams(), subProcessInstance.getGlobalParams()));
                this.saveProcessInstance(subProcessInstance);
            } else {
                this.logger.error("sub process command params error, cannot find parent instance: {} ", (Object)cmdParam);
            }
        }
        if ((processInstanceMap = (ProcessInstanceMap)JSONUtils.parseObject((String)cmdParam, ProcessInstanceMap.class)) == null || processInstanceMap.getParentProcessInstanceId() == 0) {
            return subProcessInstance;
        }
        processInstanceMap.setProcessInstanceId(subProcessInstance.getId());
        this.updateWorkProcessInstanceMap(processInstanceMap);
        return subProcessInstance;
    }

    private String joinGlobalParams(String parentGlobalParams, String subGlobalParams) {
        List parentPropertyList = JSONUtils.toList((String)parentGlobalParams, Property.class);
        List subPropertyList = JSONUtils.toList((String)subGlobalParams, Property.class);
        Map<String, String> subMap = subPropertyList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        for (Property parent : parentPropertyList) {
            if (subMap.containsKey(parent.getProp())) continue;
            subPropertyList.add(parent);
        }
        return JSONUtils.toJson((Object)subPropertyList);
    }

    private void initTaskInstance(TaskInstance taskInstance) {
        if (!taskInstance.isSubProcess().booleanValue() && (taskInstance.getState().typeIsCancel() || taskInstance.getState().typeIsFailure())) {
            taskInstance.setFlag(Flag.NO);
            this.updateTaskInstance(taskInstance);
            return;
        }
        taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
        this.updateTaskInstance(taskInstance);
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskInstance submitTask(TaskInstance taskInstance, ProcessInstance processInstance) {
        this.logger.info("start submit task : {}, instance id:{}, state: {}, ", new Object[]{taskInstance.getName(), processInstance.getId(), processInstance.getState()});
        processInstance = this.findProcessInstanceDetailById(processInstance.getId());
        TaskInstance task = this.submitTaskInstanceToMysql(taskInstance, processInstance);
        if (task.isSubProcess().booleanValue() && !task.getState().typeIsFinished()) {
            ProcessInstanceMap processInstanceMap = this.setProcessInstanceMap(processInstance, task);
            TaskNode taskNode = (TaskNode)JSONUtils.parseObject((String)task.getTaskJson(), TaskNode.class);
            Map subProcessParam = JSONUtils.toMap((String)taskNode.getParams());
            Integer defineId = Integer.parseInt((String)subProcessParam.get("processDefinitionId"));
            this.createSubWorkProcessCommand(processInstance, processInstanceMap, defineId, task);
        } else if (!task.getState().typeIsFinished()) {
            task.setProcessInstancePriority(processInstance.getProcessInstancePriority());
            this.submitTaskToQueue(task);
        }
        this.logger.info("submit task :{} state:{} complete, instance id:{} state: {}  ", new Object[]{taskInstance.getName(), task.getState(), processInstance.getId(), processInstance.getState()});
        return task;
    }

    private ProcessInstanceMap setProcessInstanceMap(ProcessInstance parentInstance, TaskInstance parentTask) {
        ProcessInstanceMap processMap = this.findWorkProcessMapByParent(parentInstance.getId(), parentTask.getId());
        if (processMap != null) {
            return processMap;
        }
        if ((parentInstance.getCommandType() == CommandType.REPEAT_RUNNING || parentInstance.isComplementData().booleanValue()) && (processMap = this.findPreviousTaskProcessMap(parentInstance, parentTask)) != null) {
            processMap.setParentTaskInstanceId(parentTask.getId());
            this.updateWorkProcessInstanceMap(processMap);
            return processMap;
        }
        processMap = new ProcessInstanceMap();
        processMap.setParentProcessInstanceId(parentInstance.getId());
        processMap.setParentTaskInstanceId(parentTask.getId());
        this.createWorkProcessInstanceMap(processMap);
        return processMap;
    }

    private ProcessInstanceMap findPreviousTaskProcessMap(ProcessInstance parentProcessInstance, TaskInstance parentTask) {
        Integer preTaskId = 0;
        List<TaskInstance> preTaskList = this.findPreviousTaskListByWorkProcessId(parentProcessInstance.getId());
        for (TaskInstance task : preTaskList) {
            if (!task.getName().equals(parentTask.getName())) continue;
            preTaskId = task.getId();
            ProcessInstanceMap map = this.findWorkProcessMapByParent(parentProcessInstance.getId(), preTaskId);
            if (map == null) continue;
            return map;
        }
        this.logger.info("sub process instance is not found,parent task:{},parent instance:{}", (Object)parentTask.getId(), (Object)parentProcessInstance.getId());
        return null;
    }

    private void createSubWorkProcessCommand(ProcessInstance parentProcessInstance, ProcessInstanceMap instanceMap, Integer childDefineId, TaskInstance task) {
        String fatherHistoryCommand;
        CommandType fatherType;
        ProcessInstance childInstance = this.findSubProcessInstance(parentProcessInstance.getId(), task.getId());
        CommandType commandType = fatherType = parentProcessInstance.getCommandType();
        if ((childInstance == null || commandType == CommandType.REPEAT_RUNNING) && ((fatherHistoryCommand = parentProcessInstance.getHistoryCmd()).startsWith(CommandType.SCHEDULER.toString()) || fatherHistoryCommand.startsWith(CommandType.COMPLEMENT_DATA.toString()))) {
            commandType = CommandType.valueOf((String)fatherHistoryCommand.split(",")[0]);
        }
        if (childInstance != null) {
            childInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
            this.updateProcessInstance(childInstance);
        }
        String processMapStr = JSONUtils.toJson((Object)instanceMap);
        Map cmdParam = JSONUtils.toMap((String)processMapStr);
        if (commandType == CommandType.COMPLEMENT_DATA || childInstance != null && childInstance.isComplementData().booleanValue()) {
            Map parentParam = JSONUtils.toMap((String)parentProcessInstance.getCommandParam());
            String endTime = (String)parentParam.get("complementEndDate");
            String startTime = (String)parentParam.get("complementStartDate");
            cmdParam.put("complementEndDate", endTime);
            cmdParam.put("complementStartDate", startTime);
            processMapStr = JSONUtils.toJson((Object)cmdParam);
        }
        this.updateSubProcessDefinitionByParent(parentProcessInstance, childDefineId);
        Command command = new Command();
        command.setWarningType(parentProcessInstance.getWarningType());
        command.setWarningGroupId(parentProcessInstance.getWarningGroupId());
        command.setFailureStrategy(parentProcessInstance.getFailureStrategy());
        command.setProcessDefinitionId(childDefineId);
        command.setScheduleTime(parentProcessInstance.getScheduleTime());
        command.setExecutorId(parentProcessInstance.getExecutorId());
        command.setCommandParam(processMapStr);
        command.setCommandType(commandType);
        command.setProcessInstancePriority(parentProcessInstance.getProcessInstancePriority());
        this.createCommand(command);
        this.logger.info("sub process command created: {} ", (Object)command.toString());
    }

    private void updateSubProcessDefinitionByParent(ProcessInstance parentProcessInstance, int childDefinitionId) {
        ProcessDefinition fatherDefinition = this.findProcessDefineById(parentProcessInstance.getProcessDefinitionId());
        ProcessDefinition childDefinition = this.findProcessDefineById(childDefinitionId);
        if (childDefinition != null && fatherDefinition != null) {
            childDefinition.setReceivers(fatherDefinition.getReceivers());
            childDefinition.setReceiversCc(fatherDefinition.getReceiversCc());
            this.processDefineMapper.updateById(childDefinition);
        }
    }

    public TaskInstance submitTaskInstanceToMysql(TaskInstance taskInstance, ProcessInstance processInstance) {
        ExecutionStatus processInstanceState = processInstance.getState();
        if (taskInstance.getState().typeIsFailure()) {
            if (taskInstance.isSubProcess().booleanValue()) {
                taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
            } else if (processInstanceState != ExecutionStatus.READY_STOP && processInstanceState != ExecutionStatus.READY_PAUSE) {
                taskInstance.setFlag(Flag.NO);
                this.updateTaskInstance(taskInstance);
                if (taskInstance.getState() != ExecutionStatus.NEED_FAULT_TOLERANCE) {
                    taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
                }
                taskInstance.setEndTime(null);
                taskInstance.setStartTime(new Date());
                taskInstance.setFlag(Flag.YES);
                taskInstance.setHost(null);
                taskInstance.setId(0);
            }
        }
        taskInstance.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        taskInstance.setState(this.getSubmitTaskState(taskInstance, processInstanceState));
        taskInstance.setSubmitTime(new Date());
        this.saveTaskInstance(taskInstance);
        return taskInstance;
    }

    public Boolean submitTaskToQueue(TaskInstance taskInstance) {
        try {
            if (taskInstance.getState() == ExecutionStatus.RUNNING_EXEUTION) {
                this.logger.info(String.format("submit to task queue, but task [%s] state already be running. ", taskInstance.getName()));
                return true;
            }
            if (this.checkTaskExistsInTaskQueue(taskInstance)) {
                this.logger.info(String.format("submit to task queue, but task [%s] already exists in the queue.", taskInstance.getName()));
                return true;
            }
            this.logger.info("task ready to queue: {}", (Object)taskInstance);
            this.taskQueue.add("tasks_queue", this.taskZkInfo(taskInstance));
            this.logger.info(String.format("master insert into queue success, task : %s", taskInstance.getName()));
            return true;
        }
        catch (Exception e) {
            this.logger.error("submit task to queue Exception: ", (Throwable)e);
            this.logger.error("task queue error : %s", (Object)JSONUtils.toJson((Object)taskInstance));
            return false;
        }
    }

    public String taskZkInfo(TaskInstance taskInstance) {
        int taskWorkerGroupId = this.getTaskWorkerGroupId(taskInstance);
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        if (processInstance == null) {
            this.logger.error("process instance is null. please check the task info, task id: " + taskInstance.getId());
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(processInstance.getProcessInstancePriority().ordinal()).append("_").append(taskInstance.getProcessInstanceId()).append("_").append(taskInstance.getTaskInstancePriority().ordinal()).append("_").append(taskInstance.getId()).append("_");
        if (taskWorkerGroupId > 0) {
            String[] ipArray;
            WorkerGroup workerGroup = this.queryWorkerGroupById(taskWorkerGroupId);
            if (workerGroup == null) {
                this.logger.info("task {} cannot find the worker group, use all worker instead.", (Object)taskInstance.getId());
                sb.append(-1);
                return sb.toString();
            }
            String ips = workerGroup.getIpList();
            if (StringUtils.isBlank((CharSequence)ips)) {
                this.logger.error("task:{} worker group:{} parameters(ip_list) is null, this task would be running on all workers", (Object)taskInstance.getId(), (Object)workerGroup.getId());
                sb.append(-1);
                return sb.toString();
            }
            StringBuilder ipSb = new StringBuilder(100);
            for (String ip : ipArray = ips.split(",")) {
                long ipLong = IpUtils.ipToLong((String)ip);
                ipSb.append(ipLong).append(",");
            }
            if (ipSb.length() > 0) {
                ipSb.deleteCharAt(ipSb.length() - 1);
            }
            sb.append((CharSequence)ipSb);
        } else {
            sb.append(-1);
        }
        return sb.toString();
    }

    public ExecutionStatus getSubmitTaskState(TaskInstance taskInstance, ExecutionStatus processInstanceState) {
        ExecutionStatus state = taskInstance.getState();
        if (state == ExecutionStatus.RUNNING_EXEUTION || state == ExecutionStatus.KILL || this.checkTaskExistsInTaskQueue(taskInstance)) {
            return state;
        }
        state = processInstanceState == ExecutionStatus.READY_PAUSE ? ExecutionStatus.PAUSE : (processInstanceState == ExecutionStatus.READY_STOP || !this.checkProcessStrategy(taskInstance) ? ExecutionStatus.KILL : ExecutionStatus.SUBMITTED_SUCCESS);
        return state;
    }

    private boolean checkProcessStrategy(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        FailureStrategy failureStrategy = processInstance.getFailureStrategy();
        if (failureStrategy == FailureStrategy.CONTINUE) {
            return true;
        }
        List<TaskInstance> taskInstances = this.findValidTaskListByProcessId(taskInstance.getProcessInstanceId());
        for (TaskInstance task : taskInstances) {
            if (task.getState() != ExecutionStatus.FAILURE) continue;
            return false;
        }
        return true;
    }

    public boolean checkTaskExistsInTaskQueue(TaskInstance taskInstance) {
        if (taskInstance.isSubProcess().booleanValue()) {
            return false;
        }
        String taskZkInfo = this.taskZkInfo(taskInstance);
        return this.taskQueue.checkTaskExists("tasks_queue", taskZkInfo);
    }

    public void createProcessInstance(ProcessInstance processInstance) {
        if (processInstance != null) {
            this.processInstanceMapper.insert(processInstance);
        }
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        if (processInstance == null) {
            this.logger.error("save error, process instance is null!");
            return;
        }
        if (processInstance.getId() != 0) {
            this.processInstanceMapper.updateById(processInstance);
        } else {
            this.createProcessInstance(processInstance);
        }
    }

    public int saveCommand(Command command) {
        if (command.getId() != 0) {
            return this.commandMapper.updateById(command);
        }
        return this.commandMapper.insert(command);
    }

    public boolean saveTaskInstance(TaskInstance taskInstance) {
        if (taskInstance.getId() != 0) {
            return this.updateTaskInstance(taskInstance);
        }
        return this.createTaskInstance(taskInstance);
    }

    public boolean createTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.insert(taskInstance);
        return count > 0;
    }

    public boolean updateTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.updateById(taskInstance);
        return count > 0;
    }

    public void delCommandByid(int id) {
        this.commandMapper.deleteById(Integer.valueOf(id));
    }

    public TaskInstance findTaskInstanceById(Integer taskId) {
        return (TaskInstance)this.taskInstanceMapper.selectById(taskId);
    }

    public TaskInstance getTaskInstanceDetailByTaskId(int taskInstId) {
        TaskInstance taskInstance = this.findTaskInstanceById(taskInstId);
        if (taskInstance == null) {
            return taskInstance;
        }
        ProcessInstance processInstance = this.findProcessInstanceDetailById(taskInstance.getProcessInstanceId());
        ProcessDefinition processDefine = this.findProcessDefineById(taskInstance.getProcessDefinitionId());
        taskInstance.setProcessInstance(processInstance);
        taskInstance.setProcessDefine(processDefine);
        return taskInstance;
    }

    public List<Integer> findTaskIdByInstanceState(int instanceId, ExecutionStatus state) {
        return this.taskInstanceMapper.queryTaskByProcessIdAndState(instanceId, state.ordinal());
    }

    public List<TaskInstance> findValidTaskListByProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.YES);
    }

    public List<TaskInstance> findPreviousTaskListByWorkProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.NO);
    }

    public int updateWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        return this.processInstanceMapMapper.updateById(processInstanceMap);
    }

    public int createWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        Integer count = 0;
        if (processInstanceMap != null) {
            return this.processInstanceMapMapper.insert(processInstanceMap);
        }
        return count;
    }

    public ProcessInstanceMap findWorkProcessMapByParent(Integer parentWorkProcessId, Integer parentTaskId) {
        return this.processInstanceMapMapper.queryByParentId(parentWorkProcessId, parentTaskId);
    }

    public int deleteWorkProcessMapByParentId(int parentWorkProcessId) {
        return this.processInstanceMapMapper.deleteByParentProcessId(parentWorkProcessId);
    }

    public ProcessInstance findSubProcessInstance(Integer parentProcessId, Integer parentTaskId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryByParentId(parentProcessId, parentTaskId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getProcessInstanceId());
        return processInstance;
    }

    public ProcessInstance findParentProcessInstance(Integer subProcessId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(subProcessId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        return processInstance;
    }

    public void changeTaskState(ExecutionStatus state, Date startTime, String host, String executePath, String logPath, int taskInstId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById(Integer.valueOf(taskInstId));
        taskInstance.setState(state);
        taskInstance.setStartTime(startTime);
        taskInstance.setHost(host);
        taskInstance.setExecutePath(executePath);
        taskInstance.setLogPath(logPath);
        this.saveTaskInstance(taskInstance);
    }

    public int updateProcessInstance(ProcessInstance processInstance) {
        return this.processInstanceMapper.updateById(processInstance);
    }

    public int updateProcessInstance(Integer processInstanceId, String processJson, String globalParams, Date scheduleTime, Flag flag, String locations, String connects) {
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId);
        if (processInstance != null) {
            processInstance.setProcessInstanceJson(processJson);
            processInstance.setGlobalParams(globalParams);
            processInstance.setScheduleTime(scheduleTime);
            processInstance.setLocations(locations);
            processInstance.setConnects(connects);
            return this.processInstanceMapper.updateById(processInstance);
        }
        return 0;
    }

    public void changeTaskState(ExecutionStatus state, Date endTime, int taskInstId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById(Integer.valueOf(taskInstId));
        taskInstance.setState(state);
        taskInstance.setEndTime(endTime);
        this.saveTaskInstance(taskInstance);
    }

    public List<String> convertIntListToString(List<Integer> intList) {
        if (intList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(intList.size());
        for (Integer intVar : intList) {
            result.add(String.valueOf(intVar));
        }
        return result;
    }

    public void updatePidByTaskInstId(int taskInstId, int pid, String appLinks) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById(Integer.valueOf(taskInstId));
        taskInstance.setPid(pid);
        taskInstance.setAppLink(appLinks);
        this.saveTaskInstance(taskInstance);
    }

    public Schedule querySchedule(int id) {
        return (Schedule)this.scheduleMapper.selectById(Integer.valueOf(id));
    }

    public List<ProcessInstance> queryNeedFailoverProcessInstances(String host) {
        return this.processInstanceMapper.queryByHostAndStatus(host, this.stateArray);
    }

    @Transactional(rollbackFor={Exception.class})
    public void processNeedFailoverProcessInstances(ProcessInstance processInstance) {
        processInstance.setHost("null");
        this.processInstanceMapper.updateById(processInstance);
        Command cmd = new Command();
        cmd.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        cmd.setCommandParam(String.format("{\"%s\":%d}", "ProcessInstanceId", processInstance.getId()));
        cmd.setExecutorId(processInstance.getExecutorId());
        cmd.setCommandType(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS);
        this.createCommand(cmd);
    }

    public List<TaskInstance> queryNeedFailoverTaskInstances(String host) {
        return this.taskInstanceMapper.queryByHostAndStatus(host, this.stateArray);
    }

    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById(Integer.valueOf(id));
    }

    public int updateProcessInstanceState(Integer processInstanceId, ExecutionStatus executionStatus) {
        ProcessInstance instance = (ProcessInstance)this.processInstanceMapper.selectById(processInstanceId);
        instance.setState(executionStatus);
        return this.processInstanceMapper.updateById(instance);
    }

    public ProcessInstance findProcessInstanceByTaskId(int taskId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById(Integer.valueOf(taskId));
        if (taskInstance != null) {
            return (ProcessInstance)this.processInstanceMapper.selectById(Integer.valueOf(taskInstance.getProcessInstanceId()));
        }
        return null;
    }

    public List<UdfFunc> queryUdfFunListByids(int[] ids) {
        return this.udfFuncMapper.queryUdfByIdStr(ids, null);
    }

    public String queryTenantCodeByResName(String resName) {
        return this.resourceMapper.queryTenantCodeByResourceName(resName);
    }

    public List<Schedule> selectAllByProcessDefineId(int[] ids) {
        return this.scheduleMapper.selectAllByProcessDefineArray(ids);
    }

    public CycleDependency getCycleDependency(int masterId, int processDefinitionId, Date scheduledFireTime) throws Exception {
        List<CycleDependency> list = this.getCycleDependencies(masterId, new int[]{processDefinitionId}, scheduledFireTime);
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<CycleDependency> getCycleDependencies(int masterId, int[] ids, Date scheduledFireTime) throws Exception {
        ArrayList<CycleDependency> cycleDependencyList = new ArrayList<CycleDependency>();
        if (ArrayUtils.isEmpty((int[])ids)) {
            this.logger.warn("ids[] is empty!is invalid!");
            return cycleDependencyList;
        }
        if (scheduledFireTime == null) {
            this.logger.warn("scheduledFireTime is null!is invalid!");
            return cycleDependencyList;
        }
        String strCrontab = "";
        List<Schedule> schedules = this.selectAllByProcessDefineId(ids);
        block6: for (Schedule depSchedule : schedules) {
            strCrontab = depSchedule.getCrontab();
            CronExpression depCronExpression = CronUtils.parse2CronExpression(strCrontab);
            Cron depCron = CronUtils.parse2Cron(strCrontab);
            CycleEnum cycleEnum = CronUtils.getMiniCycle(depCron);
            if (cycleEnum == null) {
                this.logger.error("{} is not valid", (Object)strCrontab);
                continue;
            }
            Calendar calendar = Calendar.getInstance();
            switch (cycleEnum) {
                case HOUR: {
                    calendar.add(10, -25);
                    break;
                }
                case DAY: {
                    calendar.add(5, -32);
                    break;
                }
                case WEEK: {
                    calendar.add(5, -32);
                    break;
                }
                case MONTH: {
                    calendar.add(2, -13);
                    break;
                }
                default: {
                    this.logger.warn("Dependent process definition's  cycleEnum is {},not support!!", (Object)cycleEnum.name());
                    continue block6;
                }
            }
            Date start = calendar.getTime();
            List<Date> list = depSchedule.getProcessDefinitionId() == masterId ? CronUtils.getSelfFireDateList(start, scheduledFireTime, depCronExpression) : CronUtils.getFireDateList(start, scheduledFireTime, depCronExpression);
            if (list.size() < 1) continue;
            start = list.get(list.size() - 1);
            CycleDependency dependency = new CycleDependency(depSchedule.getProcessDefinitionId(), start, CronUtils.getExpirationTime(start, cycleEnum), cycleEnum);
            cycleDependencyList.add(dependency);
        }
        return cycleDependencyList;
    }

    public ProcessInstance findLastSchedulerProcessInterval(int definitionId, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastSchedulerProcess(definitionId, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    public ProcessInstance findLastManualProcessInterval(int definitionId, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastManualProcess(definitionId, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    public ProcessInstance findLastRunningProcess(int definitionId, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastRunningProcess(definitionId, dateInterval.getStartTime(), dateInterval.getEndTime(), this.stateArray);
    }

    public String queryUserQueueByProcessInstanceId(int processInstanceId) {
        String queue = "";
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById(Integer.valueOf(processInstanceId));
        if (processInstance == null) {
            return queue;
        }
        User executor = (User)this.userMapper.selectById(Integer.valueOf(processInstance.getExecutorId()));
        if (executor != null) {
            queue = executor.getQueue();
        }
        return queue;
    }

    public WorkerGroup queryWorkerGroupById(int workerGroupId) {
        return (WorkerGroup)this.workerGroupMapper.selectById(Integer.valueOf(workerGroupId));
    }

    public int getTaskWorkerGroupId(TaskInstance taskInstance) {
        int taskWorkerGroupId = taskInstance.getWorkerGroupId();
        if (taskWorkerGroupId > 0) {
            return taskWorkerGroupId;
        }
        int processInstanceId = taskInstance.getProcessInstanceId();
        ProcessInstance processInstance = this.findProcessInstanceById(processInstanceId);
        if (processInstance != null) {
            return processInstance.getWorkerGroupId();
        }
        this.logger.info("task : {} will use default worker group id", (Object)taskInstance.getId());
        return -1;
    }

    public List<Project> getProjectListHavePerm(int userId) {
        List<Project> createProjects = this.projectMapper.queryProjectCreatedByUser(userId);
        List<Project> authedProjects = this.projectMapper.queryAuthedProjectListByUserId(userId);
        if (createProjects == null) {
            createProjects = new ArrayList<Project>();
        }
        if (authedProjects != null) {
            createProjects.addAll(authedProjects);
        }
        return createProjects;
    }

    public List<Integer> getProjectIdListHavePerm(int userId) {
        ArrayList<Integer> projectIdList = new ArrayList<Integer>();
        for (Project project : this.getProjectListHavePerm(userId)) {
            projectIdList.add(project.getId());
        }
        return projectIdList;
    }
}

