/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;

@TableName(value="t_ds_task_instance")
public class TaskInstance {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private String name;
    private String taskType;
    private int processDefinitionId;
    private int processInstanceId;
    @TableField(exist=false)
    private String processInstanceName;
    private String taskJson;
    private ExecutionStatus state;
    private Date submitTime;
    private Date startTime;
    private Date endTime;
    private String host;
    private String executePath;
    private String logPath;
    private int retryTimes;
    private Flag alertFlag;
    @TableField(exist=false)
    private ProcessInstance processInstance;
    @TableField(exist=false)
    private ProcessDefinition processDefine;
    private int pid;
    private String appLink;
    private Flag flag;
    @TableField(exist=false)
    private String dependency;
    @TableField(exist=false)
    private Long duration;
    private int maxRetryTimes;
    private int retryInterval;
    private Priority taskInstancePriority;
    @TableField(exist=false)
    private Priority processInstancePriority;
    @TableField(exist=false)
    private String dependentResult;
    private int workerGroupId;

    public void init(String host, Date startTime, String executePath) {
        this.host = host;
        this.startTime = startTime;
        this.executePath = executePath;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public ProcessDefinition getProcessDefine() {
        return this.processDefine;
    }

    public void setProcessDefine(ProcessDefinition processDefine) {
        this.processDefine = processDefine;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public int getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(int processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getTaskJson() {
        return this.taskJson;
    }

    public void setTaskJson(String taskJson) {
        this.taskJson = taskJson;
    }

    public ExecutionStatus getState() {
        return this.state;
    }

    public void setState(ExecutionStatus state) {
        this.state = state;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getExecutePath() {
        return this.executePath;
    }

    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public Flag getAlertFlag() {
        return this.alertFlag;
    }

    public void setAlertFlag(Flag alertFlag) {
        this.alertFlag = alertFlag;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Boolean isTaskSuccess() {
        return this.state == ExecutionStatus.SUCCESS;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getAppLink() {
        return this.appLink;
    }

    public void setAppLink(String appLink) {
        this.appLink = appLink;
    }

    public Boolean isSubProcess() {
        return TaskType.SUB_PROCESS.toString().equals(this.taskType.toUpperCase());
    }

    public String getDependency() {
        if (this.dependency != null) {
            return this.dependency;
        }
        TaskNode taskNode = (TaskNode)JSONUtils.parseObject((String)this.taskJson, TaskNode.class);
        return taskNode.getDependence();
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public void setProcessInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Boolean isTaskComplete() {
        return this.getState().typeIsPause() || this.getState().typeIsSuccess() || this.getState().typeIsCancel() || this.getState().typeIsFailure() && !this.taskCanRetry();
    }

    public boolean taskCanRetry() {
        if (this.isSubProcess().booleanValue()) {
            return false;
        }
        if (this.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
            return true;
        }
        return this.getState().typeIsFailure() && this.getRetryTimes() < this.getMaxRetryTimes();
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public Priority getTaskInstancePriority() {
        return this.taskInstancePriority;
    }

    public void setTaskInstancePriority(Priority taskInstancePriority) {
        this.taskInstancePriority = taskInstancePriority;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public int getWorkerGroupId() {
        return this.workerGroupId;
    }

    public void setWorkerGroupId(int workerGroupId) {
        this.workerGroupId = workerGroupId;
    }

    public String toString() {
        return "TaskInstance{id=" + this.id + ", name='" + this.name + '\'' + ", taskType='" + this.taskType + '\'' + ", processDefinitionId=" + this.processDefinitionId + ", processInstanceId=" + this.processInstanceId + ", processInstanceName='" + this.processInstanceName + '\'' + ", taskJson='" + this.taskJson + '\'' + ", state=" + this.state + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", host='" + this.host + '\'' + ", executePath='" + this.executePath + '\'' + ", logPath='" + this.logPath + '\'' + ", retryTimes=" + this.retryTimes + ", alertFlag=" + this.alertFlag + ", flag=" + this.flag + ", processInstance=" + this.processInstance + ", processDefine=" + this.processDefine + ", pid=" + this.pid + ", appLink='" + this.appLink + '\'' + ", flag=" + this.flag + ", dependency=" + this.dependency + ", duration=" + this.duration + ", maxRetryTimes=" + this.maxRetryTimes + ", retryInterval=" + this.retryInterval + ", taskInstancePriority=" + this.taskInstancePriority + ", processInstancePriority=" + this.processInstancePriority + ", workGroupId=" + this.workerGroupId + '}';
    }

    public String getDependentResult() {
        return this.dependentResult;
    }

    public void setDependentResult(String dependentResult) {
        this.dependentResult = dependentResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInstance)) {
            return false;
        }
        TaskInstance other = (TaskInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        if (this.getProcessDefinitionId() != other.getProcessDefinitionId()) {
            return false;
        }
        if (this.getProcessInstanceId() != other.getProcessInstanceId()) {
            return false;
        }
        String this$processInstanceName = this.getProcessInstanceName();
        String other$processInstanceName = other.getProcessInstanceName();
        if (this$processInstanceName == null ? other$processInstanceName != null : !this$processInstanceName.equals(other$processInstanceName)) {
            return false;
        }
        String this$taskJson = this.getTaskJson();
        String other$taskJson = other.getTaskJson();
        if (this$taskJson == null ? other$taskJson != null : !this$taskJson.equals(other$taskJson)) {
            return false;
        }
        ExecutionStatus this$state = this.getState();
        ExecutionStatus other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Date this$submitTime = this.getSubmitTime();
        Date other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$executePath = this.getExecutePath();
        String other$executePath = other.getExecutePath();
        if (this$executePath == null ? other$executePath != null : !this$executePath.equals(other$executePath)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        if (this.getRetryTimes() != other.getRetryTimes()) {
            return false;
        }
        Flag this$alertFlag = this.getAlertFlag();
        Flag other$alertFlag = other.getAlertFlag();
        if (this$alertFlag == null ? other$alertFlag != null : !this$alertFlag.equals(other$alertFlag)) {
            return false;
        }
        ProcessInstance this$processInstance = this.getProcessInstance();
        ProcessInstance other$processInstance = other.getProcessInstance();
        if (this$processInstance == null ? other$processInstance != null : !((Object)this$processInstance).equals(other$processInstance)) {
            return false;
        }
        ProcessDefinition this$processDefine = this.getProcessDefine();
        ProcessDefinition other$processDefine = other.getProcessDefine();
        if (this$processDefine == null ? other$processDefine != null : !((Object)this$processDefine).equals(other$processDefine)) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        String this$appLink = this.getAppLink();
        String other$appLink = other.getAppLink();
        if (this$appLink == null ? other$appLink != null : !this$appLink.equals(other$appLink)) {
            return false;
        }
        Flag this$flag = this.getFlag();
        Flag other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !this$flag.equals(other$flag)) {
            return false;
        }
        String this$dependency = this.getDependency();
        String other$dependency = other.getDependency();
        if (this$dependency == null ? other$dependency != null : !this$dependency.equals(other$dependency)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        if (this.getMaxRetryTimes() != other.getMaxRetryTimes()) {
            return false;
        }
        if (this.getRetryInterval() != other.getRetryInterval()) {
            return false;
        }
        Priority this$taskInstancePriority = this.getTaskInstancePriority();
        Priority other$taskInstancePriority = other.getTaskInstancePriority();
        if (this$taskInstancePriority == null ? other$taskInstancePriority != null : !this$taskInstancePriority.equals(other$taskInstancePriority)) {
            return false;
        }
        Priority this$processInstancePriority = this.getProcessInstancePriority();
        Priority other$processInstancePriority = other.getProcessInstancePriority();
        if (this$processInstancePriority == null ? other$processInstancePriority != null : !this$processInstancePriority.equals(other$processInstancePriority)) {
            return false;
        }
        String this$dependentResult = this.getDependentResult();
        String other$dependentResult = other.getDependentResult();
        if (this$dependentResult == null ? other$dependentResult != null : !this$dependentResult.equals(other$dependentResult)) {
            return false;
        }
        return this.getWorkerGroupId() == other.getWorkerGroupId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        result = result * 59 + this.getProcessDefinitionId();
        result = result * 59 + this.getProcessInstanceId();
        String $processInstanceName = this.getProcessInstanceName();
        result = result * 59 + ($processInstanceName == null ? 43 : $processInstanceName.hashCode());
        String $taskJson = this.getTaskJson();
        result = result * 59 + ($taskJson == null ? 43 : $taskJson.hashCode());
        ExecutionStatus $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Date $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $executePath = this.getExecutePath();
        result = result * 59 + ($executePath == null ? 43 : $executePath.hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        result = result * 59 + this.getRetryTimes();
        Flag $alertFlag = this.getAlertFlag();
        result = result * 59 + ($alertFlag == null ? 43 : $alertFlag.hashCode());
        ProcessInstance $processInstance = this.getProcessInstance();
        result = result * 59 + ($processInstance == null ? 43 : ((Object)$processInstance).hashCode());
        ProcessDefinition $processDefine = this.getProcessDefine();
        result = result * 59 + ($processDefine == null ? 43 : ((Object)$processDefine).hashCode());
        result = result * 59 + this.getPid();
        String $appLink = this.getAppLink();
        result = result * 59 + ($appLink == null ? 43 : $appLink.hashCode());
        Flag $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : $flag.hashCode());
        String $dependency = this.getDependency();
        result = result * 59 + ($dependency == null ? 43 : $dependency.hashCode());
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        result = result * 59 + this.getMaxRetryTimes();
        result = result * 59 + this.getRetryInterval();
        Priority $taskInstancePriority = this.getTaskInstancePriority();
        result = result * 59 + ($taskInstancePriority == null ? 43 : $taskInstancePriority.hashCode());
        Priority $processInstancePriority = this.getProcessInstancePriority();
        result = result * 59 + ($processInstancePriority == null ? 43 : $processInstancePriority.hashCode());
        String $dependentResult = this.getDependentResult();
        result = result * 59 + ($dependentResult == null ? 43 : $dependentResult.hashCode());
        result = result * 59 + this.getWorkerGroupId();
        return result;
    }
}

