/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.util.List;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.SchemaUtils;
import org.apache.dolphinscheduler.dao.upgrade.MysqlUpgradeDao;
import org.apache.dolphinscheduler.dao.upgrade.PostgresqlUpgradeDao;
import org.apache.dolphinscheduler.dao.upgrade.UpgradeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerManager {
    private static final Logger logger = LoggerFactory.getLogger(DolphinSchedulerManager.class);
    UpgradeDao upgradeDao;

    private void initUpgradeDao() {
        DbType dbType = UpgradeDao.getDbType();
        if (dbType != null) {
            switch (dbType) {
                case MYSQL: {
                    this.upgradeDao = MysqlUpgradeDao.getInstance();
                    break;
                }
                case POSTGRESQL: {
                    this.upgradeDao = PostgresqlUpgradeDao.getInstance();
                    break;
                }
                default: {
                    logger.error("not support sql type: {},can't upgrade", (Object)dbType);
                    throw new IllegalArgumentException("not support sql type,can't upgrade");
                }
            }
        }
    }

    public DolphinSchedulerManager() {
        this.initUpgradeDao();
    }

    public void initDolphinScheduler() {
        if (this.upgradeDao.isExistsTable("t_escheduler_version") || this.upgradeDao.isExistsTable("t_ds_version") || this.upgradeDao.isExistsTable("t_escheduler_queue")) {
            logger.info("The database has been initialized. Skip the initialization step");
            return;
        }
        this.initDolphinSchedulerSchema();
    }

    public void initDolphinSchedulerSchema() {
        logger.info("Start initializing the DolphinScheduler manager table structure");
        this.upgradeDao.initSchema();
    }

    public void upgradeDolphinScheduler() throws Exception {
        List schemaList = SchemaUtils.getAllSchemaList();
        if (schemaList == null || schemaList.size() == 0) {
            logger.info("There is no schema to upgrade!");
        } else {
            String version = "";
            if (this.upgradeDao.isExistsTable("t_escheduler_version")) {
                version = this.upgradeDao.getCurrentVersion("t_escheduler_version");
            } else if (this.upgradeDao.isExistsTable("t_ds_version")) {
                version = this.upgradeDao.getCurrentVersion("t_ds_version");
            } else if (this.upgradeDao.isExistsColumn("t_escheduler_queue", "create_time")) {
                version = "1.0.1";
            } else if (this.upgradeDao.isExistsTable("t_escheduler_queue")) {
                version = "1.0.0";
            } else {
                logger.error("Unable to determine current software version, so cannot upgrade");
                throw new RuntimeException("Unable to determine current software version, so cannot upgrade");
            }
            String schemaVersion = "";
            for (String schemaDir : schemaList) {
                schemaVersion = schemaDir.split("_")[0];
                if (!SchemaUtils.isAGreatVersion((String)schemaVersion, (String)version)) continue;
                logger.info("upgrade DolphinScheduler metadata version from " + version + " to " + schemaVersion);
                logger.info("Begin upgrading DolphinScheduler's table structure");
                this.upgradeDao.upgradeDolphinScheduler(schemaDir);
                version = schemaVersion;
            }
        }
        this.upgradeDao.updateVersion(SchemaUtils.getSoftVersion());
    }
}

