/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.MonitorDBDao;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.BaseDBPerformance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgrePerformance
extends BaseDBPerformance {
    private static Logger logger = LoggerFactory.getLogger(MonitorDBDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorRecord getMonitorRecord(Connection conn) {
        MonitorRecord monitorRecord = new MonitorRecord();
        monitorRecord.setDate(new Date());
        monitorRecord.setState(Flag.YES);
        monitorRecord.setDbType(DbType.POSTGRESQL);
        Statement pstmt = null;
        try {
            ResultSet rs3;
            ResultSet rs2;
            pstmt = conn.createStatement();
            ResultSet rs1 = pstmt.executeQuery("select count(*) from pg_stat_activity;");
            if (rs1.next()) {
                monitorRecord.setThreadsConnections(rs1.getInt("count"));
            }
            if ((rs2 = pstmt.executeQuery("show max_connections")).next()) {
                monitorRecord.setMaxConnections(rs2.getInt("max_connections"));
            }
            if ((rs3 = pstmt.executeQuery("select count(*) from pg_stat_activity pg where pg.state = 'active';")).next()) {
                monitorRecord.setThreadsRunningConnections(rs3.getInt("count"));
            }
        }
        catch (Exception e) {
            monitorRecord.setState(Flag.NO);
            logger.error("SQLException " + e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException ", (Throwable)e);
            }
        }
        return monitorRecord;
    }
}

