/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.TaskRecordStatus;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.TaskRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRecordDao {
    private static Logger logger = LoggerFactory.getLogger((String)TaskRecordDao.class.getName());
    private static Configuration conf;

    public static boolean getTaskRecordFlag() {
        return conf.getBoolean("task.record.flag");
    }

    private static Connection getConn() {
        if (!TaskRecordDao.getTaskRecordFlag()) {
            return null;
        }
        String driver = "com.mysql.jdbc.Driver";
        String url = conf.getString("task.record.datasource.url");
        String username = conf.getString("task.record.datasource.username");
        String password = conf.getString("task.record.datasource.password");
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("Exception ", (Throwable)e);
        }
        return conn;
    }

    private static String getWhereString(Map<String, String> filterMap) {
        String end;
        String start;
        String sourceTable;
        String state;
        String taskDate;
        if (filterMap.size() == 0) {
            return "";
        }
        String result = " where 1=1 ";
        String taskName = filterMap.get("taskName");
        if (taskName != null && StringUtils.isNotEmpty((CharSequence)taskName.toString())) {
            result = result + " and PROC_NAME like concat('%', '" + taskName.toString() + "', '%') ";
        }
        if ((taskDate = filterMap.get("taskDate")) != null && StringUtils.isNotEmpty((CharSequence)taskDate.toString())) {
            result = result + " and PROC_DATE='" + taskDate.toString() + "'";
        }
        if ((state = filterMap.get("state")) != null && StringUtils.isNotEmpty((CharSequence)state.toString())) {
            result = result + " and NOTE='" + state.toString() + "'";
        }
        if ((sourceTable = filterMap.get("sourceTable")) != null && StringUtils.isNotEmpty((CharSequence)sourceTable.toString())) {
            result = result + " and SOURCE_TAB like concat('%', '" + sourceTable.toString() + "', '%')";
        }
        String targetTable = filterMap.get("targetTable");
        if (sourceTable != null && StringUtils.isNotEmpty((CharSequence)targetTable.toString())) {
            result = result + " and TARGET_TAB like concat('%', '" + targetTable.toString() + "', '%') ";
        }
        if ((start = filterMap.get("startTime")) != null && StringUtils.isNotEmpty((CharSequence)start.toString())) {
            result = result + " and STARTDATE>='" + start.toString() + "'";
        }
        if ((end = filterMap.get("endTime")) != null && StringUtils.isNotEmpty((CharSequence)end.toString())) {
            result = result + " and ENDDATE>='" + end.toString() + "'";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countTaskRecord(Map<String, String> filterMap, String table) {
        int count = 0;
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = TaskRecordDao.getConn();
            if (conn == null) {
                int n = count;
                return n;
            }
            String sql = String.format("select count(1) as count from %s", table);
            pstmt = conn.prepareStatement(sql = sql + TaskRecordDao.getWhereString(filterMap));
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error("Exception ", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("Exception ", (Throwable)e);
            }
        }
        return count;
    }

    public static List<TaskRecord> queryAllTaskRecord(Map<String, String> filterMap, String table) {
        String sql = String.format("select * from  %s", table);
        sql = sql + TaskRecordDao.getWhereString(filterMap);
        int offset = Integer.parseInt(filterMap.get("offset"));
        int pageSize = Integer.parseInt(filterMap.get("pageSize"));
        sql = sql + String.format(" order by STARTDATE desc limit %d,%d", offset, pageSize);
        ArrayList<TaskRecord> recordList = new ArrayList();
        try {
            recordList = TaskRecordDao.getQueryResult(sql);
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
        }
        return recordList;
    }

    private static TaskRecord convertToTaskRecord(ResultSet resultSet) throws SQLException {
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(resultSet.getInt("ID"));
        taskRecord.setProcId(resultSet.getInt("PROC_ID"));
        taskRecord.setProcName(resultSet.getString("PROC_NAME"));
        taskRecord.setProcDate(resultSet.getString("PROC_DATE"));
        taskRecord.setStartTime(DateUtils.stringToDate((String)resultSet.getString("STARTDATE")));
        taskRecord.setEndTime(DateUtils.stringToDate((String)resultSet.getString("ENDDATE")));
        taskRecord.setResult(resultSet.getString("RESULT"));
        taskRecord.setDuration(resultSet.getInt("DURATION"));
        taskRecord.setNote(resultSet.getString("NOTE"));
        taskRecord.setSchema(resultSet.getString("SCHEMA"));
        taskRecord.setJobId(resultSet.getString("JOB_ID"));
        taskRecord.setSourceTab(resultSet.getString("SOURCE_TAB"));
        taskRecord.setSourceRowCount(resultSet.getLong("SOURCE_ROW_COUNT"));
        taskRecord.setTargetTab(resultSet.getString("TARGET_TAB"));
        taskRecord.setTargetRowCount(resultSet.getLong("TARGET_ROW_COUNT"));
        taskRecord.setErrorCode(resultSet.getString("ERROR_CODE"));
        return taskRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TaskRecord> getQueryResult(String selectSql) {
        ArrayList<TaskRecord> recordList = new ArrayList<TaskRecord>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = TaskRecordDao.getConn();
            if (conn == null) {
                ArrayList<TaskRecord> arrayList = recordList;
                return arrayList;
            }
            pstmt = conn.prepareStatement(selectSql);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                TaskRecord taskRecord = TaskRecordDao.convertToTaskRecord(rs);
                recordList.add(taskRecord);
            }
        }
        catch (SQLException e) {
            logger.error("Exception ", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("Exception ", (Throwable)e);
            }
        }
        return recordList;
    }

    public static TaskRecordStatus getTaskRecordState(String procName, String procDate) {
        String sql = String.format("SELECT * FROM eamp_hive_log_hd WHERE PROC_NAME='%s' and PROC_DATE like '%s'", procName, procDate + "%");
        List<TaskRecord> taskRecordList = TaskRecordDao.getQueryResult(sql);
        if (CollectionUtils.isEmpty(taskRecordList)) {
            return TaskRecordStatus.EXCEPTION;
        }
        if (taskRecordList.size() > 1) {
            return TaskRecordStatus.EXCEPTION;
        }
        TaskRecord taskRecord = taskRecordList.get(0);
        if (taskRecord == null) {
            return TaskRecordStatus.EXCEPTION;
        }
        Long targetRowCount = taskRecord.getTargetRowCount();
        if (targetRowCount <= 0L) {
            return TaskRecordStatus.FAILURE;
        }
        return TaskRecordStatus.SUCCESS;
    }

    static {
        try {
            conf = new PropertiesConfiguration("application.properties");
        }
        catch (ConfigurationException e) {
            logger.error("load configuration exception", (Throwable)e);
            System.exit(1);
        }
    }
}

