/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;

@TableName(value="t_ds_command")
public class Command {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    @TableField(value="command_type")
    private CommandType commandType;
    @TableField(value="process_definition_id")
    private int processDefinitionId;
    @TableField(value="executor_id")
    private int executorId;
    @TableField(value="command_param")
    private String commandParam;
    @TableField(value="task_depend_type")
    private TaskDependType taskDependType;
    @TableField(value="failure_strategy")
    private FailureStrategy failureStrategy;
    @TableField(value="warning_type")
    private WarningType warningType;
    @TableField(value="warning_group_id")
    private Integer warningGroupId;
    @TableField(value="schedule_time")
    private Date scheduleTime;
    @TableField(value="start_time")
    private Date startTime;
    @TableField(value="process_instance_priority")
    private Priority processInstancePriority;
    @TableField(value="update_time")
    private Date updateTime;
    @TableField(value="worker_group_id")
    private int workerGroupId;

    public Command() {
        this.taskDependType = TaskDependType.TASK_POST;
        this.failureStrategy = FailureStrategy.CONTINUE;
        this.startTime = new Date();
        this.updateTime = new Date();
    }

    public Command(CommandType commandType, TaskDependType taskDependType, FailureStrategy failureStrategy, int executorId, int processDefinitionId, String commandParam, WarningType warningType, int warningGroupId, Date scheduleTime, Priority processInstancePriority) {
        this.commandType = commandType;
        this.executorId = executorId;
        this.processDefinitionId = processDefinitionId;
        this.commandParam = commandParam;
        this.warningType = warningType;
        this.warningGroupId = warningGroupId;
        this.scheduleTime = scheduleTime;
        this.taskDependType = taskDependType;
        this.failureStrategy = failureStrategy;
        this.startTime = new Date();
        this.updateTime = new Date();
        this.processInstancePriority = processInstancePriority;
    }

    public TaskDependType getTaskDependType() {
        return this.taskDependType;
    }

    public void setTaskDependType(TaskDependType taskDependType) {
        this.taskDependType = taskDependType;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public int getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(int processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    public void setCommandParam(String commandParam) {
        this.commandParam = commandParam;
    }

    public String getCommandParam() {
        return this.commandParam;
    }

    public WarningType getWarningType() {
        return this.warningType;
    }

    public void setWarningType(WarningType warningType) {
        this.warningType = warningType;
    }

    public Integer getWarningGroupId() {
        return this.warningGroupId;
    }

    public void setWarningGroupId(Integer warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public int getWorkerGroupId() {
        return this.workerGroupId;
    }

    public void setWorkerGroupId(int workerGroupId) {
        this.workerGroupId = workerGroupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        if (this.id != command.id) {
            return false;
        }
        if (this.processDefinitionId != command.processDefinitionId) {
            return false;
        }
        if (this.executorId != command.executorId) {
            return false;
        }
        if (this.workerGroupId != command.workerGroupId) {
            return false;
        }
        if (this.commandType != command.commandType) {
            return false;
        }
        if (this.commandParam != null ? !this.commandParam.equals(command.commandParam) : command.commandParam != null) {
            return false;
        }
        if (this.taskDependType != command.taskDependType) {
            return false;
        }
        if (this.failureStrategy != command.failureStrategy) {
            return false;
        }
        if (this.warningType != command.warningType) {
            return false;
        }
        if (this.warningGroupId != null ? !this.warningGroupId.equals(command.warningGroupId) : command.warningGroupId != null) {
            return false;
        }
        if (this.scheduleTime != null ? !this.scheduleTime.equals(command.scheduleTime) : command.scheduleTime != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(command.startTime) : command.startTime != null) {
            return false;
        }
        if (this.processInstancePriority != command.processInstancePriority) {
            return false;
        }
        return !(this.updateTime == null ? command.updateTime != null : !this.updateTime.equals(command.updateTime));
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.commandType != null ? this.commandType.hashCode() : 0);
        result = 31 * result + this.processDefinitionId;
        result = 31 * result + this.executorId;
        result = 31 * result + (this.commandParam != null ? this.commandParam.hashCode() : 0);
        result = 31 * result + (this.taskDependType != null ? this.taskDependType.hashCode() : 0);
        result = 31 * result + (this.failureStrategy != null ? this.failureStrategy.hashCode() : 0);
        result = 31 * result + (this.warningType != null ? this.warningType.hashCode() : 0);
        result = 31 * result + (this.warningGroupId != null ? this.warningGroupId.hashCode() : 0);
        result = 31 * result + (this.scheduleTime != null ? this.scheduleTime.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.processInstancePriority != null ? this.processInstancePriority.hashCode() : 0);
        result = 31 * result + (this.updateTime != null ? this.updateTime.hashCode() : 0);
        result = 31 * result + this.workerGroupId;
        return result;
    }

    public String toString() {
        return "Command{id=" + this.id + ", commandType=" + this.commandType + ", processDefinitionId=" + this.processDefinitionId + ", executorId=" + this.executorId + ", commandParam='" + this.commandParam + '\'' + ", taskDependType=" + this.taskDependType + ", failureStrategy=" + this.failureStrategy + ", warningType=" + this.warningType + ", warningGroupId=" + this.warningGroupId + ", scheduleTime=" + this.scheduleTime + ", startTime=" + this.startTime + ", processInstancePriority=" + this.processInstancePriority + ", updateTime=" + this.updateTime + ", workerGroupId=" + this.workerGroupId + '}';
    }
}

