/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;

@TableName(value="t_ds_process_instance")
public class ProcessInstance {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private int processDefinitionId;
    private ExecutionStatus state;
    private Flag recovery;
    private Date startTime;
    private Date endTime;
    private int runTimes;
    private String name;
    private String host;
    @TableField(exist=false)
    private ProcessDefinition processDefinition;
    private CommandType commandType;
    private String commandParam;
    private TaskDependType taskDependType;
    private int maxTryTimes;
    private FailureStrategy failureStrategy;
    private WarningType warningType;
    private Integer warningGroupId;
    private Date scheduleTime;
    private Date commandStartTime;
    private String globalParams;
    private String processInstanceJson;
    private int executorId;
    @TableField(exist=false)
    private String tenantCode;
    @TableField(exist=false)
    private String queue;
    private Flag isSubProcess;
    private String locations;
    private String connects;
    private String historyCmd;
    private String dependenceScheduleTimes;
    @TableField(exist=false)
    private Long duration;
    private Priority processInstancePriority;
    private int workerGroupId;
    private int timeout;
    private int tenantId;
    @TableField(exist=false)
    private String workerGroupName;
    @TableField(exist=false)
    private String receivers;
    @TableField(exist=false)
    private String receiversCc;

    public ProcessInstance() {
    }

    public ProcessInstance(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        this.name = processDefinition.getName() + "-" + processDefinition.getVersion() + "-" + System.currentTimeMillis();
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(int processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ExecutionStatus getState() {
        return this.state;
    }

    public void setState(ExecutionStatus state) {
        this.state = state;
    }

    public Flag getRecovery() {
        return this.recovery;
    }

    public void setRecovery(Flag recovery) {
        this.recovery = recovery;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getRunTimes() {
        return this.runTimes;
    }

    public void setRunTimes(int runTimes) {
        this.runTimes = runTimes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public String getCommandParam() {
        return this.commandParam;
    }

    public void setCommandParam(String commandParam) {
        this.commandParam = commandParam;
    }

    public TaskDependType getTaskDependType() {
        return this.taskDependType;
    }

    public void setTaskDependType(TaskDependType taskDependType) {
        this.taskDependType = taskDependType;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public void setMaxTryTimes(int maxTryTimes) {
        this.maxTryTimes = maxTryTimes;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    public boolean IsProcessInstanceStop() {
        return this.state.typeIsFinished();
    }

    public WarningType getWarningType() {
        return this.warningType;
    }

    public void setWarningType(WarningType warningType) {
        this.warningType = warningType;
    }

    public Integer getWarningGroupId() {
        return this.warningGroupId;
    }

    public void setWarningGroupId(Integer warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getCommandStartTime() {
        return this.commandStartTime;
    }

    public void setCommandStartTime(Date commandStartTime) {
        this.commandStartTime = commandStartTime;
    }

    public String getGlobalParams() {
        return this.globalParams;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    public String getProcessInstanceJson() {
        return this.processInstanceJson;
    }

    public void setProcessInstanceJson(String processInstanceJson) {
        this.processInstanceJson = processInstanceJson;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    public Flag getIsSubProcess() {
        return this.isSubProcess;
    }

    public void setIsSubProcess(Flag isSubProcess) {
        this.isSubProcess = isSubProcess;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public String getConnects() {
        return this.connects;
    }

    public void setConnects(String connects) {
        this.connects = connects;
    }

    public String getHistoryCmd() {
        return this.historyCmd;
    }

    public void setHistoryCmd(String historyCmd) {
        this.historyCmd = historyCmd;
    }

    public void addHistoryCmd(CommandType cmd) {
        this.historyCmd = StringUtils.isNotEmpty((CharSequence)this.historyCmd) ? String.format("%s,%s", this.historyCmd, cmd.toString()) : cmd.toString();
    }

    public Boolean isComplementData() {
        if (!StringUtils.isNotEmpty((CharSequence)this.historyCmd)) {
            return false;
        }
        return this.historyCmd.startsWith(CommandType.COMPLEMENT_DATA.toString());
    }

    public CommandType getCmdTypeIfComplement() {
        if (this.isComplementData().booleanValue()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return this.commandType;
    }

    public String getDependenceScheduleTimes() {
        return this.dependenceScheduleTimes;
    }

    public void setDependenceScheduleTimes(String dependenceScheduleTimes) {
        this.dependenceScheduleTimes = dependenceScheduleTimes;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public int getWorkerGroupId() {
        return this.workerGroupId;
    }

    public void setWorkerGroupId(int workerGroupId) {
        this.workerGroupId = workerGroupId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String getWorkerGroupName() {
        return this.workerGroupName;
    }

    public void setWorkerGroupName(String workerGroupName) {
        this.workerGroupName = workerGroupName;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public String getReceiversCc() {
        return this.receiversCc;
    }

    public void setReceiversCc(String receiversCc) {
        this.receiversCc = receiversCc;
    }

    public String toString() {
        return "ProcessInstance{id=" + this.id + ", processDefinitionId=" + this.processDefinitionId + ", state=" + this.state + ", recovery=" + this.recovery + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", runTimes=" + this.runTimes + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", processDefinition=" + this.processDefinition + ", commandType=" + this.commandType + ", commandParam='" + this.commandParam + '\'' + ", taskDependType=" + this.taskDependType + ", maxTryTimes=" + this.maxTryTimes + ", failureStrategy=" + this.failureStrategy + ", warningType=" + this.warningType + ", warningGroupId=" + this.warningGroupId + ", scheduleTime=" + this.scheduleTime + ", commandStartTime=" + this.commandStartTime + ", globalParams='" + this.globalParams + '\'' + ", processInstanceJson='" + this.processInstanceJson + '\'' + ", executorId=" + this.executorId + ", tenantCode='" + this.tenantCode + '\'' + ", queue='" + this.queue + '\'' + ", isSubProcess=" + this.isSubProcess + ", locations='" + this.locations + '\'' + ", connects='" + this.connects + '\'' + ", historyCmd='" + this.historyCmd + '\'' + ", dependenceScheduleTimes='" + this.dependenceScheduleTimes + '\'' + ", duration=" + this.duration + ", processInstancePriority=" + this.processInstancePriority + ", workerGroupId=" + this.workerGroupId + ", timeout=" + this.timeout + ", tenantId=" + this.tenantId + ", workerGroupName='" + this.workerGroupName + '\'' + ", receivers='" + this.receivers + '\'' + ", receiversCc='" + this.receiversCc + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessInstance)) {
            return false;
        }
        ProcessInstance other = (ProcessInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getProcessDefinitionId() != other.getProcessDefinitionId()) {
            return false;
        }
        ExecutionStatus this$state = this.getState();
        ExecutionStatus other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Flag this$recovery = this.getRecovery();
        Flag other$recovery = other.getRecovery();
        if (this$recovery == null ? other$recovery != null : !this$recovery.equals(other$recovery)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        if (this.getRunTimes() != other.getRunTimes()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        ProcessDefinition this$processDefinition = this.getProcessDefinition();
        ProcessDefinition other$processDefinition = other.getProcessDefinition();
        if (this$processDefinition == null ? other$processDefinition != null : !((Object)this$processDefinition).equals(other$processDefinition)) {
            return false;
        }
        CommandType this$commandType = this.getCommandType();
        CommandType other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        String this$commandParam = this.getCommandParam();
        String other$commandParam = other.getCommandParam();
        if (this$commandParam == null ? other$commandParam != null : !this$commandParam.equals(other$commandParam)) {
            return false;
        }
        TaskDependType this$taskDependType = this.getTaskDependType();
        TaskDependType other$taskDependType = other.getTaskDependType();
        if (this$taskDependType == null ? other$taskDependType != null : !this$taskDependType.equals(other$taskDependType)) {
            return false;
        }
        if (this.getMaxTryTimes() != other.getMaxTryTimes()) {
            return false;
        }
        FailureStrategy this$failureStrategy = this.getFailureStrategy();
        FailureStrategy other$failureStrategy = other.getFailureStrategy();
        if (this$failureStrategy == null ? other$failureStrategy != null : !this$failureStrategy.equals(other$failureStrategy)) {
            return false;
        }
        WarningType this$warningType = this.getWarningType();
        WarningType other$warningType = other.getWarningType();
        if (this$warningType == null ? other$warningType != null : !this$warningType.equals(other$warningType)) {
            return false;
        }
        Integer this$warningGroupId = this.getWarningGroupId();
        Integer other$warningGroupId = other.getWarningGroupId();
        if (this$warningGroupId == null ? other$warningGroupId != null : !((Object)this$warningGroupId).equals(other$warningGroupId)) {
            return false;
        }
        Date this$scheduleTime = this.getScheduleTime();
        Date other$scheduleTime = other.getScheduleTime();
        if (this$scheduleTime == null ? other$scheduleTime != null : !((Object)this$scheduleTime).equals(other$scheduleTime)) {
            return false;
        }
        Date this$commandStartTime = this.getCommandStartTime();
        Date other$commandStartTime = other.getCommandStartTime();
        if (this$commandStartTime == null ? other$commandStartTime != null : !((Object)this$commandStartTime).equals(other$commandStartTime)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        String this$processInstanceJson = this.getProcessInstanceJson();
        String other$processInstanceJson = other.getProcessInstanceJson();
        if (this$processInstanceJson == null ? other$processInstanceJson != null : !this$processInstanceJson.equals(other$processInstanceJson)) {
            return false;
        }
        if (this.getExecutorId() != other.getExecutorId()) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$queue = this.getQueue();
        String other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
            return false;
        }
        Flag this$isSubProcess = this.getIsSubProcess();
        Flag other$isSubProcess = other.getIsSubProcess();
        if (this$isSubProcess == null ? other$isSubProcess != null : !this$isSubProcess.equals(other$isSubProcess)) {
            return false;
        }
        String this$locations = this.getLocations();
        String other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !this$locations.equals(other$locations)) {
            return false;
        }
        String this$connects = this.getConnects();
        String other$connects = other.getConnects();
        if (this$connects == null ? other$connects != null : !this$connects.equals(other$connects)) {
            return false;
        }
        String this$historyCmd = this.getHistoryCmd();
        String other$historyCmd = other.getHistoryCmd();
        if (this$historyCmd == null ? other$historyCmd != null : !this$historyCmd.equals(other$historyCmd)) {
            return false;
        }
        String this$dependenceScheduleTimes = this.getDependenceScheduleTimes();
        String other$dependenceScheduleTimes = other.getDependenceScheduleTimes();
        if (this$dependenceScheduleTimes == null ? other$dependenceScheduleTimes != null : !this$dependenceScheduleTimes.equals(other$dependenceScheduleTimes)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Priority this$processInstancePriority = this.getProcessInstancePriority();
        Priority other$processInstancePriority = other.getProcessInstancePriority();
        if (this$processInstancePriority == null ? other$processInstancePriority != null : !this$processInstancePriority.equals(other$processInstancePriority)) {
            return false;
        }
        if (this.getWorkerGroupId() != other.getWorkerGroupId()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        String this$workerGroupName = this.getWorkerGroupName();
        String other$workerGroupName = other.getWorkerGroupName();
        if (this$workerGroupName == null ? other$workerGroupName != null : !this$workerGroupName.equals(other$workerGroupName)) {
            return false;
        }
        String this$receivers = this.getReceivers();
        String other$receivers = other.getReceivers();
        if (this$receivers == null ? other$receivers != null : !this$receivers.equals(other$receivers)) {
            return false;
        }
        String this$receiversCc = this.getReceiversCc();
        String other$receiversCc = other.getReceiversCc();
        return !(this$receiversCc == null ? other$receiversCc != null : !this$receiversCc.equals(other$receiversCc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getProcessDefinitionId();
        ExecutionStatus $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Flag $recovery = this.getRecovery();
        result = result * 59 + ($recovery == null ? 43 : $recovery.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        result = result * 59 + this.getRunTimes();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        ProcessDefinition $processDefinition = this.getProcessDefinition();
        result = result * 59 + ($processDefinition == null ? 43 : ((Object)$processDefinition).hashCode());
        CommandType $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        String $commandParam = this.getCommandParam();
        result = result * 59 + ($commandParam == null ? 43 : $commandParam.hashCode());
        TaskDependType $taskDependType = this.getTaskDependType();
        result = result * 59 + ($taskDependType == null ? 43 : $taskDependType.hashCode());
        result = result * 59 + this.getMaxTryTimes();
        FailureStrategy $failureStrategy = this.getFailureStrategy();
        result = result * 59 + ($failureStrategy == null ? 43 : $failureStrategy.hashCode());
        WarningType $warningType = this.getWarningType();
        result = result * 59 + ($warningType == null ? 43 : $warningType.hashCode());
        Integer $warningGroupId = this.getWarningGroupId();
        result = result * 59 + ($warningGroupId == null ? 43 : ((Object)$warningGroupId).hashCode());
        Date $scheduleTime = this.getScheduleTime();
        result = result * 59 + ($scheduleTime == null ? 43 : ((Object)$scheduleTime).hashCode());
        Date $commandStartTime = this.getCommandStartTime();
        result = result * 59 + ($commandStartTime == null ? 43 : ((Object)$commandStartTime).hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        String $processInstanceJson = this.getProcessInstanceJson();
        result = result * 59 + ($processInstanceJson == null ? 43 : $processInstanceJson.hashCode());
        result = result * 59 + this.getExecutorId();
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        Flag $isSubProcess = this.getIsSubProcess();
        result = result * 59 + ($isSubProcess == null ? 43 : $isSubProcess.hashCode());
        String $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : $locations.hashCode());
        String $connects = this.getConnects();
        result = result * 59 + ($connects == null ? 43 : $connects.hashCode());
        String $historyCmd = this.getHistoryCmd();
        result = result * 59 + ($historyCmd == null ? 43 : $historyCmd.hashCode());
        String $dependenceScheduleTimes = this.getDependenceScheduleTimes();
        result = result * 59 + ($dependenceScheduleTimes == null ? 43 : $dependenceScheduleTimes.hashCode());
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Priority $processInstancePriority = this.getProcessInstancePriority();
        result = result * 59 + ($processInstancePriority == null ? 43 : $processInstancePriority.hashCode());
        result = result * 59 + this.getWorkerGroupId();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getTenantId();
        String $workerGroupName = this.getWorkerGroupName();
        result = result * 59 + ($workerGroupName == null ? 43 : $workerGroupName.hashCode());
        String $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : $receivers.hashCode());
        String $receiversCc = this.getReceiversCc();
        result = result * 59 + ($receiversCc == null ? 43 : $receiversCc.hashCode());
        return result;
    }
}

