/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.permission;

import java.util.List;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;

public class PermissionCheck<T> {
    private Logger logger;
    private AuthorizationType authorizationType;
    private ProcessDao processDao;
    private T[] needChecks;
    private int userId;

    public PermissionCheck(AuthorizationType authorizationType, ProcessDao processDao) {
        this.authorizationType = authorizationType;
        this.processDao = processDao;
    }

    public PermissionCheck(AuthorizationType authorizationType, ProcessDao processDao, T[] needChecks, int userId) {
        this.authorizationType = authorizationType;
        this.processDao = processDao;
        this.needChecks = needChecks;
        this.userId = userId;
    }

    public PermissionCheck(AuthorizationType authorizationType, ProcessDao processDao, T[] needChecks, int userId, Logger logger) {
        this.authorizationType = authorizationType;
        this.processDao = processDao;
        this.needChecks = needChecks;
        this.userId = userId;
        this.logger = logger;
    }

    public AuthorizationType getAuthorizationType() {
        return this.authorizationType;
    }

    public void setAuthorizationType(AuthorizationType authorizationType) {
        this.authorizationType = authorizationType;
    }

    public ProcessDao getProcessDao() {
        return this.processDao;
    }

    public void setProcessDao(ProcessDao processDao) {
        this.processDao = processDao;
    }

    public T[] getNeedChecks() {
        return this.needChecks;
    }

    public void setNeedChecks(T[] needChecks) {
        this.needChecks = needChecks;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public boolean hasPermission() {
        try {
            this.checkPermission();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void checkPermission() throws Exception {
        List<T> unauthorizedList;
        User user;
        if (this.needChecks.length > 0 && (user = this.processDao.getUserById(this.userId)).getUserType() != UserType.ADMIN_USER && CollectionUtils.isNotEmpty(unauthorizedList = this.processDao.listUnauthorized(this.userId, this.needChecks, this.authorizationType))) {
            this.logger.error("user {} didn't has permission of {}: {}", new Object[]{user.getUserName(), this.authorizationType.getDescp(), unauthorizedList.toString()});
            throw new RuntimeException(String.format("user %s didn't has permission of %s %s", user.getUserName(), this.authorizationType.getDescp(), unauthorizedList.get(0)));
        }
    }
}

