/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagHelper {
    private static final Logger logger = LoggerFactory.getLogger(DagHelper.class);

    public static List<TaskNodeRelation> generateRelationListByFlowNodes(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> nodeRelationList = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTaskList = JSONUtils.toList((String)preTasks, String.class);
            if (preTaskList == null) continue;
            for (String depNodeName : preTaskList) {
                if (null == DagHelper.findNodeByName(taskNodeList, depNodeName)) continue;
                nodeRelationList.add(new TaskNodeRelation(depNodeName, taskNode.getName()));
            }
        }
        return nodeRelationList;
    }

    public static List<TaskNode> generateFlowNodeListByStartNode(List<TaskNode> taskNodeList, List<String> startNodeNameList, List<String> recoveryNodeNameList, TaskDependType taskDependType) {
        ArrayList<TaskNode> destFlowNodeList = new ArrayList<TaskNode>();
        List<String> startNodeList = startNodeNameList;
        if (taskDependType != TaskDependType.TASK_POST && startNodeList.size() == 0) {
            logger.error("start node list is empty! cannot continue run the process ");
            return destFlowNodeList;
        }
        ArrayList<TaskNode> destTaskNodeList = new ArrayList<TaskNode>();
        List<Object> tmpTaskNodeList = new ArrayList();
        if (taskDependType == TaskDependType.TASK_POST && recoveryNodeNameList.size() > 0) {
            startNodeList = recoveryNodeNameList;
        }
        if (startNodeList == null || startNodeList.size() == 0) {
            tmpTaskNodeList = taskNodeList;
        } else {
            for (String string : startNodeList) {
                TaskNode startNode = DagHelper.findNodeByName(taskNodeList, string);
                List<Object> childNodeList = new ArrayList();
                if (TaskDependType.TASK_POST == taskDependType) {
                    childNodeList = DagHelper.getFlowNodeListPost(startNode, taskNodeList);
                } else if (TaskDependType.TASK_PRE == taskDependType) {
                    childNodeList = DagHelper.getFlowNodeListPre(startNode, recoveryNodeNameList, taskNodeList);
                } else {
                    childNodeList.add(startNode);
                }
                tmpTaskNodeList.addAll(childNodeList);
            }
        }
        for (TaskNode taskNode : tmpTaskNodeList) {
            if (null != DagHelper.findNodeByName(destTaskNodeList, taskNode.getName())) continue;
            destTaskNodeList.add(taskNode);
        }
        return destTaskNodeList;
    }

    private static List<TaskNode> getFlowNodeListPost(TaskNode startNode, List<TaskNode> taskNodeList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        for (TaskNode taskNode : taskNodeList) {
            List depList = taskNode.getDepList();
            if (depList == null || !depList.contains(startNode.getName())) continue;
            resultList.addAll(DagHelper.getFlowNodeListPost(taskNode, taskNodeList));
        }
        resultList.add(startNode);
        return resultList;
    }

    private static List<TaskNode> getFlowNodeListPre(TaskNode startNode, List<String> recoveryNodeNameList, List<TaskNode> taskNodeList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        List depList = startNode.getDepList();
        resultList.add(startNode);
        if (depList == null || depList.size() == 0) {
            return resultList;
        }
        for (String depNodeName : depList) {
            TaskNode start = DagHelper.findNodeByName(taskNodeList, depNodeName);
            if (recoveryNodeNameList.contains(depNodeName)) {
                resultList.add(start);
                continue;
            }
            resultList.addAll(DagHelper.getFlowNodeListPre(start, recoveryNodeNameList, taskNodeList));
        }
        return resultList;
    }

    public static ProcessDag generateFlowDag(String processDefinitionJson, List<String> startNodeNameList, List<String> recoveryNodeNameList, TaskDependType depNodeType) throws Exception {
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List<TaskNode> taskNodeList = processData.getTasks();
        List<TaskNode> destTaskNodeList = DagHelper.generateFlowNodeListByStartNode(taskNodeList, startNodeNameList, recoveryNodeNameList, depNodeType);
        if (destTaskNodeList.isEmpty()) {
            return null;
        }
        List<TaskNodeRelation> taskNodeRelations = DagHelper.generateRelationListByFlowNodes(destTaskNodeList);
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(destTaskNodeList);
        return processDag;
    }

    public static Map<String, TaskNode> getForbiddenTaskNodeMaps(String processDefinitionJson) {
        ConcurrentHashMap<String, TaskNode> forbidTaskNodeMap = new ConcurrentHashMap<String, TaskNode>();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List<TaskNode> taskNodeList = processData.getTasks();
        for (TaskNode node : taskNodeList) {
            if (!node.isForbidden().booleanValue()) continue;
            forbidTaskNodeMap.putIfAbsent(node.getName(), node);
        }
        return forbidTaskNodeMap;
    }

    public static TaskNode findNodeByName(List<TaskNode> nodeDetails, String nodeName) {
        for (TaskNode taskNode : nodeDetails) {
            if (!taskNode.getName().equals(nodeName)) continue;
            return taskNode;
        }
        return null;
    }

    public static Collection<String> getStartVertex(String parentNodeName, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        if (completeTaskList == null) {
            completeTaskList = new HashMap<String, TaskInstance>();
        }
        Collection startVertexs = null;
        startVertexs = StringUtils.isNotEmpty((CharSequence)parentNodeName) ? dag.getSubsequentNodes((Object)parentNodeName) : dag.getBeginNode();
        ArrayList<String> tmpStartVertexs = new ArrayList<String>();
        if (startVertexs != null) {
            tmpStartVertexs.addAll(startVertexs);
        }
        for (String start : startVertexs) {
            TaskNode startNode = (TaskNode)dag.getNode((Object)start);
            if (!startNode.isForbidden().booleanValue() && !completeTaskList.containsKey(start)) continue;
            Collection<String> postNodes = DagHelper.getStartVertex(start, dag, completeTaskList);
            for (String post : postNodes) {
                TaskNode postNode = (TaskNode)dag.getNode((Object)post);
                if (!DagHelper.taskNodeCanSubmit(postNode, dag, completeTaskList)) continue;
                tmpStartVertexs.add(post);
            }
            tmpStartVertexs.remove(start);
        }
        return tmpStartVertexs;
    }

    public static boolean taskNodeCanSubmit(TaskNode taskNode, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        List dependList = taskNode.getDepList();
        if (dependList == null) {
            return true;
        }
        for (String dependNodeName : dependList) {
            TaskNode dependNode = (TaskNode)dag.getNode((Object)dependNodeName);
            if (dependNode.isForbidden().booleanValue() || completeTaskList.containsKey(dependNodeName)) continue;
            return false;
        }
        return true;
    }

    public static DAG<String, TaskNode, TaskNodeRelation> buildDagGraph(ProcessDag processDag) {
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty((Collection)processDag.getNodes())) {
            for (TaskNode node : processDag.getNodes()) {
                dag.addNode((Object)node.getName(), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)processDag.getEdges())) {
            for (TaskNodeRelation edge : processDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }
}

