/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataSource
extends BaseDataSource {
    private final Logger logger = LoggerFactory.getLogger(MySQLDataSource.class);
    private final String sensitiveParam = "autoDeserialize=true";
    private final char symbol = (char)38;

    @Override
    public String driverClassSelector() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.MYSQL;
    }

    @Override
    protected String filterOther(String other) {
        if (StringUtils.isBlank((String)other)) {
            return "";
        }
        if (other.contains("autoDeserialize=true")) {
            int index = other.indexOf("autoDeserialize=true");
            String tmp = "autoDeserialize=true";
            if (index == 0 || other.charAt(index + 1) == '&') {
                tmp = tmp + '&';
            } else if (other.charAt(index - 1) == '&') {
                tmp = '&' + tmp;
            }
            this.logger.warn("sensitive param : {} in otherParams field is filtered", (Object)tmp);
            other = other.replace(tmp, "");
        }
        this.logger.debug("other : {}", (Object)other);
        return other;
    }

    @Override
    public String getUser() {
        if (this.user.contains("autoDeserialize=true")) {
            this.logger.warn("sensitive param : {} in username field is filtered", (Object)"autoDeserialize=true");
            this.user = this.user.replace("autoDeserialize=true", "");
        }
        this.logger.debug("username : {}", (Object)this.user);
        return this.user;
    }

    @Override
    public String getPassword() {
        if (this.password.contains("autoDeserialize=true")) {
            this.logger.warn("sensitive param : {} in password field is filtered", (Object)"autoDeserialize=true");
            this.password = this.password.replace("autoDeserialize=true", "");
        }
        return this.password;
    }
}

