/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;

@TableName(value="t_ds_task_instance")
public class TaskInstance
implements Serializable {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private String name;
    private String taskType;
    private int processDefinitionId;
    private int processInstanceId;
    @TableField(exist=false)
    private String processInstanceName;
    private String taskJson;
    private ExecutionStatus state;
    private Date submitTime;
    private Date startTime;
    private Date endTime;
    private String host;
    private String executePath;
    private String logPath;
    private int retryTimes;
    private Flag alertFlag;
    @TableField(exist=false)
    private ProcessInstance processInstance;
    @TableField(exist=false)
    private ProcessDefinition processDefine;
    private int pid;
    private String appLink;
    private Flag flag;
    @TableField(exist=false)
    private String dependency;
    @TableField(exist=false)
    private Long duration;
    private int maxRetryTimes;
    private int retryInterval;
    private Priority taskInstancePriority;
    @TableField(exist=false)
    private Priority processInstancePriority;
    @TableField(exist=false)
    private String dependentResult;
    private String workerGroup;
    private int executorId;
    @TableField(exist=false)
    private String executorName;
    @TableField(exist=false)
    private Map<String, String> resources;

    public void init(String host, Date startTime, String executePath) {
        this.host = host;
        this.startTime = startTime;
        this.executePath = executePath;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public ProcessDefinition getProcessDefine() {
        return this.processDefine;
    }

    public void setProcessDefine(ProcessDefinition processDefine) {
        this.processDefine = processDefine;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public int getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(int processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getTaskJson() {
        return this.taskJson;
    }

    public void setTaskJson(String taskJson) {
        this.taskJson = taskJson;
    }

    public ExecutionStatus getState() {
        return this.state;
    }

    public void setState(ExecutionStatus state) {
        this.state = state;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getExecutePath() {
        return this.executePath;
    }

    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public Flag getAlertFlag() {
        return this.alertFlag;
    }

    public void setAlertFlag(Flag alertFlag) {
        this.alertFlag = alertFlag;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Boolean isTaskSuccess() {
        return this.state == ExecutionStatus.SUCCESS;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getAppLink() {
        return this.appLink;
    }

    public void setAppLink(String appLink) {
        this.appLink = appLink;
    }

    public String getDependency() {
        if (this.dependency != null) {
            return this.dependency;
        }
        TaskNode taskNode = (TaskNode)JSONUtils.parseObject((String)this.taskJson, TaskNode.class);
        return taskNode.getDependence();
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public void setProcessInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public boolean isTaskComplete() {
        return this.getState().typeIsPause() || this.getState().typeIsSuccess() || this.getState().typeIsCancel() || this.getState().typeIsFailure() && !this.taskCanRetry();
    }

    public Map<String, String> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, String> resources) {
        this.resources = resources;
    }

    public boolean isSubProcess() {
        return TaskType.SUB_PROCESS.equals((Object)TaskType.valueOf((String)this.taskType));
    }

    public boolean isDependTask() {
        return TaskType.DEPENDENT.equals((Object)TaskType.valueOf((String)this.taskType));
    }

    public boolean isConditionsTask() {
        return TaskType.CONDITIONS.equals((Object)TaskType.valueOf((String)this.taskType));
    }

    public boolean taskCanRetry() {
        if (this.isSubProcess()) {
            return false;
        }
        if (this.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
            return true;
        }
        return this.getState().typeIsFailure() && this.getRetryTimes() < this.getMaxRetryTimes();
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public Priority getTaskInstancePriority() {
        return this.taskInstancePriority;
    }

    public void setTaskInstancePriority(Priority taskInstancePriority) {
        this.taskInstancePriority = taskInstancePriority;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public String getDependentResult() {
        return this.dependentResult;
    }

    public void setDependentResult(String dependentResult) {
        this.dependentResult = dependentResult;
    }

    public String toString() {
        return "TaskInstance{id=" + this.id + ", name='" + this.name + '\'' + ", taskType='" + this.taskType + '\'' + ", processDefinitionId=" + this.processDefinitionId + ", processInstanceId=" + this.processInstanceId + ", processInstanceName='" + this.processInstanceName + '\'' + ", taskJson='" + this.taskJson + '\'' + ", state=" + this.state + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", host='" + this.host + '\'' + ", executePath='" + this.executePath + '\'' + ", logPath='" + this.logPath + '\'' + ", retryTimes=" + this.retryTimes + ", alertFlag=" + this.alertFlag + ", processInstance=" + this.processInstance + ", processDefine=" + this.processDefine + ", pid=" + this.pid + ", appLink='" + this.appLink + '\'' + ", flag=" + this.flag + ", dependency='" + this.dependency + '\'' + ", duration=" + this.duration + ", maxRetryTimes=" + this.maxRetryTimes + ", retryInterval=" + this.retryInterval + ", taskInstancePriority=" + this.taskInstancePriority + ", processInstancePriority=" + this.processInstancePriority + ", dependentResult='" + this.dependentResult + '\'' + ", workerGroup='" + this.workerGroup + '\'' + ", executorId=" + this.executorId + ", executorName='" + this.executorName + '\'' + '}';
    }
}

