/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerDataSource
extends BaseDataSource {
    private static final Logger logger = LoggerFactory.getLogger(SQLServerDataSource.class);

    @Override
    public String getJdbcUrl() {
        String jdbcUrl = this.getAddress();
        jdbcUrl = jdbcUrl + ";databaseName=" + this.getDatabase();
        if (StringUtils.isNotEmpty((CharSequence)this.getOther())) {
            jdbcUrl = jdbcUrl + ";" + this.getOther();
        }
        return jdbcUrl;
    }

    @Override
    public void isConnectable() {
        Connection con = null;
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            con = DriverManager.getConnection(this.getJdbcUrl(), this.getUser(), this.getPassword());
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.error("SQL Server datasource try conn close conn error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String driverClassSelector() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.SQLSERVER;
    }
}

