/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.SchemaUtils;
import org.apache.dolphinscheduler.common.utils.ScriptRunner;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.AbstractBaseDao;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.apache.dolphinscheduler.dao.upgrade.ProcessDefinitionDao;
import org.apache.dolphinscheduler.dao.upgrade.ResourceDao;
import org.apache.dolphinscheduler.dao.upgrade.WorkerGroupDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpgradeDao
extends AbstractBaseDao {
    public static final Logger logger = LoggerFactory.getLogger(UpgradeDao.class);
    private static final String T_VERSION_NAME = "t_escheduler_version";
    private static final String T_NEW_VERSION_NAME = "t_ds_version";
    private static final String rootDir = System.getProperty("user.dir");
    protected static final DataSource dataSource = UpgradeDao.getDataSource();
    private static final DbType dbType = UpgradeDao.getCurrentDbType();

    @Override
    protected void init() {
    }

    public static DataSource getDataSource() {
        return ConnectionFactory.getInstance().getDataSource();
    }

    public static DbType getDbType() {
        return dbType;
    }

    private static DbType getCurrentDbType() {
        DbType dbType;
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String name = conn.getMetaData().getDatabaseProductName().toUpperCase();
            dbType = DbType.valueOf((String)name);
        }
        catch (Exception e) {
            DbType dbType2;
            try {
                logger.error(e.getMessage(), (Throwable)e);
                dbType2 = null;
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
            return dbType2;
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
        return dbType;
    }

    public void initSchema() {
        DbType dbType = UpgradeDao.getDbType();
        String initSqlPath = "";
        if (dbType != null) {
            switch (dbType) {
                case MYSQL: {
                    initSqlPath = "/sql/create/release-1.0.0_schema/mysql/";
                    this.initSchema(initSqlPath);
                    break;
                }
                case POSTGRESQL: {
                    initSqlPath = "/sql/create/release-1.2.0_schema/postgresql/";
                    this.initSchema(initSqlPath);
                    break;
                }
                default: {
                    logger.error("not support sql type: {},can't upgrade", (Object)dbType);
                    throw new IllegalArgumentException("not support sql type,can't upgrade");
                }
            }
        }
    }

    public void initSchema(String initSqlPath) {
        this.runInitDDL(initSqlPath);
        this.runInitDML(initSqlPath);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInitDML(String initSqlPath) {
        Connection conn = null;
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String mysqlSQLFilePath = rootDir + initSqlPath + "dolphinscheduler_dml.sql";
        try {
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            ScriptRunner initScriptRunner = new ScriptRunner(conn, false, true);
            FileReader initSqlReader = new FileReader(new File(mysqlSQLFilePath));
            initScriptRunner.runScript((Reader)initSqlReader);
            conn.commit();
        }
        catch (IOException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
                catch (Exception e2) {
                    try {
                        if (null != conn) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInitDDL(String initSqlPath) {
        Connection conn = null;
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String mysqlSQLFilePath = rootDir + initSqlPath + "dolphinscheduler_ddl.sql";
        try {
            conn = dataSource.getConnection();
            ScriptRunner initScriptRunner = new ScriptRunner(conn, true, true);
            FileReader initSqlReader = new FileReader(new File(mysqlSQLFilePath));
            initScriptRunner.runScript((Reader)initSqlReader);
        }
        catch (IOException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
    }

    public abstract boolean isExistsTable(String var1);

    public abstract boolean isExistsColumn(String var1, String var2);

    public String getCurrentVersion(String versionName) {
        String string;
        String sql = String.format("select version from %s", versionName);
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        String version = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString(1);
            }
            string = version;
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return string;
    }

    public void upgradeDolphinScheduler(String schemaDir) {
        this.upgradeDolphinSchedulerDDL(schemaDir);
        this.upgradeDolphinSchedulerDML(schemaDir);
    }

    public void upgradeDolphinSchedulerWorkerGroup() {
        this.updateProcessDefinitionJsonWorkerGroup();
    }

    public void upgradeDolphinSchedulerResourceList() {
        this.updateProcessDefinitionJsonResourceList();
    }

    protected void updateProcessDefinitionJsonWorkerGroup() {
        WorkerGroupDao workerGroupDao = new WorkerGroupDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        HashMap<Integer, String> replaceProcessDefinitionMap = new HashMap<Integer, String>();
        try {
            Map<Integer, String> oldWorkerGroupMap = workerGroupDao.queryAllOldWorkerGroup(dataSource.getConnection());
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(dataSource.getConnection());
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                JSONObject jsonObject = JSONObject.parseObject((String)entry.getValue());
                JSONArray tasks = JSONArray.parseArray((String)jsonObject.getString("tasks"));
                for (int i = 0; i < tasks.size(); ++i) {
                    JSONObject task = tasks.getJSONObject(i);
                    Integer workerGroupId = task.getInteger("workerGroupId");
                    if (workerGroupId == null) continue;
                    if (workerGroupId == -1) {
                        task.put("workerGroup", (Object)"default");
                        continue;
                    }
                    task.put("workerGroup", (Object)oldWorkerGroupMap.get(workerGroupId));
                }
                jsonObject.remove((Object)jsonObject.getString("tasks"));
                jsonObject.put("tasks", (Object)tasks);
                replaceProcessDefinitionMap.put(entry.getKey(), jsonObject.toJSONString());
            }
            if (replaceProcessDefinitionMap.size() > 0) {
                processDefinitionDao.updateProcessDefinitionJson(dataSource.getConnection(), replaceProcessDefinitionMap);
            }
        }
        catch (Exception e) {
            logger.error("update process definition json workergroup error", (Throwable)e);
        }
    }

    protected void updateProcessDefinitionJsonResourceList() {
        ResourceDao resourceDao = new ResourceDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        HashMap<Integer, String> replaceProcessDefinitionMap = new HashMap<Integer, String>();
        try {
            Map<String, Integer> resourcesMap = resourceDao.listAllResources(dataSource.getConnection());
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(dataSource.getConnection());
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                JSONObject jsonObject = JSONObject.parseObject((String)entry.getValue());
                JSONArray tasks = JSONArray.parseArray((String)jsonObject.getString("tasks"));
                for (int i = 0; i < tasks.size(); ++i) {
                    JSONObject task = tasks.getJSONObject(i);
                    JSONObject param = (JSONObject)task.get((Object)"params");
                    if (param != null) {
                        List resourceList = JSONUtils.toList((String)param.getString("resourceList"), ResourceInfo.class);
                        ResourceInfo mainJar = (ResourceInfo)JSONUtils.parseObject((String)param.getString("mainJar"), ResourceInfo.class);
                        if (mainJar != null && mainJar.getId() == 0) {
                            String fullName;
                            String string = fullName = mainJar.getRes().startsWith("/") ? mainJar.getRes() : String.format("/%s", mainJar.getRes());
                            if (resourcesMap.containsKey(fullName)) {
                                mainJar.setId(resourcesMap.get(fullName).intValue());
                                param.put("mainJar", (Object)JSONUtils.parseObject((String)JSONObject.toJSONString((Object)mainJar)));
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)resourceList)) {
                            List newResourceList = resourceList.stream().map(resInfo -> {
                                String fullName;
                                String string = fullName = resInfo.getRes().startsWith("/") ? resInfo.getRes() : String.format("/%s", resInfo.getRes());
                                if (resInfo.getId() == 0 && resourcesMap.containsKey(fullName)) {
                                    resInfo.setId(((Integer)resourcesMap.get(fullName)).intValue());
                                }
                                return resInfo;
                            }).collect(Collectors.toList());
                            param.put("resourceList", JSONArray.parse((String)JSONObject.toJSONString(newResourceList)));
                        }
                    }
                    task.put("params", (Object)param);
                }
                jsonObject.remove((Object)jsonObject.getString("tasks"));
                jsonObject.put("tasks", (Object)tasks);
                replaceProcessDefinitionMap.put(entry.getKey(), jsonObject.toJSONString());
            }
            if (replaceProcessDefinitionMap.size() > 0) {
                processDefinitionDao.updateProcessDefinitionJson(dataSource.getConnection(), replaceProcessDefinitionMap);
            }
        }
        catch (Exception e) {
            logger.error("update process definition json resource list error", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeDolphinSchedulerDML(String schemaDir) {
        String schemaVersion = schemaDir.split("_")[0];
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String sqlFilePath = MessageFormat.format("{0}/sql/upgrade/{1}/{2}/dolphinscheduler_dml.sql", rootDir, schemaDir, UpgradeDao.getDbType().name().toLowerCase());
        logger.info("sqlSQLFilePath" + sqlFilePath);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            ScriptRunner scriptRunner = new ScriptRunner(conn, false, true);
            FileReader sqlReader = new FileReader(new File(sqlFilePath));
            scriptRunner.runScript((Reader)sqlReader);
            if (this.isExistsTable(T_VERSION_NAME)) {
                String upgradeSQL = String.format("update %s set version = ?", T_VERSION_NAME);
                pstmt = conn.prepareStatement(upgradeSQL);
                pstmt.setString(1, schemaVersion);
                pstmt.executeUpdate();
            } else if (this.isExistsTable(T_NEW_VERSION_NAME)) {
                String upgradeSQL = String.format("update %s set version = ?", T_NEW_VERSION_NAME);
                pstmt = conn.prepareStatement(upgradeSQL);
                pstmt.setString(1, schemaVersion);
                pstmt.executeUpdate();
            }
            conn.commit();
        }
        catch (FileNotFoundException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql file not found ", e);
                catch (IOException e2) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                catch (SQLException e3) {
                    try {
                        if (null != conn) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    logger.error(e3.getMessage(), (Throwable)e3);
                    throw new RuntimeException(e3.getMessage(), e3);
                }
                catch (Exception e4) {
                    try {
                        if (null != conn) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    logger.error(e4.getMessage(), (Throwable)e4);
                    throw new RuntimeException(e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeDolphinSchedulerDDL(String schemaDir) {
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String sqlFilePath = MessageFormat.format("{0}/sql/upgrade/{1}/{2}/dolphinscheduler_ddl.sql", rootDir, schemaDir, UpgradeDao.getDbType().name().toLowerCase());
        Connection conn = null;
        Object pstmt = null;
        try {
            conn = dataSource.getConnection();
            String dbName = conn.getCatalog();
            logger.info(dbName);
            conn.setAutoCommit(true);
            ScriptRunner scriptRunner = new ScriptRunner(conn, true, true);
            FileReader sqlReader = new FileReader(new File(sqlFilePath));
            scriptRunner.runScript((Reader)sqlReader);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql file not found ", e);
                catch (IOException e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                catch (SQLException e3) {
                    logger.error(e3.getMessage(), (Throwable)e3);
                    throw new RuntimeException(e3.getMessage(), e3);
                }
                catch (Exception e4) {
                    logger.error(e4.getMessage(), (Throwable)e4);
                    throw new RuntimeException(e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
    }

    public void updateVersion(String version) {
        String versionName = T_VERSION_NAME;
        if (!SchemaUtils.isAGreatVersion((String)"1.2.0", (String)version)) {
            versionName = T_NEW_VERSION_NAME;
        }
        String upgradeSQL = String.format("update %s set version = ?", versionName);
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(upgradeSQL);
            pstmt.setString(1, version);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + upgradeSQL, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
    }
}

