/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.dao.AbstractBaseDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoFactory {
    private static final Logger logger = LoggerFactory.getLogger(DaoFactory.class);
    private static Map<String, AbstractBaseDao> daoMap = new ConcurrentHashMap<String, AbstractBaseDao>();

    private DaoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractBaseDao> T getDaoInstance(Class<T> clazz) {
        String className = clazz.getName();
        Map<String, AbstractBaseDao> map = daoMap;
        synchronized (map) {
            if (!daoMap.containsKey(className)) {
                try {
                    AbstractBaseDao t = (AbstractBaseDao)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    t.init();
                    daoMap.put(className, t);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return (T)daoMap.get(className);
    }
}

