/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import java.sql.Connection;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.HiveConfUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;

public class HiveDataSource
extends BaseDataSource {
    @Override
    public String driverClassSelector() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.HIVE;
    }

    @Override
    protected String filterOther(String otherParams) {
        String[] otherArray;
        if (StringUtils.isBlank((String)otherParams)) {
            return "";
        }
        StringBuilder hiveConfListSb = new StringBuilder();
        hiveConfListSb.append("?");
        StringBuilder sessionVarListSb = new StringBuilder();
        for (String conf : otherArray = otherParams.split(";", -1)) {
            if (HiveConfUtils.isHiveConfVar((String)conf)) {
                hiveConfListSb.append(conf).append(";");
                continue;
            }
            sessionVarListSb.append(conf).append(";");
        }
        if (sessionVarListSb.length() > 0) {
            sessionVarListSb.deleteCharAt(sessionVarListSb.length() - 1);
        }
        if (hiveConfListSb.length() > 0) {
            hiveConfListSb.deleteCharAt(hiveConfListSb.length() - 1);
        }
        return sessionVarListSb.toString() + hiveConfListSb.toString();
    }

    @Override
    public Connection getConnection() throws Exception {
        CommonUtils.loadKerberosConf();
        return super.getConnection();
    }
}

