/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.utils.PropertyUtils;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"org.apache.dolphinscheduler.*.mapper"})
public class SpringConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringConnectionFactory.class);

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    @Bean(destroyMethod="")
    public DruidDataSource dataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(PropertyUtils.getString("spring.datasource.driver-class-name"));
        druidDataSource.setUrl(PropertyUtils.getString("spring.datasource.url"));
        druidDataSource.setUsername(PropertyUtils.getString("spring.datasource.username"));
        druidDataSource.setPassword(PropertyUtils.getString("spring.datasource.password"));
        druidDataSource.setValidationQuery(PropertyUtils.getString("spring.datasource.validationQuery", "SELECT 1"));
        druidDataSource.setPoolPreparedStatements(PropertyUtils.getBoolean("spring.datasource.poolPreparedStatements", true).booleanValue());
        druidDataSource.setTestWhileIdle(PropertyUtils.getBoolean("spring.datasource.testWhileIdle", true).booleanValue());
        druidDataSource.setTestOnBorrow(PropertyUtils.getBoolean("spring.datasource.testOnBorrow", true).booleanValue());
        druidDataSource.setTestOnReturn(PropertyUtils.getBoolean("spring.datasource.testOnReturn", true).booleanValue());
        druidDataSource.setKeepAlive(PropertyUtils.getBoolean("spring.datasource.keepAlive", true).booleanValue());
        druidDataSource.setMinIdle(PropertyUtils.getInt("spring.datasource.minIdle", 5));
        druidDataSource.setMaxActive(PropertyUtils.getInt("spring.datasource.maxActive", 50));
        druidDataSource.setMaxWait((long)PropertyUtils.getInt("spring.datasource.maxWait", 60000));
        druidDataSource.setMaxPoolPreparedStatementPerConnectionSize(PropertyUtils.getInt("spring.datasource.maxPoolPreparedStatementPerConnectionSize", 20));
        druidDataSource.setInitialSize(PropertyUtils.getInt("spring.datasource.initialSize", 5));
        druidDataSource.setTimeBetweenEvictionRunsMillis(PropertyUtils.getLong("spring.datasource.timeBetweenEvictionRunsMillis", 60000L));
        druidDataSource.setTimeBetweenConnectErrorMillis(PropertyUtils.getLong("spring.datasource.timeBetweenConnectErrorMillis", 60000L));
        druidDataSource.setMinEvictableIdleTimeMillis(PropertyUtils.getLong("spring.datasource.minEvictableIdleTimeMillis", 300000L));
        druidDataSource.setValidationQueryTimeout(PropertyUtils.getInt("spring.datasource.validationQueryTimeout", 3));
        druidDataSource.setDefaultAutoCommit(PropertyUtils.getBoolean("spring.datasource.defaultAutoCommit", true).booleanValue());
        return druidDataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager((DataSource)this.dataSource());
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory() throws Exception {
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        configuration.setCallSettersOnNulls(true);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.addInterceptor((Interceptor)this.paginationInterceptor());
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setConfiguration(configuration);
        sqlSessionFactoryBean.setDataSource((DataSource)this.dataSource());
        GlobalConfig.DbConfig dbConfig = new GlobalConfig.DbConfig();
        dbConfig.setIdType(IdType.AUTO);
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDbConfig(dbConfig);
        sqlSessionFactoryBean.setGlobalConfig(globalConfig);
        sqlSessionFactoryBean.setTypeAliasesPackage("org.apache.dolphinscheduler.dao.entity");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources("org/apache/dolphinscheduler/dao/mapper/*Mapper.xml"));
        sqlSessionFactoryBean.setTypeEnumsPackage("org.apache.dolphinscheduler.*.enums");
        sqlSessionFactoryBean.setDatabaseIdProvider(this.databaseIdProvider());
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public SqlSession sqlSession() throws Exception {
        return new SqlSessionTemplate(this.sqlSessionFactory());
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.setProperty("MySQL", "mysql");
        properties.setProperty("PostgreSQL", "pg");
        properties.setProperty("h2", "h2");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }
}

