/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import com.baomidou.mybatisplus.core.toolkit.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger;
    private static final Properties properties;
    private static final PropertyUtils propertyUtils;

    public static String getString(String key) {
        return properties.getProperty(key);
    }

    public static String getString(String key, String defaultVal) {
        String val = properties.getProperty(key.trim());
        return val == null ? defaultVal : val;
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static Boolean getBoolean(String key) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static Boolean getBoolean(String key, boolean defaultValue) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static long getLong(String key, long defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String[] propertyFiles;
        logger = LoggerFactory.getLogger(PropertyUtils.class);
        properties = new Properties();
        propertyUtils = new PropertyUtils();
        for (String fileName : propertyFiles = new String[]{"/datasource.properties"}) {
            InputStream fis = null;
            try {
                fis = PropertyUtils.class.getResourceAsStream(fileName);
                properties.load(fis);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (fis != null) {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                System.exit(1);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = String.valueOf(k);
            logger.info("Overriding property from system property: {}", (Object)key);
            properties.setProperty(key, String.valueOf(v));
        }));
    }
}

