/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.util.List;
import java.util.Objects;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.dao.AbstractBaseDao;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDao
extends AbstractBaseDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PluginDefineMapper pluginDefineMapper;

    @Override
    protected void init() {
        this.pluginDefineMapper = ConnectionFactory.getInstance().getMapper(PluginDefineMapper.class);
    }

    public boolean checkPluginDefineTableExist() {
        return this.pluginDefineMapper.checkTableExist() > 0;
    }

    public int addPluginDefine(PluginDefine pluginDefine) {
        return this.pluginDefineMapper.insert(pluginDefine);
    }

    public int addOrUpdatePluginDefine(PluginDefine pluginDefine) {
        Objects.requireNonNull(pluginDefine, "pluginDefine is null");
        Objects.requireNonNull(pluginDefine.getPluginName(), "pluginName is null");
        Objects.requireNonNull(pluginDefine.getPluginType(), "pluginType is null");
        List<PluginDefine> pluginDefineList = this.pluginDefineMapper.queryByNameAndType(pluginDefine.getPluginName(), pluginDefine.getPluginType());
        if (CollectionUtils.isEmpty(pluginDefineList)) {
            return this.pluginDefineMapper.insert(pluginDefine);
        }
        PluginDefine currPluginDefine = pluginDefineList.get(0);
        if (!currPluginDefine.getPluginParams().equals(pluginDefine.getPluginParams())) {
            currPluginDefine.setUpdateTime(pluginDefine.getUpdateTime());
            currPluginDefine.setPluginParams(pluginDefine.getPluginParams());
            this.pluginDefineMapper.updateById(currPluginDefine);
        }
        return currPluginDefine.getId();
    }

    public PluginDefine getPluginDefineById(int pluginDefineId) {
        return (PluginDefine)this.pluginDefineMapper.selectById(Integer.valueOf(pluginDefineId));
    }

    public PluginDefineMapper getPluginDefineMapper() {
        return this.pluginDefineMapper;
    }

    public void setPluginDefineMapper(PluginDefineMapper pluginDefineMapper) {
        this.pluginDefineMapper = pluginDefineMapper;
    }
}

