/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.task.conditions.ConditionsParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchResultVo;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagHelper {
    private static final Logger logger = LoggerFactory.getLogger(DagHelper.class);

    public static List<TaskNodeRelation> generateRelationListByFlowNodes(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> nodeRelationList = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTaskList = JSONUtils.toList((String)preTasks, String.class);
            if (preTaskList == null) continue;
            for (String depNodeName : preTaskList) {
                if (null == DagHelper.findNodeByName(taskNodeList, depNodeName)) continue;
                nodeRelationList.add(new TaskNodeRelation(depNodeName, taskNode.getName()));
            }
        }
        return nodeRelationList;
    }

    public static List<TaskNode> generateFlowNodeListByStartNode(List<TaskNode> taskNodeList, List<String> startNodeNameList, List<String> recoveryNodeNameList, TaskDependType taskDependType) {
        ArrayList<TaskNode> destFlowNodeList = new ArrayList<TaskNode>();
        List<String> startNodeList = startNodeNameList;
        if (taskDependType != TaskDependType.TASK_POST && CollectionUtils.isEmpty(startNodeList)) {
            logger.error("start node list is empty! cannot continue run the process ");
            return destFlowNodeList;
        }
        ArrayList<TaskNode> destTaskNodeList = new ArrayList<TaskNode>();
        List<Object> tmpTaskNodeList = new ArrayList();
        if (taskDependType == TaskDependType.TASK_POST && CollectionUtils.isNotEmpty(recoveryNodeNameList)) {
            startNodeList = recoveryNodeNameList;
        }
        if (CollectionUtils.isEmpty(startNodeList)) {
            tmpTaskNodeList = taskNodeList;
        } else {
            for (String string : startNodeList) {
                ArrayList<String> visitedNodeNameList;
                TaskNode startNode = DagHelper.findNodeByName(taskNodeList, string);
                List<TaskNode> childNodeList = new ArrayList<TaskNode>();
                if (startNode == null) {
                    logger.error("start node name [{}] is not in task node list [{}] ", (Object)string, taskNodeList);
                    continue;
                }
                if (TaskDependType.TASK_POST == taskDependType) {
                    visitedNodeNameList = new ArrayList<String>();
                    childNodeList = DagHelper.getFlowNodeListPost(startNode, taskNodeList, visitedNodeNameList);
                } else if (TaskDependType.TASK_PRE == taskDependType) {
                    visitedNodeNameList = new ArrayList();
                    childNodeList = DagHelper.getFlowNodeListPre(startNode, recoveryNodeNameList, taskNodeList, visitedNodeNameList);
                } else {
                    childNodeList.add(startNode);
                }
                tmpTaskNodeList.addAll(childNodeList);
            }
        }
        for (TaskNode taskNode : tmpTaskNodeList) {
            if (null != DagHelper.findNodeByName(destTaskNodeList, taskNode.getName())) continue;
            destTaskNodeList.add(taskNode);
        }
        return destTaskNodeList;
    }

    private static List<TaskNode> getFlowNodeListPost(TaskNode startNode, List<TaskNode> taskNodeList, List<String> visitedNodeNameList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        for (TaskNode taskNode : taskNodeList) {
            List depList = taskNode.getDepList();
            if (null == depList || null == startNode || !depList.contains(startNode.getName()) || visitedNodeNameList.contains(taskNode.getName())) continue;
            resultList.addAll(DagHelper.getFlowNodeListPost(taskNode, taskNodeList, visitedNodeNameList));
        }
        if (null != startNode) {
            visitedNodeNameList.add(startNode.getName());
        }
        resultList.add(startNode);
        return resultList;
    }

    private static List<TaskNode> getFlowNodeListPre(TaskNode startNode, List<String> recoveryNodeNameList, List<TaskNode> taskNodeList, List<String> visitedNodeNameList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        List depList = new ArrayList();
        if (null != startNode) {
            depList = startNode.getDepList();
            resultList.add(startNode);
        }
        if (CollectionUtils.isEmpty(depList)) {
            return resultList;
        }
        for (String depNodeName : depList) {
            TaskNode start = DagHelper.findNodeByName(taskNodeList, depNodeName);
            if (recoveryNodeNameList.contains(depNodeName)) {
                resultList.add(start);
                continue;
            }
            if (visitedNodeNameList.contains(depNodeName)) continue;
            resultList.addAll(DagHelper.getFlowNodeListPre(start, recoveryNodeNameList, taskNodeList, visitedNodeNameList));
        }
        if (null != startNode) {
            visitedNodeNameList.add(startNode.getName());
        }
        return resultList;
    }

    public static ProcessDag generateFlowDag(List<TaskNode> totalTaskNodeList, List<String> startNodeNameList, List<String> recoveryNodeNameList, TaskDependType depNodeType) throws Exception {
        List<TaskNode> destTaskNodeList = DagHelper.generateFlowNodeListByStartNode(totalTaskNodeList, startNodeNameList, recoveryNodeNameList, depNodeType);
        if (destTaskNodeList.isEmpty()) {
            return null;
        }
        List<TaskNodeRelation> taskNodeRelations = DagHelper.generateRelationListByFlowNodes(destTaskNodeList);
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(destTaskNodeList);
        return processDag;
    }

    public static TaskNode findNodeByName(List<TaskNode> nodeDetails, String nodeName) {
        for (TaskNode taskNode : nodeDetails) {
            if (!taskNode.getName().equals(nodeName)) continue;
            return taskNode;
        }
        return null;
    }

    public static boolean allDependsForbiddenOrEnd(TaskNode taskNode, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskNode> skipTaskNodeList, Map<String, TaskInstance> completeTaskList) {
        List dependList = taskNode.getDepList();
        if (dependList == null) {
            return true;
        }
        for (String dependNodeName : dependList) {
            TaskNode dependNode = (TaskNode)dag.getNode((Object)dependNodeName);
            if (dependNode == null || completeTaskList.containsKey(dependNodeName) || dependNode.isForbidden().booleanValue() || skipTaskNodeList.containsKey(dependNodeName)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> parsePostNodes(String preNodeName, Map<String, TaskNode> skipTaskNodeList, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        List<String> conditionTaskList;
        HashSet<String> postNodeList = new HashSet<String>();
        Collection<String> startVertexes = new ArrayList();
        if (preNodeName == null) {
            startVertexes = dag.getBeginNode();
        } else if (((TaskNode)dag.getNode((Object)preNodeName)).isConditionsTask()) {
            conditionTaskList = DagHelper.parseConditionTask(preNodeName, skipTaskNodeList, dag, completeTaskList);
            startVertexes.addAll(conditionTaskList);
        } else if (((TaskNode)dag.getNode((Object)preNodeName)).isSwitchTask()) {
            conditionTaskList = DagHelper.parseSwitchTask(preNodeName, skipTaskNodeList, dag, completeTaskList);
            startVertexes.addAll(conditionTaskList);
        } else {
            startVertexes = dag.getSubsequentNodes((Object)preNodeName);
        }
        for (String subsequent : startVertexes) {
            TaskNode taskNode = (TaskNode)dag.getNode((Object)subsequent);
            if (DagHelper.isTaskNodeNeedSkip(taskNode, skipTaskNodeList)) {
                DagHelper.setTaskNodeSkip(subsequent, dag, completeTaskList, skipTaskNodeList);
                continue;
            }
            if (!DagHelper.allDependsForbiddenOrEnd(taskNode, dag, skipTaskNodeList, completeTaskList)) continue;
            if (taskNode.isForbidden().booleanValue() || completeTaskList.containsKey(subsequent)) {
                postNodeList.addAll(DagHelper.parsePostNodes(subsequent, skipTaskNodeList, dag, completeTaskList));
                continue;
            }
            postNodeList.add(subsequent);
        }
        return postNodeList;
    }

    private static boolean isTaskNodeNeedSkip(TaskNode taskNode, Map<String, TaskNode> skipTaskNodeList) {
        if (CollectionUtils.isEmpty((Collection)taskNode.getDepList())) {
            return false;
        }
        for (String depNode : taskNode.getDepList()) {
            if (skipTaskNodeList.containsKey(depNode)) continue;
            return false;
        }
        return true;
    }

    public static List<String> parseConditionTask(String nodeName, Map<String, TaskNode> skipTaskNodeList, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        List<String> conditionTaskList = new ArrayList<String>();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeName);
        if (!taskNode.isConditionsTask()) {
            return conditionTaskList;
        }
        if (!completeTaskList.containsKey(nodeName)) {
            return conditionTaskList;
        }
        TaskInstance taskInstance = completeTaskList.get(nodeName);
        ConditionsParameters conditionsParameters = (ConditionsParameters)JSONUtils.parseObject((String)taskNode.getConditionResult(), ConditionsParameters.class);
        List skipNodeList = new ArrayList();
        if (taskInstance.getState().typeIsSuccess()) {
            conditionTaskList = conditionsParameters.getSuccessNode();
            skipNodeList = conditionsParameters.getFailedNode();
        } else if (taskInstance.getState().typeIsFailure()) {
            conditionTaskList = conditionsParameters.getFailedNode();
            skipNodeList = conditionsParameters.getSuccessNode();
        } else {
            conditionTaskList.add(nodeName);
        }
        for (String failedNode : skipNodeList) {
            DagHelper.setTaskNodeSkip(failedNode, dag, completeTaskList, skipTaskNodeList);
        }
        return conditionTaskList;
    }

    public static List<String> parseSwitchTask(String nodeName, Map<String, TaskNode> skipTaskNodeList, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        List<String> conditionTaskList = new ArrayList<String>();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeName);
        if (!taskNode.isSwitchTask()) {
            return conditionTaskList;
        }
        if (!completeTaskList.containsKey(nodeName)) {
            return conditionTaskList;
        }
        conditionTaskList = DagHelper.skipTaskNode4Switch(taskNode, skipTaskNodeList, completeTaskList, dag);
        return conditionTaskList;
    }

    private static List<String> skipTaskNode4Switch(TaskNode taskNode, Map<String, TaskNode> skipTaskNodeList, Map<String, TaskInstance> completeTaskList, DAG<String, TaskNode, TaskNodeRelation> dag) {
        SwitchParameters switchParameters = completeTaskList.get(taskNode.getName()).getSwitchDependency();
        int resultConditionLocation = switchParameters.getResultConditionLocation();
        List conditionResultVoList = switchParameters.getDependTaskList();
        ArrayList<String> switchTaskList = ((SwitchResultVo)conditionResultVoList.get(resultConditionLocation)).getNextNode();
        if (CollectionUtils.isEmpty((Collection)switchTaskList)) {
            switchTaskList = new ArrayList<String>();
        }
        conditionResultVoList.remove(resultConditionLocation);
        for (SwitchResultVo info : conditionResultVoList) {
            if (CollectionUtils.isEmpty((Collection)info.getNextNode())) continue;
            DagHelper.setTaskNodeSkip((String)info.getNextNode().get(0), dag, completeTaskList, skipTaskNodeList);
        }
        return switchTaskList;
    }

    private static void setTaskNodeSkip(String skipNodeName, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList, Map<String, TaskNode> skipTaskNodeList) {
        if (!dag.containsNode((Object)skipNodeName)) {
            return;
        }
        skipTaskNodeList.putIfAbsent(skipNodeName, (TaskNode)dag.getNode((Object)skipNodeName));
        Set postNodeList = dag.getSubsequentNodes((Object)skipNodeName);
        for (String post : postNodeList) {
            TaskNode postNode = (TaskNode)dag.getNode((Object)post);
            if (!DagHelper.isTaskNodeNeedSkip(postNode, skipTaskNodeList)) continue;
            DagHelper.setTaskNodeSkip(post, dag, completeTaskList, skipTaskNodeList);
        }
    }

    public static DAG<String, TaskNode, TaskNodeRelation> buildDagGraph(ProcessDag processDag) {
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty((Collection)processDag.getNodes())) {
            for (TaskNode node : processDag.getNodes()) {
                dag.addNode((Object)node.getName(), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)processDag.getEdges())) {
            for (TaskNodeRelation edge : processDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }

    public static ProcessDag getProcessDag(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTasksList = JSONUtils.toList((String)preTasks, String.class);
            if (preTasksList == null) continue;
            for (String depNode : preTasksList) {
                taskNodeRelations.add(new TaskNodeRelation(depNode, taskNode.getName()));
            }
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return processDag;
    }

    public static ProcessDag getProcessDag(List<TaskNode> taskNodeList, List<ProcessTaskRelation> processTaskRelations) {
        HashMap taskNodeMap = new HashMap();
        taskNodeList.forEach(taskNode -> taskNodeMap.putIfAbsent(taskNode.getCode(), taskNode));
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            long preTaskCode = processTaskRelation.getPreTaskCode();
            long postTaskCode = processTaskRelation.getPostTaskCode();
            if (processTaskRelation.getPreTaskCode() == 0L || !taskNodeMap.containsKey(preTaskCode) || !taskNodeMap.containsKey(postTaskCode)) continue;
            TaskNode preNode = (TaskNode)taskNodeMap.get(preTaskCode);
            TaskNode postNode = (TaskNode)taskNodeMap.get(postTaskCode);
            taskNodeRelations.add(new TaskNodeRelation(preNode.getName(), postNode.getName()));
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return processDag;
    }

    public static boolean haveConditionsAfterNode(String parentNodeName, DAG<String, TaskNode, TaskNodeRelation> dag) {
        boolean result = false;
        Set subsequentNodes = dag.getSubsequentNodes((Object)parentNodeName);
        if (CollectionUtils.isEmpty((Collection)subsequentNodes)) {
            return result;
        }
        for (String nodeName : subsequentNodes) {
            TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeName);
            List preTasksList = JSONUtils.toList((String)taskNode.getPreTasks(), String.class);
            if (!preTasksList.contains(parentNodeName) || !taskNode.isConditionsTask()) continue;
            return true;
        }
        return result;
    }

    public static boolean haveConditionsAfterNode(String parentNodeName, List<TaskNode> taskNodes) {
        if (CollectionUtils.isEmpty(taskNodes)) {
            return false;
        }
        for (TaskNode taskNode : taskNodes) {
            List preTasksList = JSONUtils.toList((String)taskNode.getPreTasks(), String.class);
            if (!preTasksList.contains(parentNodeName) || !taskNode.isConditionsTask()) continue;
            return true;
        }
        return false;
    }
}

