/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"org.apache.dolphinscheduler.*.mapper"})
public class SpringConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringConnectionFactory.class);

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    @Bean(destroyMethod="")
    public DruidDataSource dataSource() throws SQLException {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(PropertyUtils.getString((String)"spring.datasource.driver-class-name"));
        druidDataSource.setUrl(PropertyUtils.getString((String)"spring.datasource.url"));
        druidDataSource.setUsername(PropertyUtils.getString((String)"spring.datasource.username"));
        druidDataSource.setPassword(PropertyUtils.getString((String)"spring.datasource.password"));
        druidDataSource.setValidationQuery(PropertyUtils.getString((String)"spring.datasource.validationQuery", (String)"SELECT 1"));
        druidDataSource.setPoolPreparedStatements(PropertyUtils.getBoolean((String)"spring.datasource.poolPreparedStatements", (boolean)true).booleanValue());
        druidDataSource.setTestWhileIdle(PropertyUtils.getBoolean((String)"spring.datasource.testWhileIdle", (boolean)true).booleanValue());
        druidDataSource.setTestOnBorrow(PropertyUtils.getBoolean((String)"spring.datasource.testOnBorrow", (boolean)true).booleanValue());
        druidDataSource.setTestOnReturn(PropertyUtils.getBoolean((String)"spring.datasource.testOnReturn", (boolean)false).booleanValue());
        druidDataSource.setKeepAlive(PropertyUtils.getBoolean((String)"spring.datasource.keepAlive", (boolean)true).booleanValue());
        druidDataSource.setMinIdle(PropertyUtils.getInt((String)"spring.datasource.minIdle", (int)5));
        druidDataSource.setMaxActive(PropertyUtils.getInt((String)"spring.datasource.maxActive", (int)50));
        druidDataSource.setMaxWait((long)PropertyUtils.getInt((String)"spring.datasource.maxWait", (int)60000));
        druidDataSource.setMaxPoolPreparedStatementPerConnectionSize(PropertyUtils.getInt((String)"spring.datasource.maxPoolPreparedStatementPerConnectionSize", (int)20));
        druidDataSource.setInitialSize(PropertyUtils.getInt((String)"spring.datasource.initialSize", (int)5));
        druidDataSource.setTimeBetweenEvictionRunsMillis(PropertyUtils.getLong((String)"spring.datasource.timeBetweenEvictionRunsMillis", (long)60000L));
        druidDataSource.setTimeBetweenConnectErrorMillis(PropertyUtils.getLong((String)"spring.datasource.timeBetweenConnectErrorMillis", (long)60000L));
        druidDataSource.setMinEvictableIdleTimeMillis(PropertyUtils.getLong((String)"spring.datasource.minEvictableIdleTimeMillis", (long)300000L));
        druidDataSource.setValidationQueryTimeout(PropertyUtils.getInt((String)"spring.datasource.validationQueryTimeout", (int)3));
        druidDataSource.setDefaultAutoCommit(PropertyUtils.getBoolean((String)"spring.datasource.defaultAutoCommit", (boolean)true).booleanValue());
        druidDataSource.init();
        return druidDataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager() throws SQLException {
        return new DataSourceTransactionManager((DataSource)this.dataSource());
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory() throws Exception {
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        configuration.setCallSettersOnNulls(true);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.addInterceptor((Interceptor)this.paginationInterceptor());
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setConfiguration(configuration);
        sqlSessionFactoryBean.setDataSource((DataSource)this.dataSource());
        GlobalConfig.DbConfig dbConfig = new GlobalConfig.DbConfig();
        dbConfig.setIdType(IdType.AUTO);
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDbConfig(dbConfig);
        sqlSessionFactoryBean.setGlobalConfig(globalConfig);
        sqlSessionFactoryBean.setTypeAliasesPackage("org.apache.dolphinscheduler.dao.entity");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources("org/apache/dolphinscheduler/dao/mapper/*Mapper.xml"));
        sqlSessionFactoryBean.setTypeEnumsPackage("org.apache.dolphinscheduler.*.enums");
        sqlSessionFactoryBean.setDatabaseIdProvider(this.databaseIdProvider());
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public SqlSession sqlSession() throws Exception {
        return new SqlSessionTemplate(this.sqlSessionFactory());
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.setProperty("MySQL", "mysql");
        properties.setProperty("PostgreSQL", "pg");
        properties.setProperty("h2", "h2");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }

    static {
        PropertyUtils.loadPropertyFile((String[])new String[]{"/datasource.properties"});
    }
}

