/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade.shell;

import org.apache.dolphinscheduler.dao.upgrade.DolphinSchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@ComponentScan(value={"org.apache.dolphinscheduler.dao"})
@EnableAutoConfiguration(exclude={QuartzAutoConfiguration.class})
public class CreateDolphinScheduler {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{CreateDolphinScheduler.class}).profiles(new String[]{"shell-create", "shell-cli"}).web(WebApplicationType.NONE).run(args);
    }

    @Component
    @Profile(value={"shell-create"})
    static class CreateRunner
    implements CommandLineRunner {
        private static final Logger logger = LoggerFactory.getLogger(CreateRunner.class);
        private final DolphinSchedulerManager dolphinSchedulerManager;

        CreateRunner(DolphinSchedulerManager dolphinSchedulerManager) {
            this.dolphinSchedulerManager = dolphinSchedulerManager;
        }

        public void run(String ... args) throws Exception {
            this.dolphinSchedulerManager.initDolphinScheduler();
            logger.info("init DolphinScheduler finished");
            this.dolphinSchedulerManager.upgradeDolphinScheduler();
            logger.info("upgrade DolphinScheduler finished");
            logger.info("create DolphinScheduler success");
        }
    }
}

