/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.task.conditions.ConditionsParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchResultVo;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagHelper {
    private static final Logger logger = LoggerFactory.getLogger(DagHelper.class);

    public static List<TaskNodeRelation> generateRelationListByFlowNodes(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> nodeRelationList = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTaskList = JSONUtils.toList((String)preTasks, String.class);
            if (preTaskList == null) continue;
            for (String depNodeCode : preTaskList) {
                if (null == DagHelper.findNodeByCode(taskNodeList, depNodeCode)) continue;
                nodeRelationList.add(new TaskNodeRelation(depNodeCode, Long.toString(taskNode.getCode())));
            }
        }
        return nodeRelationList;
    }

    public static List<TaskNode> generateFlowNodeListByStartNode(List<TaskNode> taskNodeList, List<String> startNodeNameList, List<String> recoveryNodeCodeList, TaskDependType taskDependType) {
        ArrayList<TaskNode> destFlowNodeList = new ArrayList<TaskNode>();
        List<String> startNodeList = startNodeNameList;
        if (taskDependType != TaskDependType.TASK_POST && CollectionUtils.isEmpty(startNodeList)) {
            logger.error("start node list is empty! cannot continue run the process ");
            return destFlowNodeList;
        }
        ArrayList<TaskNode> destTaskNodeList = new ArrayList<TaskNode>();
        List<Object> tmpTaskNodeList = new ArrayList();
        if (taskDependType == TaskDependType.TASK_POST && CollectionUtils.isNotEmpty(recoveryNodeCodeList)) {
            startNodeList = recoveryNodeCodeList;
        }
        if (CollectionUtils.isEmpty(startNodeList)) {
            tmpTaskNodeList = taskNodeList;
        } else {
            for (String string : startNodeList) {
                ArrayList<String> visitedNodeCodeList;
                TaskNode startNode = DagHelper.findNodeByCode(taskNodeList, string);
                List<TaskNode> childNodeList = new ArrayList<TaskNode>();
                if (startNode == null) {
                    logger.error("start node name [{}] is not in task node list [{}] ", (Object)string, taskNodeList);
                    continue;
                }
                if (TaskDependType.TASK_POST == taskDependType) {
                    visitedNodeCodeList = new ArrayList<String>();
                    childNodeList = DagHelper.getFlowNodeListPost(startNode, taskNodeList, visitedNodeCodeList);
                } else if (TaskDependType.TASK_PRE == taskDependType) {
                    visitedNodeCodeList = new ArrayList();
                    childNodeList = DagHelper.getFlowNodeListPre(startNode, recoveryNodeCodeList, taskNodeList, visitedNodeCodeList);
                } else {
                    childNodeList.add(startNode);
                }
                tmpTaskNodeList.addAll(childNodeList);
            }
        }
        for (TaskNode taskNode : tmpTaskNodeList) {
            if (null != DagHelper.findNodeByCode(destTaskNodeList, Long.toString(taskNode.getCode()))) continue;
            destTaskNodeList.add(taskNode);
        }
        return destTaskNodeList;
    }

    private static List<TaskNode> getFlowNodeListPost(TaskNode startNode, List<TaskNode> taskNodeList, List<String> visitedNodeCodeList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        for (TaskNode taskNode : taskNodeList) {
            List depList = taskNode.getDepList();
            if (null == depList || null == startNode || !depList.contains(Long.toString(startNode.getCode())) || visitedNodeCodeList.contains(Long.toString(taskNode.getCode()))) continue;
            resultList.addAll(DagHelper.getFlowNodeListPost(taskNode, taskNodeList, visitedNodeCodeList));
        }
        if (null != startNode) {
            visitedNodeCodeList.add(Long.toString(startNode.getCode()));
        }
        resultList.add(startNode);
        return resultList;
    }

    private static List<TaskNode> getFlowNodeListPre(TaskNode startNode, List<String> recoveryNodeCodeList, List<TaskNode> taskNodeList, List<String> visitedNodeCodeList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        List depList = new ArrayList();
        if (null != startNode) {
            depList = startNode.getDepList();
            resultList.add(startNode);
        }
        if (CollectionUtils.isEmpty(depList)) {
            return resultList;
        }
        for (String depNodeCode : depList) {
            TaskNode start = DagHelper.findNodeByCode(taskNodeList, depNodeCode);
            if (recoveryNodeCodeList.contains(depNodeCode)) {
                resultList.add(start);
                continue;
            }
            if (visitedNodeCodeList.contains(depNodeCode)) continue;
            resultList.addAll(DagHelper.getFlowNodeListPre(start, recoveryNodeCodeList, taskNodeList, visitedNodeCodeList));
        }
        if (null != startNode) {
            visitedNodeCodeList.add(Long.toString(startNode.getCode()));
        }
        return resultList;
    }

    public static ProcessDag generateFlowDag(List<TaskNode> totalTaskNodeList, List<String> startNodeNameList, List<String> recoveryNodeCodeList, TaskDependType depNodeType) throws Exception {
        List<TaskNode> destTaskNodeList = DagHelper.generateFlowNodeListByStartNode(totalTaskNodeList, startNodeNameList, recoveryNodeCodeList, depNodeType);
        if (destTaskNodeList.isEmpty()) {
            return null;
        }
        List<TaskNodeRelation> taskNodeRelations = DagHelper.generateRelationListByFlowNodes(destTaskNodeList);
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(destTaskNodeList);
        return processDag;
    }

    public static TaskNode findNodeByName(List<TaskNode> nodeDetails, String nodeName) {
        for (TaskNode taskNode : nodeDetails) {
            if (!taskNode.getName().equals(nodeName)) continue;
            return taskNode;
        }
        return null;
    }

    public static TaskNode findNodeByCode(List<TaskNode> nodeDetails, String nodeCode) {
        for (TaskNode taskNode : nodeDetails) {
            if (!Long.toString(taskNode.getCode()).equals(nodeCode)) continue;
            return taskNode;
        }
        return null;
    }

    public static boolean allDependsForbiddenOrEnd(TaskNode taskNode, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskNode> skipTaskNodeList, Map<String, TaskInstance> completeTaskList) {
        List dependList = taskNode.getDepList();
        if (dependList == null) {
            return true;
        }
        for (String dependNodeCode : dependList) {
            TaskNode dependNode = (TaskNode)dag.getNode((Object)dependNodeCode);
            if (dependNode == null || completeTaskList.containsKey(dependNodeCode) || dependNode.isForbidden().booleanValue() || skipTaskNodeList.containsKey(dependNodeCode)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> parsePostNodes(String preNodeCode, Map<String, TaskNode> skipTaskNodeList, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        List<String> conditionTaskList;
        HashSet<String> postNodeList = new HashSet<String>();
        Collection<String> startVertexes = new ArrayList();
        if (preNodeCode == null) {
            startVertexes = dag.getBeginNode();
        } else if (((TaskNode)dag.getNode((Object)preNodeCode)).isConditionsTask()) {
            conditionTaskList = DagHelper.parseConditionTask(preNodeCode, skipTaskNodeList, dag, completeTaskList);
            startVertexes.addAll(conditionTaskList);
        } else if (((TaskNode)dag.getNode((Object)preNodeCode)).isSwitchTask()) {
            conditionTaskList = DagHelper.parseSwitchTask(preNodeCode, skipTaskNodeList, dag, completeTaskList);
            startVertexes.addAll(conditionTaskList);
        } else {
            startVertexes = dag.getSubsequentNodes((Object)preNodeCode);
        }
        for (String subsequent : startVertexes) {
            TaskNode taskNode = (TaskNode)dag.getNode((Object)subsequent);
            if (taskNode == null) {
                logger.error("taskNode {} is null, please check dag", (Object)subsequent);
                continue;
            }
            if (DagHelper.isTaskNodeNeedSkip(taskNode, skipTaskNodeList)) {
                DagHelper.setTaskNodeSkip(subsequent, dag, completeTaskList, skipTaskNodeList);
                continue;
            }
            if (!DagHelper.allDependsForbiddenOrEnd(taskNode, dag, skipTaskNodeList, completeTaskList)) continue;
            if (taskNode.isForbidden().booleanValue() || completeTaskList.containsKey(subsequent)) {
                postNodeList.addAll(DagHelper.parsePostNodes(subsequent, skipTaskNodeList, dag, completeTaskList));
                continue;
            }
            postNodeList.add(subsequent);
        }
        return postNodeList;
    }

    private static boolean isTaskNodeNeedSkip(TaskNode taskNode, Map<String, TaskNode> skipTaskNodeList) {
        if (CollectionUtils.isEmpty((Collection)taskNode.getDepList())) {
            return false;
        }
        for (String depNode : taskNode.getDepList()) {
            if (skipTaskNodeList.containsKey(depNode)) continue;
            return false;
        }
        return true;
    }

    public static List<String> parseConditionTask(String nodeCode, Map<String, TaskNode> skipTaskNodeList, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        List<String> conditionTaskList = new ArrayList<String>();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
        if (!taskNode.isConditionsTask()) {
            return conditionTaskList;
        }
        if (!completeTaskList.containsKey(nodeCode)) {
            return conditionTaskList;
        }
        TaskInstance taskInstance = completeTaskList.get(nodeCode);
        ConditionsParameters conditionsParameters = (ConditionsParameters)JSONUtils.parseObject((String)taskNode.getConditionResult(), ConditionsParameters.class);
        if (conditionsParameters == null) {
            return conditionTaskList;
        }
        List<Object> skipNodeList = new ArrayList();
        if (taskInstance.getState().typeIsSuccess()) {
            conditionTaskList = conditionsParameters.getSuccessNode().stream().map(String::valueOf).collect(Collectors.toList());
            skipNodeList = conditionsParameters.getFailedNode().stream().map(String::valueOf).collect(Collectors.toList());
        } else if (taskInstance.getState().typeIsFailure()) {
            conditionTaskList = conditionsParameters.getFailedNode().stream().map(String::valueOf).collect(Collectors.toList());
            skipNodeList = conditionsParameters.getSuccessNode().stream().map(String::valueOf).collect(Collectors.toList());
        } else {
            conditionTaskList.add(nodeCode);
        }
        for (String failedNode : skipNodeList) {
            DagHelper.setTaskNodeSkip(failedNode, dag, completeTaskList, skipTaskNodeList);
        }
        return conditionTaskList;
    }

    public static List<String> parseSwitchTask(String nodeCode, Map<String, TaskNode> skipTaskNodeList, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList) {
        ArrayList<String> conditionTaskList = new ArrayList<String>();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
        if (!taskNode.isSwitchTask()) {
            return conditionTaskList;
        }
        if (!completeTaskList.containsKey(nodeCode)) {
            return conditionTaskList;
        }
        conditionTaskList.add(String.valueOf(DagHelper.skipTaskNode4Switch(taskNode, skipTaskNodeList, completeTaskList, dag)));
        return conditionTaskList;
    }

    private static Long skipTaskNode4Switch(TaskNode taskNode, Map<String, TaskNode> skipTaskNodeList, Map<String, TaskInstance> completeTaskList, DAG<String, TaskNode, TaskNodeRelation> dag) {
        SwitchParameters switchParameters = completeTaskList.get(Long.toString(taskNode.getCode())).getSwitchDependency();
        int resultConditionLocation = switchParameters.getResultConditionLocation();
        List conditionResultVoList = switchParameters.getDependTaskList();
        Long switchTaskList = ((SwitchResultVo)conditionResultVoList.get(resultConditionLocation)).getNextNode();
        if (switchTaskList == null) {
            switchTaskList = 0L;
        }
        conditionResultVoList.remove(resultConditionLocation);
        for (SwitchResultVo info : conditionResultVoList) {
            Long nextNode = info.getNextNode();
            if (nextNode == null || nextNode == 0L) continue;
            DagHelper.setTaskNodeSkip(String.valueOf(nextNode), dag, completeTaskList, skipTaskNodeList);
        }
        return switchTaskList;
    }

    private static void setTaskNodeSkip(String skipNodeCode, DAG<String, TaskNode, TaskNodeRelation> dag, Map<String, TaskInstance> completeTaskList, Map<String, TaskNode> skipTaskNodeList) {
        if (!dag.containsNode((Object)skipNodeCode)) {
            return;
        }
        skipTaskNodeList.putIfAbsent(skipNodeCode, (TaskNode)dag.getNode((Object)skipNodeCode));
        Set postNodeList = dag.getSubsequentNodes((Object)skipNodeCode);
        for (String post : postNodeList) {
            TaskNode postNode = (TaskNode)dag.getNode((Object)post);
            if (!DagHelper.isTaskNodeNeedSkip(postNode, skipTaskNodeList)) continue;
            DagHelper.setTaskNodeSkip(post, dag, completeTaskList, skipTaskNodeList);
        }
    }

    public static DAG<String, TaskNode, TaskNodeRelation> buildDagGraph(ProcessDag processDag) {
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty((Collection)processDag.getNodes())) {
            for (TaskNode node : processDag.getNodes()) {
                dag.addNode((Object)Long.toString(node.getCode()), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)processDag.getEdges())) {
            for (TaskNodeRelation edge : processDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }

    public static ProcessDag getProcessDag(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTasksList = JSONUtils.toList((String)preTasks, String.class);
            if (preTasksList == null) continue;
            for (String depNode : preTasksList) {
                taskNodeRelations.add(new TaskNodeRelation(depNode, Long.toString(taskNode.getCode())));
            }
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return processDag;
    }

    public static ProcessDag getProcessDag(List<TaskNode> taskNodeList, List<ProcessTaskRelation> processTaskRelations) {
        HashMap taskNodeMap = new HashMap();
        taskNodeList.forEach(taskNode -> taskNodeMap.putIfAbsent(taskNode.getCode(), taskNode));
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            long preTaskCode = processTaskRelation.getPreTaskCode();
            long postTaskCode = processTaskRelation.getPostTaskCode();
            if (processTaskRelation.getPreTaskCode() == 0L || !taskNodeMap.containsKey(preTaskCode) || !taskNodeMap.containsKey(postTaskCode)) continue;
            TaskNode preNode = (TaskNode)taskNodeMap.get(preTaskCode);
            TaskNode postNode = (TaskNode)taskNodeMap.get(postTaskCode);
            taskNodeRelations.add(new TaskNodeRelation(Long.toString(preNode.getCode()), Long.toString(postNode.getCode())));
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return processDag;
    }

    public static boolean haveConditionsAfterNode(String parentNodeCode, DAG<String, TaskNode, TaskNodeRelation> dag) {
        boolean result = false;
        Set subsequentNodes = dag.getSubsequentNodes((Object)parentNodeCode);
        if (CollectionUtils.isEmpty((Collection)subsequentNodes)) {
            return result;
        }
        for (String nodeCode : subsequentNodes) {
            TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
            List preTasksList = JSONUtils.toList((String)taskNode.getPreTasks(), String.class);
            if (!preTasksList.contains(parentNodeCode) || !taskNode.isConditionsTask()) continue;
            return true;
        }
        return result;
    }

    public static boolean haveConditionsAfterNode(String parentNodeCode, List<TaskNode> taskNodes) {
        if (CollectionUtils.isEmpty(taskNodes)) {
            return false;
        }
        for (TaskNode taskNode : taskNodes) {
            List preTasksList = JSONUtils.toList((String)taskNode.getPreTasks(), String.class);
            if (!preTasksList.contains(parentNodeCode) || !taskNode.isConditionsTask()) continue;
            return true;
        }
        return false;
    }
}

