/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ScriptRunner;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.upgrade.JsonSplitDao;
import org.apache.dolphinscheduler.dao.upgrade.ProcessDefinitionDao;
import org.apache.dolphinscheduler.dao.upgrade.ProjectDao;
import org.apache.dolphinscheduler.dao.upgrade.ResourceDao;
import org.apache.dolphinscheduler.dao.upgrade.ScheduleDao;
import org.apache.dolphinscheduler.dao.upgrade.SchemaUtils;
import org.apache.dolphinscheduler.dao.upgrade.WorkerGroupDao;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public abstract class UpgradeDao {
    public static final Logger logger = LoggerFactory.getLogger(UpgradeDao.class);
    private static final String T_VERSION_NAME = "t_escheduler_version";
    private static final String T_NEW_VERSION_NAME = "t_ds_version";
    protected final DataSource dataSource;

    protected UpgradeDao(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected abstract String initSqlPath();

    protected abstract DbType getDbType();

    public void initSchema() {
        this.runInitSql(this.getDbType());
    }

    private void runInitSql(DbType dbType) {
        String sqlFile = String.format("dolphinscheduler_%s.sql", dbType.getDescp());
        ClassPathResource mysqlSQLFilePath = new ClassPathResource("sql/" + sqlFile);
        try (Connection conn = this.dataSource.getConnection();){
            ScriptRunner initScriptRunner = new ScriptRunner(conn, true, true);
            InputStreamReader initSqlReader = new InputStreamReader(mysqlSQLFilePath.getInputStream());
            initScriptRunner.runScript((Reader)initSqlReader);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public abstract boolean isExistsTable(String var1);

    public abstract boolean isExistsColumn(String var1, String var2);

    public String getCurrentVersion(String versionName) {
        String string;
        String sql = String.format("select version from %s", versionName);
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        String version = null;
        try {
            conn = this.dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString(1);
            }
            string = version;
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return string;
    }

    public void upgradeDolphinScheduler(String schemaDir) {
        this.upgradeDolphinSchedulerDDL(schemaDir, "dolphinscheduler_ddl.sql");
        this.upgradeDolphinSchedulerDML(schemaDir);
    }

    public void upgradeDolphinSchedulerWorkerGroup() {
        this.updateProcessDefinitionJsonWorkerGroup();
    }

    public void upgradeDolphinSchedulerResourceList() {
        this.updateProcessDefinitionJsonResourceList();
    }

    public void upgradeDolphinSchedulerTo200(String schemaDir) {
        this.processDefinitionJsonSplit();
        this.upgradeDolphinSchedulerDDL(schemaDir, "dolphinscheduler_ddl_post.sql");
    }

    public void upgradeDolphinSchedulerResourceFileSize() {
        ResourceDao resourceDao = new ResourceDao();
        try {
            resourceDao.updateResourceFolderSizeByFileType(this.dataSource.getConnection(), 0);
            resourceDao.updateResourceFolderSizeByFileType(this.dataSource.getConnection(), 1);
        }
        catch (Exception ex) {
            logger.error("Failed to upgrade because of failing to update the folder's size of resource files.");
        }
    }

    protected void updateProcessDefinitionJsonWorkerGroup() {
        WorkerGroupDao workerGroupDao = new WorkerGroupDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        HashMap<Integer, String> replaceProcessDefinitionMap = new HashMap<Integer, String>();
        try {
            Map<Integer, String> oldWorkerGroupMap = workerGroupDao.queryAllOldWorkerGroup(this.dataSource.getConnection());
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(this.dataSource.getConnection());
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                ObjectNode jsonObject = JSONUtils.parseObject((String)entry.getValue());
                ArrayNode tasks = JSONUtils.parseArray((String)jsonObject.get("tasks").toString());
                for (int i = 0; i < tasks.size(); ++i) {
                    ObjectNode task = (ObjectNode)tasks.path(i);
                    ObjectNode workerGroupNode = (ObjectNode)task.path("workerGroupId");
                    int workerGroupId = -1;
                    if (workerGroupNode != null && workerGroupNode.canConvertToInt()) {
                        workerGroupId = workerGroupNode.asInt(-1);
                    }
                    if (workerGroupId == -1) {
                        task.put("workerGroup", "default");
                        continue;
                    }
                    task.put("workerGroup", oldWorkerGroupMap.get(workerGroupId));
                }
                jsonObject.remove("task");
                jsonObject.put("tasks", (JsonNode)tasks);
                replaceProcessDefinitionMap.put(entry.getKey(), jsonObject.toString());
            }
            if (replaceProcessDefinitionMap.size() > 0) {
                processDefinitionDao.updateProcessDefinitionJson(this.dataSource.getConnection(), replaceProcessDefinitionMap);
            }
        }
        catch (Exception e) {
            logger.error("update process definition json workergroup error", (Throwable)e);
        }
    }

    protected void updateProcessDefinitionJsonResourceList() {
        ResourceDao resourceDao = new ResourceDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        HashMap<Integer, String> replaceProcessDefinitionMap = new HashMap<Integer, String>();
        try {
            Map<String, Integer> resourcesMap = resourceDao.listAllResources(this.dataSource.getConnection());
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(this.dataSource.getConnection());
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                ObjectNode jsonObject = JSONUtils.parseObject((String)entry.getValue());
                ArrayNode tasks = JSONUtils.parseArray((String)jsonObject.get("tasks").toString());
                for (int i = 0; i < tasks.size(); ++i) {
                    ObjectNode task = (ObjectNode)tasks.get(i);
                    ObjectNode param = (ObjectNode)task.get("params");
                    if (param != null) {
                        List resourceList = JSONUtils.toList((String)param.get("resourceList").toString(), ResourceInfo.class);
                        ResourceInfo mainJar = (ResourceInfo)JSONUtils.parseObject((String)param.get("mainJar").toString(), ResourceInfo.class);
                        if (mainJar != null && mainJar.getId() == 0) {
                            String fullName;
                            String string = fullName = mainJar.getRes().startsWith("/") ? mainJar.getRes() : String.format("/%s", mainJar.getRes());
                            if (resourcesMap.containsKey(fullName)) {
                                mainJar.setId(resourcesMap.get(fullName).intValue());
                                param.put("mainJar", (JsonNode)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)mainJar)));
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)resourceList)) {
                            List newResourceList = resourceList.stream().map(resInfo -> {
                                String fullName;
                                String string = fullName = resInfo.getRes().startsWith("/") ? resInfo.getRes() : String.format("/%s", resInfo.getRes());
                                if (resInfo.getId() == 0 && resourcesMap.containsKey(fullName)) {
                                    resInfo.setId(((Integer)resourcesMap.get(fullName)).intValue());
                                }
                                return resInfo;
                            }).collect(Collectors.toList());
                            param.put("resourceList", (JsonNode)JSONUtils.parseObject((String)JSONUtils.toJsonString(newResourceList)));
                        }
                    }
                    task.put("params", (JsonNode)param);
                }
                jsonObject.remove("tasks");
                jsonObject.put("tasks", (JsonNode)tasks);
                replaceProcessDefinitionMap.put(entry.getKey(), jsonObject.toString());
            }
            if (replaceProcessDefinitionMap.size() > 0) {
                processDefinitionDao.updateProcessDefinitionJson(this.dataSource.getConnection(), replaceProcessDefinitionMap);
            }
        }
        catch (Exception e) {
            logger.error("update process definition json resource list error", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeDolphinSchedulerDML(String schemaDir) {
        String schemaVersion = schemaDir.split("_")[0];
        ClassPathResource sqlFilePath = new ClassPathResource(String.format("sql/upgrade/%s/%s/dolphinscheduler_dml.sql", schemaDir, this.getDbType().name().toLowerCase()));
        if (!sqlFilePath.exists()) {
            logger.info("No dml file {}, returning", (Object)sqlFilePath);
            return;
        }
        logger.info("sqlSQLFilePath" + sqlFilePath);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(false);
            ScriptRunner scriptRunner = new ScriptRunner(conn, false, true);
            InputStreamReader sqlReader = new InputStreamReader(sqlFilePath.getInputStream());
            scriptRunner.runScript((Reader)sqlReader);
            if (this.isExistsTable(T_VERSION_NAME)) {
                String upgradeSQL = String.format("update %s set version = ?", T_VERSION_NAME);
                pstmt = conn.prepareStatement(upgradeSQL);
                pstmt.setString(1, schemaVersion);
                pstmt.executeUpdate();
            } else if (this.isExistsTable(T_NEW_VERSION_NAME)) {
                String upgradeSQL = String.format("update %s set version = ?", T_NEW_VERSION_NAME);
                pstmt = conn.prepareStatement(upgradeSQL);
                pstmt.setString(1, schemaVersion);
                pstmt.executeUpdate();
            }
            conn.commit();
        }
        catch (FileNotFoundException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql file not found ", e);
                catch (IOException e2) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                catch (Exception e3) {
                    try {
                        if (null != conn) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    logger.error(e3.getMessage(), (Throwable)e3);
                    throw new RuntimeException(e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeDolphinSchedulerDDL(String schemaDir, String scriptFile) {
        ClassPathResource sqlFilePath = new ClassPathResource(String.format("sql/upgrade/%s/%s/%s", schemaDir, this.getDbType().name().toLowerCase(), scriptFile));
        Connection conn = null;
        Object pstmt = null;
        try {
            conn = this.dataSource.getConnection();
            String dbName = conn.getCatalog();
            logger.info(dbName);
            conn.setAutoCommit(true);
            ScriptRunner scriptRunner = new ScriptRunner(conn, true, true);
            InputStreamReader sqlReader = new InputStreamReader(sqlFilePath.getInputStream());
            scriptRunner.runScript((Reader)sqlReader);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql file not found ", e);
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
    }

    public void updateVersion(String version) {
        String versionName = T_VERSION_NAME;
        if (!SchemaUtils.isAGreatVersion("1.2.0", version)) {
            versionName = T_NEW_VERSION_NAME;
        }
        String upgradeSQL = String.format("update %s set version = ?", versionName);
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            pstmt = conn.prepareStatement(upgradeSQL);
            pstmt.setString(1, version);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + upgradeSQL, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{pstmt, conn});
    }

    private void processDefinitionJsonSplit() {
        ProjectDao projectDao = new ProjectDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        ScheduleDao scheduleDao = new ScheduleDao();
        JsonSplitDao jsonSplitDao = new JsonSplitDao();
        try {
            Map<Integer, Long> projectIdCodeMap = projectDao.queryAllProject(this.dataSource.getConnection());
            projectDao.updateProjectCode(this.dataSource.getConnection(), projectIdCodeMap);
            List<ProcessDefinition> processDefinitions = processDefinitionDao.queryProcessDefinition(this.dataSource.getConnection());
            processDefinitionDao.updateProcessDefinitionCode(this.dataSource.getConnection(), processDefinitions, projectIdCodeMap);
            Map<Integer, Long> allSchedule = scheduleDao.queryAllSchedule(this.dataSource.getConnection());
            Map<Integer, Long> processIdCodeMap = processDefinitions.stream().collect(Collectors.toMap(ProcessDefinition::getId, ProcessDefinition::getCode));
            scheduleDao.updateScheduleCode(this.dataSource.getConnection(), allSchedule, processIdCodeMap);
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(this.dataSource.getConnection());
            ArrayList<ProcessDefinitionLog> processDefinitionLogs = new ArrayList<ProcessDefinitionLog>();
            ArrayList<ProcessTaskRelationLog> processTaskRelationLogs = new ArrayList<ProcessTaskRelationLog>();
            ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
            HashMap<Integer, Map<Long, Map<String, Long>>> processTaskMap = new HashMap<Integer, Map<Long, Map<String, Long>>>();
            this.splitProcessDefinitionJson(processDefinitions, processDefinitionJsonMap, processDefinitionLogs, processTaskRelationLogs, taskDefinitionLogs, processTaskMap);
            this.convertDependence(taskDefinitionLogs, projectIdCodeMap, processTaskMap);
            jsonSplitDao.executeJsonSplitProcessDefinition(this.dataSource.getConnection(), processDefinitionLogs);
            jsonSplitDao.executeJsonSplitProcessTaskRelation(this.dataSource.getConnection(), processTaskRelationLogs);
            jsonSplitDao.executeJsonSplitTaskDefinition(this.dataSource.getConnection(), taskDefinitionLogs);
        }
        catch (Exception e) {
            logger.error("json split error", (Throwable)e);
        }
    }

    private void splitProcessDefinitionJson(List<ProcessDefinition> processDefinitions, Map<Integer, String> processDefinitionJsonMap, List<ProcessDefinitionLog> processDefinitionLogs, List<ProcessTaskRelationLog> processTaskRelationLogs, List<TaskDefinitionLog> taskDefinitionLogs, Map<Integer, Map<Long, Map<String, Long>>> processTaskMap) throws Exception {
        Map<Integer, ProcessDefinition> processDefinitionMap = processDefinitions.stream().collect(Collectors.toMap(ProcessDefinition::getId, processDefinition -> processDefinition));
        Date now = new Date();
        for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
            if (entry.getValue() == null) {
                throw new Exception("processDefinitionJson is null");
            }
            ObjectNode jsonObject = JSONUtils.parseObject((String)entry.getValue());
            ProcessDefinition processDefinition2 = processDefinitionMap.get(entry.getKey());
            if (processDefinition2 == null) {
                throw new Exception("It can't find processDefinition, please check !");
            }
            processDefinition2.setTenantId(jsonObject.get("tenantId") == null ? -1 : jsonObject.get("tenantId").asInt());
            processDefinition2.setTimeout(jsonObject.get("timeout").asInt());
            processDefinition2.setGlobalParams(jsonObject.get("globalParams").toString());
            HashMap<String, Long> taskIdCodeMap = new HashMap<String, Long>();
            HashMap<String, List<String>> taskNamePreMap = new HashMap<String, List<String>>();
            HashMap<String, Long> taskNameCodeMap = new HashMap<String, Long>();
            HashMap<Long, HashMap<String, Long>> processCodeTaskNameCodeMap = new HashMap<Long, HashMap<String, Long>>();
            ArrayList<TaskDefinitionLog> taskDefinitionLogList = new ArrayList<TaskDefinitionLog>();
            ArrayNode tasks = JSONUtils.parseArray((String)jsonObject.get("tasks").toString());
            for (int i = 0; i < tasks.size(); ++i) {
                TaskTimeoutParameter timeout;
                ObjectNode task = (ObjectNode)tasks.path(i);
                ObjectNode param = (ObjectNode)task.get("params");
                TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
                String taskType = task.get("type").asText();
                if (param != null) {
                    JsonNode jsonNodeDefinitionId;
                    JsonNode resourceJsonNode = param.get("resourceList");
                    if (resourceJsonNode != null && !resourceJsonNode.isEmpty()) {
                        List resourceList = JSONUtils.toList((String)param.get("resourceList").toString(), ResourceInfo.class);
                        List resourceIds = resourceList.stream().map(ResourceInfo::getId).collect(Collectors.toList());
                        taskDefinitionLog.setResourceIds(StringUtils.join(resourceIds, (String)","));
                    } else {
                        taskDefinitionLog.setResourceIds("");
                    }
                    if (TaskType.SUB_PROCESS.getDesc().equals(taskType) && (jsonNodeDefinitionId = param.get("processDefinitionId")) != null) {
                        param.put("processDefinitionCode", processDefinitionMap.get(jsonNodeDefinitionId.asInt()).getCode());
                        param.remove("processDefinitionId");
                    }
                    param.put("conditionResult", task.get("conditionResult"));
                    param.put("dependence", task.get("dependence"));
                    taskDefinitionLog.setTaskParams(JSONUtils.toJsonString((Object)param));
                }
                if ((timeout = (TaskTimeoutParameter)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)task.get("timeout")), TaskTimeoutParameter.class)) != null) {
                    taskDefinitionLog.setTimeout(timeout.getInterval());
                    taskDefinitionLog.setTimeoutFlag(timeout.getEnable() ? TimeoutFlag.OPEN : TimeoutFlag.CLOSE);
                    taskDefinitionLog.setTimeoutNotifyStrategy(timeout.getStrategy());
                }
                String desc = task.get("description") != null ? task.get("description").asText() : (task.get("desc") != null ? task.get("desc").asText() : "");
                taskDefinitionLog.setDescription(desc);
                taskDefinitionLog.setFlag("NORMAL".equals(task.get("runFlag").asText()) ? Flag.YES : Flag.NO);
                taskDefinitionLog.setTaskType(taskType);
                taskDefinitionLog.setFailRetryInterval(TaskType.SUB_PROCESS.getDesc().equals(taskType) ? 1 : task.get("retryInterval").asInt());
                taskDefinitionLog.setFailRetryTimes(TaskType.SUB_PROCESS.getDesc().equals(taskType) ? 0 : task.get("maxRetryTimes").asInt());
                taskDefinitionLog.setTaskPriority((Priority)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)task.get("taskInstancePriority")), Priority.class));
                String name = task.get("name").asText();
                taskDefinitionLog.setName(name);
                taskDefinitionLog.setWorkerGroup(task.get("workerGroup") == null ? "default" : task.get("workerGroup").asText());
                long taskCode = CodeGenerateUtils.getInstance().genCode();
                taskDefinitionLog.setCode(taskCode);
                taskDefinitionLog.setVersion(1);
                taskDefinitionLog.setProjectCode(processDefinition2.getProjectCode());
                taskDefinitionLog.setUserId(processDefinition2.getUserId());
                taskDefinitionLog.setEnvironmentCode(-1L);
                taskDefinitionLog.setDelayTime(0);
                taskDefinitionLog.setOperator(1);
                taskDefinitionLog.setOperateTime(now);
                taskDefinitionLog.setCreateTime(now);
                taskDefinitionLog.setUpdateTime(now);
                taskDefinitionLogList.add(taskDefinitionLog);
                taskIdCodeMap.put(task.get("id").asText(), taskCode);
                List preTasks = JSONUtils.toList((String)task.get("preTasks").toString(), String.class);
                taskNamePreMap.put(name, preTasks);
                taskNameCodeMap.put(name, taskCode);
            }
            this.convertConditions(taskDefinitionLogList, taskNameCodeMap);
            taskDefinitionLogs.addAll(taskDefinitionLogList);
            processDefinition2.setLocations(this.convertLocations(processDefinition2.getLocations(), taskIdCodeMap));
            ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition2);
            processDefinitionLog.setOperator(1);
            processDefinitionLog.setOperateTime(now);
            processDefinitionLog.setUpdateTime(now);
            processDefinitionLogs.add(processDefinitionLog);
            this.handleProcessTaskRelation(taskNamePreMap, taskNameCodeMap, processDefinition2, processTaskRelationLogs);
            processCodeTaskNameCodeMap.put(processDefinition2.getCode(), taskNameCodeMap);
            processTaskMap.put(entry.getKey(), processCodeTaskNameCodeMap);
        }
    }

    public void convertConditions(List<TaskDefinitionLog> taskDefinitionLogList, Map<String, Long> taskNameCodeMap) throws Exception {
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogList) {
            if (!TaskType.CONDITIONS.getDesc().equals(taskDefinitionLog.getTaskType())) continue;
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode taskParams = JSONUtils.parseObject((String)taskDefinitionLog.getTaskParams());
            ObjectNode conditionResult = (ObjectNode)taskParams.get("conditionResult");
            List successNode = JSONUtils.toList((String)conditionResult.get("successNode").toString(), String.class);
            ArrayList nodeCode = new ArrayList();
            successNode.forEach(node -> nodeCode.add(taskNameCodeMap.get(node)));
            conditionResult.set("successNode", objectMapper.readTree(objectMapper.writeValueAsString(nodeCode)));
            List failedNode = JSONUtils.toList((String)conditionResult.get("failedNode").toString(), String.class);
            nodeCode.clear();
            failedNode.forEach(node -> nodeCode.add(taskNameCodeMap.get(node)));
            conditionResult.set("failedNode", objectMapper.readTree(objectMapper.writeValueAsString(nodeCode)));
            ObjectNode dependence = (ObjectNode)taskParams.get("dependence");
            ArrayNode dependTaskList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependence.get("dependTaskList")));
            for (int i = 0; i < dependTaskList.size(); ++i) {
                ObjectNode dependTask = (ObjectNode)dependTaskList.path(i);
                ArrayNode dependItemList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependTask.get("dependItemList")));
                for (int j = 0; j < dependItemList.size(); ++j) {
                    ObjectNode dependItem = (ObjectNode)dependItemList.path(j);
                    JsonNode depTasks = dependItem.get("depTasks");
                    dependItem.put("depTaskCode", taskNameCodeMap.get(depTasks.asText()));
                    dependItem.remove("depTasks");
                    dependItemList.set(j, (JsonNode)dependItem);
                }
                dependTask.put("dependItemList", (JsonNode)dependItemList);
                dependTaskList.set(i, (JsonNode)dependTask);
            }
            dependence.put("dependTaskList", (JsonNode)dependTaskList);
            taskDefinitionLog.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
        }
    }

    private String convertLocations(String locations, Map<String, Long> taskIdCodeMap) {
        if (StringUtils.isBlank((String)locations)) {
            return locations;
        }
        Map locationsMap = (Map)JSONUtils.parseObject((String)locations, (TypeReference)new TypeReference<Map<String, ObjectNode>>(){});
        if (locationsMap == null) {
            return locations;
        }
        ArrayNode jsonNodes = JSONUtils.createArrayNode();
        for (Map.Entry entry : locationsMap.entrySet()) {
            ObjectNode nodes = JSONUtils.createObjectNode();
            nodes.put("taskCode", taskIdCodeMap.get(entry.getKey()));
            ObjectNode oldNodes = (ObjectNode)entry.getValue();
            nodes.put("x", oldNodes.get("x").asInt());
            nodes.put("y", oldNodes.get("y").asInt());
            jsonNodes.add((JsonNode)nodes);
        }
        return jsonNodes.toString();
    }

    public void convertDependence(List<TaskDefinitionLog> taskDefinitionLogs, Map<Integer, Long> projectIdCodeMap, Map<Integer, Map<Long, Map<String, Long>>> processTaskMap) {
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (!TaskType.DEPENDENT.getDesc().equals(taskDefinitionLog.getTaskType())) continue;
            ObjectNode taskParams = JSONUtils.parseObject((String)taskDefinitionLog.getTaskParams());
            ObjectNode dependence = (ObjectNode)taskParams.get("dependence");
            ArrayNode dependTaskList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependence.get("dependTaskList")));
            for (int i = 0; i < dependTaskList.size(); ++i) {
                ObjectNode dependTask = (ObjectNode)dependTaskList.path(i);
                ArrayNode dependItemList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependTask.get("dependItemList")));
                for (int j = 0; j < dependItemList.size(); ++j) {
                    ObjectNode dependItem = (ObjectNode)dependItemList.path(j);
                    dependItem.put("projectCode", projectIdCodeMap.get(dependItem.get("projectId").asInt()));
                    int definitionId = dependItem.get("definitionId").asInt();
                    Map<Long, Map<String, Long>> processCodeTaskNameCodeMap = processTaskMap.get(definitionId);
                    if (processCodeTaskNameCodeMap == null) {
                        logger.warn("We can't find processDefinition [{}], please check it is not exist, remove this dependence", (Object)definitionId);
                        dependItemList.remove(j);
                        continue;
                    }
                    Optional mapEntry = processCodeTaskNameCodeMap.entrySet().stream().findFirst();
                    if (mapEntry.isPresent()) {
                        Map.Entry processCodeTaskNameCodeEntry = (Map.Entry)mapEntry.get();
                        dependItem.put("definitionCode", (Long)processCodeTaskNameCodeEntry.getKey());
                        String depTasks = dependItem.get("depTasks").asText();
                        long taskCode = "ALL".equals(depTasks) || processCodeTaskNameCodeEntry.getValue() == null ? 0L : (Long)((Map)processCodeTaskNameCodeEntry.getValue()).get(depTasks);
                        dependItem.put("depTaskCode", taskCode);
                    }
                    dependItem.remove("projectId");
                    dependItem.remove("definitionId");
                    dependItem.remove("depTasks");
                    dependItemList.set(j, (JsonNode)dependItem);
                }
                dependTask.put("dependItemList", (JsonNode)dependItemList);
                dependTaskList.set(i, (JsonNode)dependTask);
            }
            dependence.put("dependTaskList", (JsonNode)dependTaskList);
            taskDefinitionLog.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
        }
    }

    private void handleProcessTaskRelation(Map<String, List<String>> taskNamePreMap, Map<String, Long> taskNameCodeMap, ProcessDefinition processDefinition, List<ProcessTaskRelationLog> processTaskRelationLogs) {
        Date now = new Date();
        for (Map.Entry<String, List<String>> entry : taskNamePreMap.entrySet()) {
            List<String> entryValue = entry.getValue();
            if (CollectionUtils.isNotEmpty(entryValue)) {
                for (String preTaskName : entryValue) {
                    ProcessTaskRelationLog processTaskRelationLog = this.setProcessTaskRelationLog(processDefinition, now);
                    processTaskRelationLog.setPreTaskCode(taskNameCodeMap.get(preTaskName));
                    processTaskRelationLog.setPreTaskVersion(1);
                    processTaskRelationLog.setPostTaskCode(taskNameCodeMap.get(entry.getKey()));
                    processTaskRelationLog.setPostTaskVersion(1);
                    processTaskRelationLogs.add(processTaskRelationLog);
                }
                continue;
            }
            ProcessTaskRelationLog processTaskRelationLog = this.setProcessTaskRelationLog(processDefinition, now);
            processTaskRelationLog.setPreTaskCode(0L);
            processTaskRelationLog.setPreTaskVersion(0);
            processTaskRelationLog.setPostTaskCode(taskNameCodeMap.get(entry.getKey()));
            processTaskRelationLog.setPostTaskVersion(1);
            processTaskRelationLogs.add(processTaskRelationLog);
        }
    }

    private ProcessTaskRelationLog setProcessTaskRelationLog(ProcessDefinition processDefinition, Date now) {
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
        processTaskRelationLog.setProjectCode(processDefinition.getProjectCode());
        processTaskRelationLog.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelationLog.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelationLog.setConditionType(ConditionType.NONE);
        processTaskRelationLog.setConditionParams("{}");
        processTaskRelationLog.setOperator(1);
        processTaskRelationLog.setOperateTime(now);
        processTaskRelationLog.setCreateTime(now);
        processTaskRelationLog.setUpdateTime(now);
        return processTaskRelationLog;
    }
}

