/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.AlertEvent;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.AlertWarnLevel;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.AlertSendStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessAlertContent;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.ServerAlertContent;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertPluginInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertSendStatusMapper;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AlertDao {
    @Value(value="${alert.alarm-suppression.crash:60}")
    private Integer crashAlarmSuppression;
    @Autowired
    private AlertMapper alertMapper;
    @Autowired
    private AlertPluginInstanceMapper alertPluginInstanceMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    @Autowired
    private AlertSendStatusMapper alertSendStatusMapper;

    public int addAlert(Alert alert) {
        String sign = this.generateSign(alert);
        alert.setSign(sign);
        return this.alertMapper.insert(alert);
    }

    public int updateAlert(AlertStatus alertStatus, String log, int id) {
        Alert alert = new Alert();
        alert.setId(id);
        alert.setAlertStatus(alertStatus);
        alert.setUpdateTime(new Date());
        alert.setLog(log);
        return this.alertMapper.updateById(alert);
    }

    private String generateSign(Alert alert) {
        return Optional.of(alert).map(Alert::getContent).map(DigestUtils::sha1Hex).map(String::toLowerCase).orElse("");
    }

    public int addAlertSendStatus(AlertStatus sendStatus, String log, int alertId, int alertPluginInstanceId) {
        AlertSendStatus alertSendStatus = new AlertSendStatus();
        alertSendStatus.setAlertId(alertId);
        alertSendStatus.setAlertPluginInstanceId(alertPluginInstanceId);
        alertSendStatus.setSendStatus(sendStatus);
        alertSendStatus.setLog(log);
        alertSendStatus.setCreateTime(new Date());
        return this.alertSendStatusMapper.insert(alertSendStatus);
    }

    public void sendServerStoppedAlert(int alertGroupId, String host, String serverType) {
        ServerAlertContent serverStopAlertContent = ServerAlertContent.newBuilder().type(serverType).host(host).event(AlertEvent.SERVER_DOWN).warningLevel(AlertWarnLevel.SERIOUS).build();
        String content = JSONUtils.toJsonString((Object)Lists.newArrayList((Object[])new ServerAlertContent[]{serverStopAlertContent}));
        Alert alert = new Alert();
        alert.setTitle("Fault tolerance warning");
        alert.setWarningType(WarningType.FAILURE);
        alert.setAlertStatus(AlertStatus.WAIT_EXECUTION);
        alert.setContent(content);
        alert.setAlertGroupId(alertGroupId);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        alert.setAlertType(AlertType.FAULT_TOLERANCE_WARNING);
        alert.setSign(this.generateSign(alert));
        Date crashAlarmSuppressionStartTime = DateTime.now().plusMinutes(-this.crashAlarmSuppression.intValue()).toDate();
        this.alertMapper.insertAlertWhenServerCrash(alert, crashAlarmSuppressionStartTime);
    }

    public void sendProcessTimeoutAlert(ProcessInstance processInstance, ProjectUser projectUser) {
        int alertGroupId = processInstance.getWarningGroupId();
        Alert alert = new Alert();
        ArrayList<ProcessAlertContent> processAlertContentList = new ArrayList<ProcessAlertContent>(1);
        ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().projectCode(projectUser.getProjectCode()).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(processInstance.getId()).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).processType(processInstance.getCommandType()).processState(processInstance.getState()).runTimes(processInstance.getRunTimes()).processStartTime(processInstance.getStartTime()).processHost(processInstance.getHost()).event(AlertEvent.TIME_OUT).warningLevel(AlertWarnLevel.MIDDLE).build();
        processAlertContentList.add(processAlertContent);
        String content = JSONUtils.toJsonString(processAlertContentList);
        alert.setTitle("Process Timeout Warn");
        alert.setProjectCode(projectUser.getProjectCode());
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(AlertType.PROCESS_INSTANCE_TIMEOUT);
        this.saveTaskTimeoutAlert(alert, content, alertGroupId);
    }

    private void saveTaskTimeoutAlert(Alert alert, String content, int alertGroupId) {
        alert.setAlertGroupId(alertGroupId);
        alert.setWarningType(WarningType.FAILURE);
        alert.setContent(content);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        String sign = this.generateSign(alert);
        alert.setSign(sign);
        this.alertMapper.insert(alert);
    }

    public void sendTaskTimeoutAlert(ProcessInstance processInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        Alert alert = new Alert();
        ArrayList<ProcessAlertContent> processAlertContentList = new ArrayList<ProcessAlertContent>(1);
        ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().projectCode(projectUser.getProjectCode()).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(processInstance.getId()).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).taskCode(taskInstance.getTaskCode()).taskName(taskInstance.getName()).taskType(taskInstance.getTaskType()).taskStartTime(taskInstance.getStartTime()).taskHost(taskInstance.getHost()).event(AlertEvent.TIME_OUT).warningLevel(AlertWarnLevel.MIDDLE).build();
        processAlertContentList.add(processAlertContent);
        String content = JSONUtils.toJsonString(processAlertContentList);
        alert.setTitle("Task Timeout Warn");
        alert.setProjectCode(projectUser.getProjectCode());
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(AlertType.TASK_TIMEOUT);
        this.saveTaskTimeoutAlert(alert, content, processInstance.getWarningGroupId());
    }

    public List<Alert> listPendingAlerts() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new QueryWrapper((Object)new Alert()).lambda().eq(Alert::getAlertStatus, (Object)AlertStatus.WAIT_EXECUTION);
        return this.alertMapper.selectList((Wrapper)wrapper);
    }

    public AlertMapper getAlertMapper() {
        return this.alertMapper;
    }

    public List<AlertPluginInstance> listInstanceByAlertGroupId(int alertGroupId) {
        String alertInstanceIdsParam = this.alertGroupMapper.queryAlertGroupInstanceIdsById(alertGroupId);
        if (StringUtils.isNotBlank((CharSequence)alertInstanceIdsParam)) {
            String[] idsArray = alertInstanceIdsParam.split(",");
            List<Integer> ids = Arrays.stream(idsArray).map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
            return this.alertPluginInstanceMapper.queryByIds(ids);
        }
        return null;
    }

    public AlertPluginInstanceMapper getAlertPluginInstanceMapper() {
        return this.alertPluginInstanceMapper;
    }

    public void setAlertPluginInstanceMapper(AlertPluginInstanceMapper alertPluginInstanceMapper) {
        this.alertPluginInstanceMapper = alertPluginInstanceMapper;
    }

    public AlertGroupMapper getAlertGroupMapper() {
        return this.alertGroupMapper;
    }

    public void setAlertGroupMapper(AlertGroupMapper alertGroupMapper) {
        this.alertGroupMapper = alertGroupMapper;
    }

    public void setCrashAlarmSuppression(Integer crashAlarmSuppression) {
        this.crashAlarmSuppression = crashAlarmSuppression;
    }
}

