/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.MySQLPerformance;
import org.apache.dolphinscheduler.dao.utils.PostgreSQLPerformance;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorDBDao {
    private static final Logger logger = LoggerFactory.getLogger(MonitorDBDao.class);
    public static final String VARIABLE_NAME = "variable_name";
    @Autowired
    private DataSource dataSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MonitorRecord getCurrentDbPerformance() {
        try (Connection conn = this.dataSource.getConnection();){
            String driverClassName = DriverManager.getDriver(conn.getMetaData().getURL()).getClass().getName();
            if (driverClassName.contains(DbType.MYSQL.toString().toLowerCase())) {
                MonitorRecord monitorRecord = new MySQLPerformance().getMonitorRecord(conn);
                return monitorRecord;
            }
            if (!driverClassName.contains(DbType.POSTGRESQL.toString().toLowerCase())) return null;
            MonitorRecord monitorRecord = new PostgreSQLPerformance().getMonitorRecord(conn);
            return monitorRecord;
        }
        catch (Exception e) {
            logger.error("SQLException: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    public List<MonitorRecord> queryDatabaseState() {
        ArrayList<MonitorRecord> list = new ArrayList<MonitorRecord>(1);
        MonitorRecord monitorRecord = this.getCurrentDbPerformance();
        if (monitorRecord != null) {
            list.add(monitorRecord);
        }
        return list;
    }
}

